*                                                                                  ;
*    Reading in the 2005 PSID data                                                 ;
*                                                                                  ;
*            Karen Dynan 6/15/07                                                   ;
*                                                                                  ;
*    We read it all in and then output select variables to a flat                  ;
*    file to be picked up by STATA.                                                ;
*                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam05.raw' ;

PROC PRINTTO LOG='F:\PSID\logfiles\readfam05.log' NEW;
RUN;

PROC PRINTTO PRINT='F:\PSID\logfiles\readfam05.lst' NEW;
RUN; 

 
data one;
   ATTRIB 
      ER25001             FORMAT=1.   LABEL="RELEASE NUMBER"                          
      ER25002             FORMAT=5.   LABEL="2005 FAMILY INTERVIEW (ID) NUMBER"       
      ER25003             FORMAT=2.   LABEL="PSID STATE OF RESIDENCE CODE"            
      ER25004             FORMAT=2.   LABEL="CURRENT STATE"                           
      ER25005             FORMAT=1.   LABEL="SPLITOFF INDICATOR"                      
      ER25006             FORMAT=1.   LABEL="MODE OF INTERVIEW"                       
      ER25007             FORMAT=1.   LABEL="FAMILY COMPOSITION CHANGE"               
      ER25008             FORMAT=1.   LABEL="TYPE INSTITUTION"                        
      ER25009             FORMAT=4.   LABEL="1968 FAMILY IDENTIFIER"                  
      ER25010             FORMAT=1.   LABEL="WTR REINSTATED DROPPED FAMILY"           
      ER25011             FORMAT=8.   LABEL="INTERVIEWER ID"                          
      ER25012             FORMAT=2.   LABEL="MONTH  CURRENT IW"                       
      ER25013             FORMAT=2.   LABEL="DAY CURRENT IW"                          
      ER25014             FORMAT=4.   LABEL="YEAR CURRENT IW"                         
      ER25015             FORMAT=3.   LABEL="LENGTH OF IW IN MINUTES"                 
      ER25016             FORMAT=2.   LABEL="# IN FU"                                 
      ER25017             FORMAT=3.   LABEL="AGE OF HEAD"                             
      ER25018             FORMAT=1.   LABEL="SEX OF HEAD"                             
      ER25019             FORMAT=3.   LABEL="AGE OF WIFE"                             
      ER25020             FORMAT=2.   LABEL="# CHILDREN IN FU"                        
      ER25021             FORMAT=3.   LABEL="AGE YOUNGEST CHILD"                      
      ER25022             FORMAT=2.   LABEL="# NONFU SHARING HU"                      
      ER25023             FORMAT=1.   LABEL="HEAD MARITAL STATUS"                     
      ER25024             FORMAT=1.   LABEL="A4 TYPE DU"                              
      ER25025             FORMAT=1.   LABEL="A6 LIVE IN ELDERLY HSNG"                 
      ER25026             FORMAT=1.   LABEL="A7 TYPE ELDERLY HSNG"                    
      ER25027             FORMAT=2.   LABEL="A8 ACTUAL # ROOMS"                       
      ER25028             FORMAT=1.   LABEL="A19 OWN/RENT OR WHAT"                    
      ER25029             FORMAT=7.   LABEL="A20 HOUSE VALUE"                         
      ER25030             FORMAT=1.   LABEL="ACCURACY OF HOUSE VALUE"                 
      ER25031             FORMAT=1.   LABEL="A20A WTR HOUSE WORTH 100,000+"           
      ER25032             FORMAT=1.   LABEL="A20B WTR HOUSE WORTH 200,000+"           
      ER25033             FORMAT=1.   LABEL="A20C WTR HOUSE WORTH 400,000+"           
      ER25034             FORMAT=1.   LABEL="A20D WTR HOUSE WORTH 75,000+"            
      ER25035             FORMAT=1.   LABEL="A20E WTR HOUSE WORTH 25,000+"            
      ER25036             FORMAT=5.   LABEL="A21 ANNUAL PROPERTY TAX"                 
      ER25037             FORMAT=1.   LABEL="ACCURACY OF ANNUAL PROPERTY TAX"         
      ER25038             FORMAT=4.   LABEL="A22 ANNUAL OWNR INSURANC"                
      ER25039             FORMAT=1.   LABEL="A23 HAVE MORTGAGE?"                      
      ER25040             FORMAT=1.   LABEL="A23A TYPE MORTGAGE MOR 1"                
      ER25041             FORMAT=1.   LABEL="A23B WTR ORIGINAL LOAN/REFINANCED #1"    
      ER25042             FORMAT=7.   LABEL="A24 REM PRINCIPAL MOR 1"                 
      ER25043             FORMAT=1.   LABEL="ACCURACY OF REMAINING MORTGAGE PRIN #1"  
      ER25044             FORMAT=5.   LABEL="A25 MNTHLY PMTS MOR   1"                 
      ER25045             FORMAT=1.   LABEL="ACCURACY OF MONTHLY PYMNTS ON MTGE #1"   
      ER25046             FORMAT=2.   LABEL="A25A CURR INTEREST RATE WHOLE PERCENT #1"
      ER25047             FORMAT=3.   LABEL="A25A CURR INT RATE DECIMAL FRACTION #1"  
      ER25048             FORMAT=4.   LABEL="A26 YEAR OBTAINED LOAN #1"               
      ER25049             FORMAT=2.   LABEL="A27 YRS TO PAY MOR    1"                 
      ER25050             FORMAT=1.   LABEL="A28 2ND MORTGAGE"                        
      ER25051             FORMAT=1.   LABEL="A23A TYPE MORTGAGE MOR 2"                
      ER25052             FORMAT=1.   LABEL="A23B WTR ORIGINAL LOAN/REFINANCED #2"    
      ER25053             FORMAT=7.   LABEL="A24 REM PRINCIPAL MOR 2"                 
      ER25054             FORMAT=1.   LABEL="ACCURACY OF REMAINING MORTGAGE PRIN #2"  
      ER25055             FORMAT=5.   LABEL="A25 MNTHLY PMTS MOR   2"                 
      ER25056             FORMAT=1.   LABEL="ACCURACY OF MONTHLY PYMNTS ON MTGE #2"   
      ER25057             FORMAT=2.   LABEL="A25A CURR INTEREST RATE WHOLE PERCENT #2"
      ER25058             FORMAT=3.   LABEL="A25A CURR INT RATE DECIMAL FRACTION #2"  
      ER25059             FORMAT=4.   LABEL="A26 YEAR OBTAINED LOAN #2"               
      ER25060             FORMAT=2.   LABEL="A27 YRS TO PAY MOR    2"                 
      ER25061             FORMAT=1.   LABEL="A29 MTG INCL PROP TAXES"                 
      ER25062             FORMAT=1.   LABEL="A30 MTG INCL INS PREM"                   
      ER25063             FORMAT=5.   LABEL="A31 DOLLARS RENT"                        
      ER25064             FORMAT=1.   LABEL="A31 DOLLLARS PER WHAT"                   
      ER25065             FORMAT=1.   LABEL="ACCURACY OF RENT"                        
      ER25066             FORMAT=1.   LABEL="A31A FURNISHED APT/HOUSE"                
      ER25067             FORMAT=1.   LABEL="A31B RENT INCL HEAT"                     
      ER25068             FORMAT=1.   LABEL="A32 IN PUBLIC OWND PROJ?"                
      ER25069             FORMAT=1.   LABEL="A33 GOVT PAY PART RENT?"                 
      ER25070             FORMAT=4.   LABEL="A35 DOLLARS RENT IF RENT"                
      ER25071             FORMAT=1.   LABEL="A35 DOLLARS PER WHAT"                    
      ER25072             FORMAT=1.   LABEL="ACCURACY OF VALUE IF RENTED"             
      ER25073             FORMAT=1.   LABEL="A36 IN PUBLIC OWND PROJ?"                
      ER25074             FORMAT=1.   LABEL="A37 GOVT PAY ALL RENT?"                  
      ER25075             FORMAT=1.   LABEL="A38 HAVE AIR CONDITNG"                   
      ER25076             FORMAT=1.   LABEL="A39 A/C ALL OR SOME ROOM"                
      ER25077             FORMAT=2.   LABEL="A40 TYPE HEATING 1ST MENTION"            
      ER25078             FORMAT=2.   LABEL="A40 TYPE HEATING 2ND MENTION"            
      ER25079             FORMAT=2.   LABEL="A40 TYPE HEATING 3RD MENTION"            
      ER25080             FORMAT=4.   LABEL="A41 HEATING FUEL EXPENSE"                
      ER25081             FORMAT=1.   LABEL="A41 HEATING FUEL EXPENSE PER"            
      ER25082             FORMAT=4.   LABEL="A42 ELECTRICITY EXPENSE"                 
      ER25083             FORMAT=1.   LABEL="A42 ELECTRICITY PER"                     
      ER25084             FORMAT=4.   LABEL="A43WATER/SEWER EXPENSE"                  
      ER25085             FORMAT=1.   LABEL="A43 WATER/SEWER EXPENSE PER"             
      ER25086             FORMAT=4.   LABEL="A44 TELEPHONE EXPENSE"                   
      ER25087             FORMAT=1.   LABEL="A44 TELEPHONE EXPENSE PER"               
      ER25088             FORMAT=1.   LABEL="A45 WTR OTR UTILITY EXP"                 
      ER25089             FORMAT=1.   LABEL="A45A GARBAGE EXPENSE"                    
      ER25090             FORMAT=3.   LABEL="A45B TOTAL OTR UTILITIES"                
      ER25091             FORMAT=1.   LABEL="A45B OTR UTILITIES PER"                  
      ER25092             FORMAT=1.   LABEL="A46 RECD GOVT HTG SUBSDY"                
      ER25093             FORMAT=4.   LABEL="A46A AMT GOVT HTG SUBSDY"                
      ER25094             FORMAT=1.   LABEL="A47A WTR COMPUTER IN HOME-HD"            
      ER25095             FORMAT=1.   LABEL="A47B WTR USED INTERNET-HD"               
      ER25096             FORMAT=1.   LABEL="A47A WTR COMPUTER IN HOME-WF"            
      ER25097             FORMAT=1.   LABEL="A47B WTR USED INTERNET-WF"               
      ER25098             FORMAT=1.   LABEL="A49 WTR MOVED SINCE JAN 1 OF PRIOR YEAR" 
      ER25099             FORMAT=2.   LABEL="A49 MONTH MOVED"                         
      ER25100             FORMAT=4.   LABEL="A49 YEAR MOVED"                          
      ER25101             FORMAT=2.   LABEL="A50 WHY MOVED 1ST"                       
      ER25102             FORMAT=1.   LABEL="A51 WTR MIGHT MOVE"                      
      ER25103             FORMAT=1.   LABEL="A52 LIKELIHOOD OF MOVING"                
      ER25104             FORMAT=2.   LABEL="BC1 EMPLOYMENT STATUS-1ST MENTION"       
      ER25105             FORMAT=2.   LABEL="BC1 EMPLOYMENT STATUS-2ND MENTION"       
      ER25106             FORMAT=2.   LABEL="BC1 EMPLOYMENT STATUS-3RD MENTION"       
      ER25107             FORMAT=4.   LABEL="BC2 YEAR RETIRED"                        
      ER25108             FORMAT=1.   LABEL="BC3 WTR WORK FOR MONEY"                  
      ER25109             FORMAT=1.   LABEL="BC3A WTR WORKD SINCE JAN 1 OF PRIOR YEAR"
      ER25110             FORMAT=1.   LABEL="BC16-17 MAIN JOB INDICATOR"              
      ER25111             FORMAT=2.   LABEL="BC6 BEGINNING MONTH--JOB 1"              
      ER25112             FORMAT=4.   LABEL="BC6 BEGINNING YEAR--JOB 1"               
      ER25113             FORMAT=2.   LABEL="BC6 ENDING MONTH--JOB 1"                 
      ER25114             FORMAT=4.   LABEL="BC6 ENDING YEAR--JOB 1"                  
      ER25115             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 JAN"             
      ER25116             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 FEB"             
      ER25117             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 MAR"             
      ER25118             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 APR"             
      ER25119             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 MAY"             
      ER25120             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 JUN"             
      ER25121             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 JUL"             
      ER25122             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 AUG"             
      ER25123             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 SEP"             
      ER25124             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 OCT"             
      ER25125             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 NOV"             
      ER25126             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 1 DEC"             
      ER25127             FORMAT=3.   LABEL="BC20 MAIN OCC FOR JOB 1: 2000 CODE (HD)" 
      ER25128             FORMAT=3.   LABEL="BC21 MAIN IND FOR JOB 1: 2000 CODE (HD)" 
      ER25129             FORMAT=1.   LABEL="BC22 WORK SELF/OTR?--JOB 1"              
      ER25130             FORMAT=1.   LABEL="BC23 CORP/UNCORP BUS--JOB 1"             
      ER25131             FORMAT=1.   LABEL="BC24 WORK FOR GOVT?--JOB 1"              
      ER25132             FORMAT=9.   LABEL="BC25A NUMBER EMPLOYED AT WORK LOCATION"  
      ER25133             FORMAT=1.   LABEL="BC25B WTR 200 OR MORE"                   
      ER25134             FORMAT=1.   LABEL="BC25C WTR 100 OR MORE"                   
      ER25135             FORMAT=1.   LABEL="BC25D WTR 50 OR MORE"                    
      ER25136             FORMAT=1.   LABEL="BC25E WTR 500 OR MORE"                   
      ER25137             FORMAT=1.   LABEL="BC25F WTR 1000 OR MORE"                  
      ER25138             FORMAT=1.   LABEL="BC26 JOB NOW UNION? (H-E)"               
      ER25139             FORMAT=1.   LABEL="BC27 BELONG UNION? (HD-E)"               
      ER25140             FORMAT=1.   LABEL="BC28A WTR JOB REQUIRES COMPUTER USE"     
      ER25141             FORMAT=1.   LABEL="BC29 SLRY/HRLY/OTR (H-E)"                
      ER25142             FORMAT=10.2 LABEL="BC30 SALARY AMOUNT"                      
      ER25143             FORMAT=1.   LABEL="BC30 SALARY PER WHAT"                    
      ER25144             FORMAT=1.   LABEL="BC31 WTR SAL PD OT (HD-E)"               
      ER25145             FORMAT=1.   LABEL="BC32 HOW PAID FOR OT"                    
      ER25146             FORMAT=10.2 LABEL="BC32A EXACT OT PAY IF SALARIED"          
      ER25147             FORMAT=1.   LABEL="BC32A EXACT OT PAY PER"                  
      ER25148             FORMAT=6.2  LABEL="BC33 HOURLY REGULAR RATE"                
      ER25149             FORMAT=1.   LABEL="BC34 OT DIFFERENTIAL 1ST"                
      ER25150             FORMAT=1.   LABEL="BC34 OT DIFFERENTIAL 2ND"                
      ER25151             FORMAT=1.   LABEL="BC34 OT DIFFERENTIAL 3RD"                
      ER25152             FORMAT=10.2 LABEL="BC34A EXACT OT PAY IF HOURLY"            
      ER25153             FORMAT=1.   LABEL="BC34A EXACT OT PAY PER"                  
      ER25154             FORMAT=8.2  LABEL="BC36 AVG TIPS/COMM"                      
      ER25155             FORMAT=1.   LABEL="BC36 TIPS/COMM PER WHAT"                 
      ER25156             FORMAT=7.   LABEL="BC37 AVG TIPS/COMM"                      
      ER25157             FORMAT=1.   LABEL="BC37 TIPS/COMM PER WHAT"                 
      ER25158             FORMAT=1.   LABEL="BC38 HOW PAID-OTR (HD-E)"                
      ER25159             FORMAT=9.2  LABEL="BC39 OT RATE"                            
      ER25160             FORMAT=2.   LABEL="BC41 YRS PRES EMP (H-E)"                 
      ER25161             FORMAT=2.   LABEL="BC41 MOS PRES EMP (H-E)"                 
      ER25162             FORMAT=2.   LABEL="BC41 WKS PRES EMP (H-E)"                 
      ER25163             FORMAT=2.   LABEL="CALCULATED ELAPSED WEEKS--HD JOB 1"      
      ER25164             FORMAT=1.   LABEL="ACCURACY OF ELAPSED WEEKS--HD JOB 1"     
      ER25165             FORMAT=3.   LABEL="BC43 HOURS/WEEK WORKED--JOB 1"           
      ER25166             FORMAT=1.   LABEL="ACCURACY OF HR/WK WORKED--HD JOB 1"      
      ER25167             FORMAT=1.   LABEL="BC44 WTR WORKED OT--JOB 1"               
      ER25168             FORMAT=4.   LABEL="BC45 AMT OF OT WORKED--JOB 1"            
      ER25169             FORMAT=1.   LABEL="BC45 OT TIME UNIT--JOB 1"                
      ER25170             FORMAT=1.   LABEL="ACCURACY OF OT--HD JOB 1"                
      ER25171             FORMAT=10.2 LABEL="BC46 AMOUNT EARNED LAST YEAR--JOB 1"     
      ER25172             FORMAT=1.   LABEL="BC46 PER FOR AMT EARNED LAST YR--JOB 1"  
      ER25173             FORMAT=1.   LABEL="BC51 WHY LAST JOB END (HD-U)"            
      ER25174             FORMAT=2.   LABEL="BC6 BEGINNING MONTH--JOB 2"              
      ER25175             FORMAT=4.   LABEL="BC6 BEGINNING YEAR--JOB 2"               
      ER25176             FORMAT=2.   LABEL="BC6 ENDING MONTH--JOB 2"                 
      ER25177             FORMAT=4.   LABEL="BC6 ENDING YEAR--JOB 2"                  
      ER25178             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 JAN"             
      ER25179             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 FEB"             
      ER25180             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 MAR"             
      ER25181             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 APR"             
      ER25182             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 MAY"             
      ER25183             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 JUN"             
      ER25184             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 JUL"             
      ER25185             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 AUG"             
      ER25186             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 SEP"             
      ER25187             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 OCT"             
      ER25188             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 NOV"             
      ER25189             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 2 DEC"             
      ER25190             FORMAT=3.   LABEL="BC20 MAIN OCC FOR JOB 2: 2000 CODE (HD)" 
      ER25191             FORMAT=3.   LABEL="BC21 MAIN IND FOR JOB 2: 2000 CODE (HD)" 
      ER25192             FORMAT=1.   LABEL="BC22 WORK SELF/OTR?--JOB 2"              
      ER25193             FORMAT=1.   LABEL="BC23 CORP/UNCORP BUS--JOB 2"             
      ER25194             FORMAT=1.   LABEL="BC24 WORK FOR GOVT?--JOB 2"              
      ER25195             FORMAT=2.   LABEL="CALCULATED ELAPSED WEEKS--HD JOB 2"      
      ER25196             FORMAT=1.   LABEL="ACCURACY OF ELAPSED WEEKS--HD JOB 2"     
      ER25197             FORMAT=3.   LABEL="BC43 HOURS/WEEK WORKED--JOB 2"           
      ER25198             FORMAT=1.   LABEL="ACCURACY OF HR/WK WORKED--HD JOB 2"      
      ER25199             FORMAT=1.   LABEL="BC44 WTR WORKED OT--JOB 2"               
      ER25200             FORMAT=4.   LABEL="BC45 AMT OF OT WORKED--JOB 2"            
      ER25201             FORMAT=1.   LABEL="BC45 OT TIME UNIT--JOB 2"                
      ER25202             FORMAT=1.   LABEL="ACCURACY OF OT--HD JOB 2"                
      ER25203             FORMAT=10.2 LABEL="BC46 AMOUNT EARNED LAST YEAR--JOB 2"     
      ER25204             FORMAT=1.   LABEL="BC46 PER FOR AMT EARNED LAST YR--JOB 2"  
      ER25205             FORMAT=1.   LABEL="BC51 WHY JOB ENDED--JOB 2"               
      ER25206             FORMAT=2.   LABEL="BC6 BEGINNING MONTH--JOB 3"              
      ER25207             FORMAT=4.   LABEL="BC6 BEGINNING YEAR--JOB 3"               
      ER25208             FORMAT=2.   LABEL="BC6 ENDING MONTH--JOB 3"                 
      ER25209             FORMAT=4.   LABEL="BC6 ENDING YEAR--JOB 3"                  
      ER25210             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 JAN"             
      ER25211             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 FEB"             
      ER25212             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 MAR"             
      ER25213             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 APR"             
      ER25214             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 MAY"             
      ER25215             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 JUN"             
      ER25216             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 JUL"             
      ER25217             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 AUG"             
      ER25218             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 SEP"             
      ER25219             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 OCT"             
      ER25220             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 NOV"             
      ER25221             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 3 DEC"             
      ER25222             FORMAT=3.   LABEL="BC20 MAIN OCC FOR JOB 3: 2000 CODE (HD)" 
      ER25223             FORMAT=3.   LABEL="BC21 MAIN IND FOR JOB 3: 2000 CODE (HD)" 
      ER25224             FORMAT=1.   LABEL="BC22 WORK SELF/OTR?--JOB 3"              
      ER25225             FORMAT=1.   LABEL="BC23 CORP/UNCORP BUS--JOB 3"             
      ER25226             FORMAT=1.   LABEL="BC24 WORK FOR GOVT?--JOB 3"              
      ER25227             FORMAT=2.   LABEL="CALCULATED ELAPSED WEEKS--HD JOB 3"      
      ER25228             FORMAT=1.   LABEL="ACCURACY OF ELAPSED WEEKS--HD JOB 3"     
      ER25229             FORMAT=3.   LABEL="BC43 HOURS/WEEK WORKED--JOB 3"           
      ER25230             FORMAT=1.   LABEL="ACCURACY OF HR/WK WORKED--HD JOB 3"      
      ER25231             FORMAT=1.   LABEL="BC44 WTR WORKED OT--JOB 3"               
      ER25232             FORMAT=4.   LABEL="BC45 AMT OF OT WORKED--JOB 3"            
      ER25233             FORMAT=1.   LABEL="BC45 OT TIME UNIT--JOB 3"                
      ER25234             FORMAT=1.   LABEL="ACCURACY OF OT--HD JOB 3"                
      ER25235             FORMAT=10.2 LABEL="BC46 AMOUNT EARNED LAST YEAR--JOB 3"     
      ER25236             FORMAT=1.   LABEL="BC46 PER FOR AMT EARNED LAST YR--JOB 3"  
      ER25237             FORMAT=1.   LABEL="BC51 WHY JOB ENDED--JOB 3"               
      ER25238             FORMAT=2.   LABEL="BC6 BEGINNING MONTH--JOB 4"              
      ER25239             FORMAT=4.   LABEL="BC6 BEGINNING YEAR--JOB 4"               
      ER25240             FORMAT=2.   LABEL="BC6 ENDING MONTH--JOB 4"                 
      ER25241             FORMAT=4.   LABEL="BC6 ENDING YEAR--JOB 4"                  
      ER25242             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 JAN"             
      ER25243             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 FEB"             
      ER25244             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 MAR"             
      ER25245             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 APR"             
      ER25246             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 MAY"             
      ER25247             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 JUN"             
      ER25248             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 JUL"             
      ER25249             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 AUG"             
      ER25250             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 SEP"             
      ER25251             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 OCT"             
      ER25252             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 NOV"             
      ER25253             FORMAT=1.   LABEL="BC6 WTR EMPLOYED--JOB 4 DEC"             
      ER25254             FORMAT=3.   LABEL="BC20 MAIN OCC FOR JOB 4: 2000 CODE (HD)" 
      ER25255             FORMAT=3.   LABEL="BC21 MAIN IND FOR JOB 4: 2000 CODE (HD)" 
      ER25256             FORMAT=1.   LABEL="BC22 WORK SELF/OTR?--JOB 4"              
      ER25257             FORMAT=1.   LABEL="BC23 CORP/UNCORP BUS--JOB 4"             
      ER25258             FORMAT=1.   LABEL="BC24 WORK FOR GOVT?--JOB 4"              
      ER25259             FORMAT=2.   LABEL="CALCULATED ELAPSED WEEKS--HD JOB 4"      
      ER25260             FORMAT=1.   LABEL="ACCURACY OF ELAPSED WEEKS--HD JOB 4"     
      ER25261             FORMAT=3.   LABEL="BC43 HOURS/WEEK WORKED--JOB 4"           
      ER25262             FORMAT=1.   LABEL="ACCURACY OF HR/WK WORKED--HD JOB 4"      
      ER25263             FORMAT=1.   LABEL="BC44 WTR WORKED OT--JOB 4"               
      ER25264             FORMAT=4.   LABEL="BC45 AMT OF OT WORKED--JOB 4"            
      ER25265             FORMAT=1.   LABEL="BC45 OT TIME UNIT--JOB 4"                
      ER25266             FORMAT=1.   LABEL="ACCURACY OF OT--HD JOB 4"                
      ER25267             FORMAT=10.2 LABEL="BC46 AMOUNT EARNED LAST YEAR--JOB 4"     
      ER25268             FORMAT=1.   LABEL="BC46 PER FOR AMT EARNED LAST YR--JOB 4"  
      ER25269             FORMAT=1.   LABEL="BC51 WHY JOB ENDED--JOB 4"               
      ER25270             FORMAT=1.   LABEL="NUMBER OF ADDITIONAL JOBS--HD"           
      ER25271             FORMAT=1.   LABEL="BC10 WTR OTRS ILL (HD)"                  
      ER25272             FORMAT=3.   LABEL="BC10 DAYS OTHERS SICK"                   
      ER25273             FORMAT=1.   LABEL="ACCURACY OF DAYS OTRS SICK (HD)"         
      ER25274             FORMAT=2.   LABEL="BC10 WEEKS OTHERS SICK"                  
      ER25275             FORMAT=1.   LABEL="ACCURACY OF WEEKS OTRS SICK (HD)"        
      ER25276             FORMAT=2.   LABEL="BC10 MONTHS OTHERS SICK"                 
      ER25277             FORMAT=1.   LABEL="ACCURACY OF MONTHS OTRS SICK (HD)"       
      ER25278             FORMAT=1.   LABEL="BC11 WTR SELF ILL (HD)"                  
      ER25279             FORMAT=3.   LABEL="BC11 DAYS SELF SICK"                     
      ER25280             FORMAT=1.   LABEL="ACCURACY OF DAYS SELF ILL (HD)"          
      ER25281             FORMAT=2.   LABEL="BC11 WEEKS SELF SICK"                    
      ER25282             FORMAT=1.   LABEL="ACCURACY OF WEEKS SELF ILL (HD)"         
      ER25283             FORMAT=2.   LABEL="BC11 MONTHS SELF SICK"                   
      ER25284             FORMAT=1.   LABEL="ACCURACY OF MONTHS SELF ILL (HD)"        
      ER25285             FORMAT=1.   LABEL="BC12 WTR VACATION (HD)"                  
      ER25286             FORMAT=3.   LABEL="BC12 DAYS VACATION"                      
      ER25287             FORMAT=1.   LABEL="ACCURACY OF DAYS VACATION (HD)"          
      ER25288             FORMAT=2.   LABEL="BC12 WEEKS VACATION"                     
      ER25289             FORMAT=1.   LABEL="ACCURACY OF WEEKS VACATION (HD)"         
      ER25290             FORMAT=2.   LABEL="BC12 MONTHS VACATION"                    
      ER25291             FORMAT=1.   LABEL="ACCURACY OF MONTHS VACATION (HD)"        
      ER25292             FORMAT=1.   LABEL="BC13 WTR STRIKE (HD)"                    
      ER25293             FORMAT=3.   LABEL="BC13 DAYS STRIKE"                        
      ER25294             FORMAT=1.   LABEL="ACCURACY OF STRIKE DAYS (HD)"            
      ER25295             FORMAT=2.   LABEL="BC13 WEEKS STRIKE"                       
      ER25296             FORMAT=1.   LABEL="ACCURACY OF STRIKE WEEKS (HD)"           
      ER25297             FORMAT=2.   LABEL="BC13 MONTHS STRIKE"                      
      ER25298             FORMAT=1.   LABEL="ACCURACY OF STRIKE MONTHS (HD)"          
      ER25299             FORMAT=1.   LABEL="BC14 WTR LAID OFF (HD)"                  
      ER25300             FORMAT=3.   LABEL="BC14 DAYS LAID OFF"                      
      ER25301             FORMAT=1.   LABEL="ACCURACY OF DAYS LAID OFF (HD)"          
      ER25302             FORMAT=2.   LABEL="BC14 WEEKS LAID OFF"                     
      ER25303             FORMAT=1.   LABEL="ACCURACY OF WEEKS LAID OFF (HD)"         
      ER25304             FORMAT=2.   LABEL="BC14 MONTHS LAID OFF"                    
      ER25305             FORMAT=1.   LABEL="ACCURACY OF MONTHS LAID OFF (HD)"        
      ER25306             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED(HD)"                  
      ER25307             FORMAT=3.   LABEL="BC8 DAYS UNEMPLOYED"                     
      ER25308             FORMAT=1.   LABEL="ACCURACY OF DAYS UNEMPLOYED (HD)"        
      ER25309             FORMAT=2.   LABEL="BC8 WEEKS UNEMPLOYED"                    
      ER25310             FORMAT=1.   LABEL="ACCURACY OF WEEKS UNEMPLOYED (HD)"       
      ER25311             FORMAT=2.   LABEL="BC8 MONTHS UNEMPLOYED"                   
      ER25312             FORMAT=1.   LABEL="ACCURACY OF MONTHS UNEMPLOYED (HD)"      
      ER25313             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED JAN"                  
      ER25314             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED FEB"                  
      ER25315             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED MAR"                  
      ER25316             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED APR"                  
      ER25317             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED MAY"                  
      ER25318             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED JUN"                  
      ER25319             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED JUL"                  
      ER25320             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED AUG"                  
      ER25321             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED SEP"                  
      ER25322             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED OCT"                  
      ER25323             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED NOV"                  
      ER25324             FORMAT=1.   LABEL="BC8 WTR UNEMPLOYED DEC"                  
      ER25325             FORMAT=1.   LABEL="BC7 WTR OUT LAB FRC(H)"                  
      ER25326             FORMAT=3.   LABEL="BC7 DAYS OUT OF LAB FORCE"               
      ER25327             FORMAT=1.   LABEL="ACCURACY OF DAYS OUT OF LAB FORCE (HD)"  
      ER25328             FORMAT=2.   LABEL="BC7WEEKS OUT LABOR FORCE"                
      ER25329             FORMAT=1.   LABEL="ACCURACY OF WKS OUT OF LAB FORCE (HD)"   
      ER25330             FORMAT=2.   LABEL="BC7 MONTHS OUT LABR FORCE"               
      ER25331             FORMAT=1.   LABEL="ACCURACY OF MOS OUT OF LAB FORCE (HD)"   
      ER25332             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC JAN"                
      ER25333             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC FEB"                
      ER25334             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC MAR"                
      ER25335             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC APR"                
      ER25336             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC MAY"                
      ER25337             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC JUN"                
      ER25338             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC JUL"                
      ER25339             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC AUG"                
      ER25340             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC SEP"                
      ER25341             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC OCT"                
      ER25342             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC NOV"                
      ER25343             FORMAT=1.   LABEL="BC7 WTR OUT LAB FORC DEC"                
      ER25344             FORMAT=2.   LABEL="BC54 TOTAL WEEKS WORKED"                 
      ER25345             FORMAT=3.   LABEL="BC56 TOTAL HOURS WORKED"                 
      ER25346             FORMAT=1.   LABEL="BC62 WTR EVER WORKED"                    
      ER25347             FORMAT=2.   LABEL="BC63 MO LAST WORKED"                     
      ER25348             FORMAT=4.   LABEL="BC63 YR LAST WORKED"                     
      ER25349             FORMAT=1.   LABEL="BC64 WTR LOOKING FOR JOB"                
      ER25350             FORMAT=1.   LABEL="BC65 WTR PUBLIC EMP AGENCY (HD)"         
      ER25351             FORMAT=1.   LABEL="BC65 WTR PRIVATE EMP AGENCY (HD)"        
      ER25352             FORMAT=1.   LABEL="BC65 WTR CHKD W/CURRENT EMP (HD)"        
      ER25353             FORMAT=1.   LABEL="BC65 WTR CHKD W/OTHER EMP (HD)"          
      ER25354             FORMAT=1.   LABEL="BC65 WTR CHKD W/FRIEND OR REL (HD)"      
      ER25355             FORMAT=1.   LABEL="BC65 WTR PLACED OR ANSWERED ADS (HD)"    
      ER25356             FORMAT=1.   LABEL="BC65 WTR OTHER ACTIVITY (HD)"            
      ER25357             FORMAT=1.   LABEL="BC65 WTR DONE NOTHING (HD)"              
      ER25358             FORMAT=2.   LABEL="BC67 YRS LOOK WRK (H-U)"                 
      ER25359             FORMAT=2.   LABEL="BC67 MOS LOOK WRK (H-U)"                 
      ER25360             FORMAT=2.   LABEL="BC67 WKS LOOK WRK (H-U)"                 
      ER25361             FORMAT=1.   LABEL="DE1 CKPT: WTR WIFE IN FU"                
      ER25362             FORMAT=2.   LABEL="DE1 EMPLOYMENT STATUS-1ST MENTION"       
      ER25363             FORMAT=2.   LABEL="DE1 EMPLOYMENT STATUS-2ND MENTION"       
      ER25364             FORMAT=2.   LABEL="DE1 EMPLOYMENT STATUS-3RD MENTION"       
      ER25365             FORMAT=4.   LABEL="DE2 YEAR RETIRED (WF-R)"                 
      ER25366             FORMAT=1.   LABEL="DE3 WTR WORK FOR MONEY"                  
      ER25367             FORMAT=1.   LABEL="DE3A WTR WORKD SINCE JAN 1 OF PRIOR YEAR"
      ER25368             FORMAT=1.   LABEL="DE16-17 MAIN JOB INDICATOR"              
      ER25369             FORMAT=2.   LABEL="DE6 BEGINNING MONTH--JOB 1"              
      ER25370             FORMAT=4.   LABEL="DE6 BEGINNING YEAR--JOB 1"               
      ER25371             FORMAT=2.   LABEL="DE6 ENDING MONTH--JOB 1"                 
      ER25372             FORMAT=4.   LABEL="DE6 ENDING YEAR--JOB 1"                  
      ER25373             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 JAN"             
      ER25374             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 FEB"             
      ER25375             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 MAR"             
      ER25376             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 APR"             
      ER25377             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 MAY"             
      ER25378             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 JUN"             
      ER25379             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 JUL"             
      ER25380             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 AUG"             
      ER25381             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 SEP"             
      ER25382             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 OCT"             
      ER25383             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 NOV"             
      ER25384             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 1 DEC"             
      ER25385             FORMAT=3.   LABEL="DE20 MAIN OCC FOR JOB 1: 2000 CODE (WF)" 
      ER25386             FORMAT=3.   LABEL="DE21 MAIN IND FOR JOB 1: 2000 CODE (WF)" 
      ER25387             FORMAT=1.   LABEL="DE22 WORK SELF/OTR?--JOB 1"              
      ER25388             FORMAT=1.   LABEL="DE23 CORP/UNCORP BUS--JOB 1"             
      ER25389             FORMAT=1.   LABEL="DE24 WORK FOR GOVT?--JOB 1"              
      ER25390             FORMAT=9.   LABEL="DE25A NUMBER EMPLOYED AT WORK LOCATION"  
      ER25391             FORMAT=1.   LABEL="DE25B WTR 200 OR MORE"                   
      ER25392             FORMAT=1.   LABEL="DE25C WTR 100 OR MORE"                   
      ER25393             FORMAT=1.   LABEL="DE25D WTR 50 OR MORE"                    
      ER25394             FORMAT=1.   LABEL="DE25E WTR 500 OR MORE"                   
      ER25395             FORMAT=1.   LABEL="DE25F WTR 1000 OR MORE"                  
      ER25396             FORMAT=1.   LABEL="DE26 JOB NOW UNION? (W-E)"               
      ER25397             FORMAT=1.   LABEL="DE27 BELONG UNION? (WF-E)"               
      ER25398             FORMAT=1.   LABEL="DE28A WTR JOB REQUIRES COMPUTER USE"     
      ER25399             FORMAT=1.   LABEL="DE29 SLRY/HRLY/OTR (W-E)"                
      ER25400             FORMAT=10.2 LABEL="DE30 SALARY AMOUNT"                      
      ER25401             FORMAT=1.   LABEL="DE30 SALARY PER WHAT"                    
      ER25402             FORMAT=1.   LABEL="DE31 WTR SAL PD OT (WF-E)"               
      ER25403             FORMAT=1.   LABEL="DE32 HOW PAID FOR OT"                    
      ER25404             FORMAT=10.2 LABEL="DE32A EXACT OT PAY IF SALARIED"          
      ER25405             FORMAT=1.   LABEL="DE32A EXACT OT PAY PER"                  
      ER25406             FORMAT=6.2  LABEL="DE33 HOURLY REGULAR RATE"                
      ER25407             FORMAT=1.   LABEL="DE34 OT DIFFERENTIAL 1ST"                
      ER25408             FORMAT=1.   LABEL="DE34 OT DIFFERENTIAL 2ND"                
      ER25409             FORMAT=1.   LABEL="DE34 OT DIFFERENTIAL 3RD"                
      ER25410             FORMAT=10.2 LABEL="DE34A EXACT OT PAY IF HOURLY"            
      ER25411             FORMAT=1.   LABEL="DE34A EXACT OT PAY PER"                  
      ER25412             FORMAT=8.2  LABEL="DE36 AVG TIPS/COMM"                      
      ER25413             FORMAT=1.   LABEL="DE36 TIPS/COMM PER WHAT"                 
      ER25414             FORMAT=7.   LABEL="DE37 AVG TIPS/COMM"                      
      ER25415             FORMAT=1.   LABEL="DE37 TIPS/COMM PER WHAT"                 
      ER25416             FORMAT=1.   LABEL="DE38 HOW PAID-OTR (WF-E)"                
      ER25417             FORMAT=9.2  LABEL="DE39 OT RATE"                            
      ER25418             FORMAT=2.   LABEL="DE41 YRS PRES EMP (W-E)"                 
      ER25419             FORMAT=2.   LABEL="DE41 MOS PRES EMP (W-E)"                 
      ER25420             FORMAT=2.   LABEL="DE41 WKS PRES EMP (W-E)"                 
      ER25421             FORMAT=2.   LABEL="CALCULATED ELAPSED WEEKS--WF JOB 1"      
      ER25422             FORMAT=1.   LABEL="ACCURACY OF ELAPSED WEEKS--WF JOB 1"     
      ER25423             FORMAT=3.   LABEL="DE43 HOURS/WEEK WORKED--JOB 1"           
      ER25424             FORMAT=1.   LABEL="ACCURACY OF HR/WK WORKED--WF JOB 1"      
      ER25425             FORMAT=1.   LABEL="DE44 WTR WORKED OT--JOB 1"               
      ER25426             FORMAT=4.   LABEL="DE45 AMT OF OT WORKED--JOB 1"            
      ER25427             FORMAT=1.   LABEL="DE45 OT TIME UNIT--JOB 1"                
      ER25428             FORMAT=1.   LABEL="ACCURACY OF OT--WF JOB 1"                
      ER25429             FORMAT=10.2 LABEL="DE46 AMOUNT EARNED LAST YEAR--JOB 1"     
      ER25430             FORMAT=1.   LABEL="DE46 PER FOR AMT EARNED LAST YR--JOB 1"  
      ER25431             FORMAT=1.   LABEL="DE51 WHY LAST JOB END (WF-U)"            
      ER25432             FORMAT=2.   LABEL="DE6 BEGINNING MONTH--JOB 2"              
      ER25433             FORMAT=4.   LABEL="DE6 BEGINNING YEAR--JOB 2"               
      ER25434             FORMAT=2.   LABEL="DE6 ENDING MONTH--JOB 2"                 
      ER25435             FORMAT=4.   LABEL="DE6 ENDING YEAR--JOB 2"                  
      ER25436             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 JAN"             
      ER25437             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 FEB"             
      ER25438             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 MAR"             
      ER25439             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 APR"             
      ER25440             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 MAY"             
      ER25441             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 JUN"             
      ER25442             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 JUL"             
      ER25443             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 AUG"             
      ER25444             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 SEP"             
      ER25445             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 OCT"             
      ER25446             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 NOV"             
      ER25447             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 2 DEC"             
      ER25448             FORMAT=3.   LABEL="DE20 MAIN OCC FOR JOB 2: 2000 CODE (WF)" 
      ER25449             FORMAT=3.   LABEL="DE21 MAIN IND FOR JOB 2: 2000 CODE (WF)" 
      ER25450             FORMAT=1.   LABEL="DE22 WORK SELF/OTR?--JOB 2"              
      ER25451             FORMAT=1.   LABEL="DE23 CORP/UNCORP BUS--JOB 2"             
      ER25452             FORMAT=1.   LABEL="DE24 WORK FOR GOVT?--JOB 2"              
      ER25453             FORMAT=2.   LABEL="CALCULATED ELAPSED WEEKS--WF JOB 2"      
      ER25454             FORMAT=1.   LABEL="ACCURACY OF ELAPSED WEEKS--WF JOB 2"     
      ER25455             FORMAT=3.   LABEL="DE43 HOURS/WEEK WORKED--JOB 2"           
      ER25456             FORMAT=1.   LABEL="ACCURACY OF HR/WK WORKED--WF JOB 2"      
      ER25457             FORMAT=1.   LABEL="DE44 WTR WORKED OT--JOB 2"               
      ER25458             FORMAT=4.   LABEL="DE45 AMT OF OT WORKED--JOB 2"            
      ER25459             FORMAT=1.   LABEL="DE45 OT TIME UNIT--JOB 2"                
      ER25460             FORMAT=1.   LABEL="ACCURACY OF OT--WF JOB 2"                
      ER25461             FORMAT=10.2 LABEL="DE46 AMOUNT EARNED LAST YEAR--JOB 2"     
      ER25462             FORMAT=1.   LABEL="DE46 PER FOR AMT EARNED LAST YR--JOB 2"  
      ER25463             FORMAT=1.   LABEL="DE51 WHY JOB ENDED--JOB 2"               
      ER25464             FORMAT=2.   LABEL="DE6 BEGINNING MONTH--JOB 3"              
      ER25465             FORMAT=4.   LABEL="DE6 BEGINNING YEAR--JOB 3"               
      ER25466             FORMAT=2.   LABEL="DE6 ENDING MONTH--JOB 3"                 
      ER25467             FORMAT=4.   LABEL="DE6 ENDING YEAR--JOB 3"                  
      ER25468             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 JAN"             
      ER25469             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 FEB"             
      ER25470             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 MAR"             
      ER25471             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 APR"             
      ER25472             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 MAY"             
      ER25473             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 JUN"             
      ER25474             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 JUL"             
      ER25475             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 AUG"             
      ER25476             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 SEP"             
      ER25477             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 OCT"             
      ER25478             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 NOV"             
      ER25479             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 3 DEC"             
      ER25480             FORMAT=3.   LABEL="DE20 MAIN OCC FOR JOB 3: 2000 CODE (WF)" 
      ER25481             FORMAT=3.   LABEL="DE21 MAIN IND FOR JOB 3: 2000 CODE (WF)" 
      ER25482             FORMAT=1.   LABEL="DE22 WORK SELF/OTR?--JOB 3"              
      ER25483             FORMAT=1.   LABEL="DE23 CORP/UNCORP BUS--JOB 3"             
      ER25484             FORMAT=1.   LABEL="DE24 WORK FOR GOVT?--JOB 3"              
      ER25485             FORMAT=2.   LABEL="CALCULATED ELAPSED WEEKS--WF JOB 3"      
      ER25486             FORMAT=1.   LABEL="ACCURACY OF ELAPSED WEEKS--WF JOB 3"     
      ER25487             FORMAT=3.   LABEL="DE43 HOURS/WEEK WORKED--JOB 3"           
      ER25488             FORMAT=1.   LABEL="ACCURACY OF HR/WK WORKED--WF JOB 3"      
      ER25489             FORMAT=1.   LABEL="DE44 WTR WORKED OT--JOB 3"               
      ER25490             FORMAT=4.   LABEL="DE45 AMT OF OT WORKED--JOB 3"            
      ER25491             FORMAT=1.   LABEL="DE45 OT TIME UNIT--JOB 3"                
      ER25492             FORMAT=1.   LABEL="ACCURACY OF OT--WF JOB 3"                
      ER25493             FORMAT=10.2 LABEL="DE46 AMOUNT EARNED LAST YEAR--JOB 3"     
      ER25494             FORMAT=1.   LABEL="DE46 PER FOR AMT EARNED LAST YR--JOB 3"  
      ER25495             FORMAT=1.   LABEL="DE51 WHY JOB ENDED--JOB 3"               
      ER25496             FORMAT=2.   LABEL="DE6 BEGINNING MONTH--JOB 4"              
      ER25497             FORMAT=4.   LABEL="DE6 BEGINNING YEAR--JOB 4"               
      ER25498             FORMAT=2.   LABEL="DE6 ENDING MONTH--JOB 4"                 
      ER25499             FORMAT=4.   LABEL="DE6 ENDING YEAR--JOB 4"                  
      ER25500             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 JAN"             
      ER25501             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 FEB"             
      ER25502             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 MAR"             
      ER25503             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 APR"             
      ER25504             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 MAY"             
      ER25505             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 JUN"             
      ER25506             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 JUL"             
      ER25507             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 AUG"             
      ER25508             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 SEP"             
      ER25509             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 OCT"             
      ER25510             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 NOV"             
      ER25511             FORMAT=1.   LABEL="DE6 WTR EMPLOYED--JOB 4 DEC"             
      ER25512             FORMAT=3.   LABEL="DE20 MAIN OCC FOR JOB 4: 2000 CODE (WF)" 
      ER25513             FORMAT=3.   LABEL="DE21 MAIN IND FOR JOB 4: 2000 CODE (WF)" 
      ER25514             FORMAT=1.   LABEL="DE22 WORK SELF/OTR?--JOB 4"              
      ER25515             FORMAT=1.   LABEL="DE23 CORP/UNCORP BUS--JOB 4"             
      ER25516             FORMAT=1.   LABEL="DE24 WORK FOR GOVT?--JOB 4"              
      ER25517             FORMAT=2.   LABEL="CALCULATED ELAPSED WEEKS--WF JOB 4"      
      ER25518             FORMAT=1.   LABEL="ACCURACY OF ELAPSED WEEKS--WF JOB 4"     
      ER25519             FORMAT=3.   LABEL="DE43 HOURS/WEEK WORKED--JOB 4"           
      ER25520             FORMAT=1.   LABEL="ACCURACY OF HR/WK WORKED--WF JOB 4"      
      ER25521             FORMAT=1.   LABEL="DE44 WTR WORKED OT--JOB 4"               
      ER25522             FORMAT=4.   LABEL="DE45 AMT OF OT WORKED--JOB 4"            
      ER25523             FORMAT=1.   LABEL="DE45 OT TIME UNIT--JOB 4"                
      ER25524             FORMAT=1.   LABEL="ACCURACY OF OT--WF JOB 4"                
      ER25525             FORMAT=10.2 LABEL="DE46 AMOUNT EARNED LAST YEAR--JOB 4"     
      ER25526             FORMAT=1.   LABEL="DE46 PER FOR AMT EARNED LAST YR--JOB 4"  
      ER25527             FORMAT=1.   LABEL="DE51 WHY JOB ENDED--JOB 4"               
      ER25528             FORMAT=1.   LABEL="NUMBER OF ADDITIONAL JOBS--WF"           
      ER25529             FORMAT=1.   LABEL="DE10 WTR OTRS ILL (WF)"                  
      ER25530             FORMAT=3.   LABEL="DE10 DAYS OTHERS SICK"                   
      ER25531             FORMAT=1.   LABEL="ACCURACY OF DAYS OTRS SICK (WF)"         
      ER25532             FORMAT=2.   LABEL="DE10 WEEKS OTHERS SICK"                  
      ER25533             FORMAT=1.   LABEL="ACCURACY OF WEEKS OTRS SICK (WF)"        
      ER25534             FORMAT=2.   LABEL="DE10 MONTHS OTHERS SICK"                 
      ER25535             FORMAT=1.   LABEL="ACCURACY OF MONTHS OTRS SICK (WF)"       
      ER25536             FORMAT=1.   LABEL="DE11 WTR SELF ILL (WF)"                  
      ER25537             FORMAT=3.   LABEL="DE11 DAYS SELF SICK"                     
      ER25538             FORMAT=1.   LABEL="ACCURACY OF DAYS SELF ILL (WF)"          
      ER25539             FORMAT=2.   LABEL="DE11 WEEKS SELF SICK"                    
      ER25540             FORMAT=1.   LABEL="ACCURACY OF WEEKS SELF ILL (WF)"         
      ER25541             FORMAT=2.   LABEL="DE11 MONTHS SELF SICK"                   
      ER25542             FORMAT=1.   LABEL="ACCURACY OF MONTHS SELF ILL (WF)"        
      ER25543             FORMAT=1.   LABEL="DE12 WTR VACATION (WF)"                  
      ER25544             FORMAT=3.   LABEL="DE12 DAYS VACATION"                      
      ER25545             FORMAT=1.   LABEL="ACCURACY OF DAYS VACATION (WF)"          
      ER25546             FORMAT=2.   LABEL="DE12 WEEKS VACATION"                     
      ER25547             FORMAT=1.   LABEL="ACCURACY OF WEEKS VACATION (WF)"         
      ER25548             FORMAT=2.   LABEL="DE12 MONTHS VACATION"                    
      ER25549             FORMAT=1.   LABEL="ACCURACY OF MONTHS VACATION (WF)"        
      ER25550             FORMAT=1.   LABEL="DE13 WTR STRIKE (WF)"                    
      ER25551             FORMAT=3.   LABEL="DE13 DAYS STRIKE"                        
      ER25552             FORMAT=1.   LABEL="ACCURACY OF STRIKE DAYS (WF)"            
      ER25553             FORMAT=2.   LABEL="DE13 WEEKS STRIKE"                       
      ER25554             FORMAT=1.   LABEL="ACCURACY OF STRIKE WEEKS (WF)"           
      ER25555             FORMAT=2.   LABEL="DE13 MONTHS STRIKE"                      
      ER25556             FORMAT=1.   LABEL="ACCURACY OF STRIKE MONTHS (WF)"          
      ER25557             FORMAT=1.   LABEL="DE14 WTR LAID OFF (WF)"                  
      ER25558             FORMAT=3.   LABEL="DE14 DAYS LAID OFF"                      
      ER25559             FORMAT=1.   LABEL="ACCURACY OF DAYS LAID OFF (WF)"          
      ER25560             FORMAT=2.   LABEL="DE14 WEEKS LAID OFF"                     
      ER25561             FORMAT=1.   LABEL="ACCURACY OF WEEKS LAID OFF (WF)"         
      ER25562             FORMAT=2.   LABEL="DE14 MONTHS LAID OFF"                    
      ER25563             FORMAT=1.   LABEL="ACCURACY OF MONTHS LAID OFF (WF)"        
      ER25564             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED(WF)"                  
      ER25565             FORMAT=3.   LABEL="DE8 DAYS UNEMPLOYED"                     
      ER25566             FORMAT=1.   LABEL="ACCURACY OF DAYS UNEMPLOYED (WF)"        
      ER25567             FORMAT=2.   LABEL="DE8 WEEKS UNEMPLOYED"                    
      ER25568             FORMAT=1.   LABEL="ACCURACY OF WEEKS UNEMPLOYED (WF)"       
      ER25569             FORMAT=2.   LABEL="DE8 MONTHS UNEMPLOYED"                   
      ER25570             FORMAT=1.   LABEL="ACCURACY OF MONTHS UNEMPLOYED (WF)"      
      ER25571             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED JAN"                  
      ER25572             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED FEB"                  
      ER25573             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED MAR"                  
      ER25574             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED APR"                  
      ER25575             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED MAY"                  
      ER25576             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED JUN"                  
      ER25577             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED JUL"                  
      ER25578             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED AUG"                  
      ER25579             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED SEP"                  
      ER25580             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED OCT"                  
      ER25581             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED NOV"                  
      ER25582             FORMAT=1.   LABEL="DE8 WTR UNEMPLOYED DEC"                  
      ER25583             FORMAT=1.   LABEL="DE7 WTR OUT LAB FRC(W)"                  
      ER25584             FORMAT=3.   LABEL="DE7 DAYS OUT OF LAB FORCE"               
      ER25585             FORMAT=1.   LABEL="ACCURACY OF DAYS OUT OF LAB FORCE (WF)"  
      ER25586             FORMAT=2.   LABEL="DE7WEEKS OUT LABOR FORCE"                
      ER25587             FORMAT=1.   LABEL="ACCURACY OF WKS OUT OF LAB FORCE (WF)"   
      ER25588             FORMAT=2.   LABEL="DE7 MONTHS OUT LABR FORCE"               
      ER25589             FORMAT=1.   LABEL="ACCURACY OF MOS OUT OF LAB FORCE (WF)"   
      ER25590             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC JAN"                
      ER25591             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC FEB"                
      ER25592             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC MAR"                
      ER25593             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC APR"                
      ER25594             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC MAY"                
      ER25595             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC JUN"                
      ER25596             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC JUL"                
      ER25597             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC AUG"                
      ER25598             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC SEP"                
      ER25599             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC OCT"                
      ER25600             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC NOV"                
      ER25601             FORMAT=1.   LABEL="DE7 WTR OUT LAB FORC DEC"                
      ER25602             FORMAT=2.   LABEL="DE54 TOTAL WEEKS WORKED"                 
      ER25603             FORMAT=3.   LABEL="DE56 TOTAL HOURS WORKED"                 
      ER25604             FORMAT=1.   LABEL="DE62 WTR EVER WORKED"                    
      ER25605             FORMAT=2.   LABEL="DE63 MO LAST WORKED"                     
      ER25606             FORMAT=4.   LABEL="DE63 YR LAST WORKED"                     
      ER25607             FORMAT=1.   LABEL="DE64 WTR LOOKING FOR JOB"                
      ER25608             FORMAT=1.   LABEL="DE65 WTR PUBLIC EMP AGENCY (WF)"         
      ER25609             FORMAT=1.   LABEL="DE65 WTR PRIVATE EMP AGENCY (WF)"        
      ER25610             FORMAT=1.   LABEL="DE65 WTR CHKD W/CURRENT EMP (WF)"        
      ER25611             FORMAT=1.   LABEL="DE65 WTR CHKD W/OTHER EMP (WF)"          
      ER25612             FORMAT=1.   LABEL="DE65 WTR CHKD W/FRIEND OR REL (WF)"      
      ER25613             FORMAT=1.   LABEL="DE65 WTR PLACED OR ANSWERED ADS (WF)"    
      ER25614             FORMAT=1.   LABEL="DE65 WTR OTHER ACTIVITY (WF)"            
      ER25615             FORMAT=1.   LABEL="DE65 WTR DONE NOTHING (WF)"              
      ER25616             FORMAT=2.   LABEL="DE67 YRS LOOK WRK (W-U)"                 
      ER25617             FORMAT=2.   LABEL="DE67 MOS LOOK WRK (W-U)"                 
      ER25618             FORMAT=2.   LABEL="DE67 WKS LOOK WRK (W-U)"                 
      ER25619             FORMAT=1.   LABEL="F1 CKPT:TYPE HD+WF"                      
      ER25620             FORMAT=3.   LABEL="F2 HOUSEWORK HRS-WIFE"                   
      ER25621             FORMAT=1.   LABEL="ACCURACY OF WF HOUSEWORK HRS"            
      ER25622             FORMAT=3.   LABEL="F3 HOUSEWORK HOURS-HEAD"                 
      ER25623             FORMAT=1.   LABEL="ACCURACY OF HD HOUSEWORK HRS"            
      ER25624             FORMAT=1.   LABEL="F5 FAM TOGETHR MAIN MEAL"                
      ER25625             FORMAT=1.   LABEL="F6 CKPT: WTR CHILD 5-18 IN FU LAST YEAR" 
      ER25626             FORMAT=1.   LABEL="F6A WTR CH REC FREE/LOW LUNCH LAST YR"   
      ER25627             FORMAT=1.   LABEL="F6B WTR CH REC FREE/LOW BKFST LAST YR"   
      ER25628             FORMAT=6.   LABEL="F6D COST CHILD CARE LAST YEAR"           
      ER25629             FORMAT=1.   LABEL="F6E WTR CHILD IN DAY CARE CNTR LAST YR"  
      ER25630             FORMAT=1.   LABEL="F6F WTR MEALS/SNACKS PROVIDED TO CHILD"  
      ER25631             FORMAT=1.   LABEL="F6G WTR DAY CARE IN CHILD/ADULT FOOD PGM"
      ER25632             FORMAT=1.   LABEL="F6H FU FEMALE 15-45/CHILD <5 LAST YR"    
      ER25633             FORMAT=1.   LABEL="F6I WTR RECD FOOD THROUGH WIC PROGRAM"   
      ER25634             FORMAT=1.   LABEL="F7 WTR ADULT IN ADULT DAY CARE PREV YR"  
      ER25635             FORMAT=6.   LABEL="F7A AMT PAID FOR ADULT DAY CARE"         
      ER25636             FORMAT=1.   LABEL="F7B WTR FU MEMBER 60+ LAST YR"           
      ER25637             FORMAT=1.   LABEL="F7C WTR RECD FREE/REDUCD MEALS LAST YR"  
      ER25638             FORMAT=1.   LABEL="F8 WTR USED FOOD STAMPS 2 YRS AGO"       
      ER25639             FORMAT=6.   LABEL="F9 VALUE OF FOOD STAMPS 2 YRS AGO"       
      ER25640             FORMAT=1.   LABEL="F9 TIME UNIT-VALUE FOOD STAMPS 2 YRS AGO"
      ER25641             FORMAT=1.   LABEL="ACCURACY OF FOOD STAMPS 2 YEARS AGO"     
      ER25642             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS JAN 2 YRS AGO" 
      ER25643             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS FEB 2 YRS AGO" 
      ER25644             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS MAR 2 YRS AGO" 
      ER25645             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS APR 2 YRS AGO" 
      ER25646             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS MAY 2 YRS AGO" 
      ER25647             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS JUN 2 YRS AGO" 
      ER25648             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS JUL 2 YRS AGO" 
      ER25649             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS AUG 2 YRS AGO" 
      ER25650             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS SEP 2 YRS AGO" 
      ER25651             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS OCT 2 YRS AGO" 
      ER25652             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS NOV 2 YRS AGO" 
      ER25653             FORMAT=1.   LABEL="F10 WTR RECVD FOOD STAMPS DEC 2 YRS AGO" 
      ER25654             FORMAT=1.   LABEL="F11 WTR RECEIVED FOOD STAMPS LAST YEAR"  
      ER25655             FORMAT=6.   LABEL="F12 VALUE OF FOOD STAMPS LAST YEAR"      
      ER25656             FORMAT=1.   LABEL="F12 TIME UNIT-VALUE FOOD STAMPS LAST YR" 
      ER25657             FORMAT=1.   LABEL="ACCURACY OF FOOD STAMPS LAST YEAR"       
      ER25658             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS JAN LAST YEAR" 
      ER25659             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS FEB LAST YEAR" 
      ER25660             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS MAR LAST YEAR" 
      ER25661             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS APR LAST YEAR" 
      ER25662             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS MAY LAST YEAR" 
      ER25663             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS JUN LAST YEAR" 
      ER25664             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS JUL LAST YEAR" 
      ER25665             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS AUG LAST YEAR" 
      ER25666             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS SEP LAST YEAR" 
      ER25667             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS OCT LAST YEAR" 
      ER25668             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS NOV LAST YEAR" 
      ER25669             FORMAT=1.   LABEL="F13 WTR RECVD FOOD STAMPS DEC LAST YEAR" 
      ER25670             FORMAT=1.   LABEL="F14 WTR RECEIVED FOOD STAMPS THIS YEAR"  
      ER25671             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS JAN THIS YEAR"
      ER25672             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS FEB THIS YEAR"
      ER25673             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS MAR THIS YEAR"
      ER25674             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS APR THIS YEAR"
      ER25675             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS MAY THIS YEAR"
      ER25676             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS JUN THIS YEAR"
      ER25677             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS JUL THIS YEAR"
      ER25678             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS AUG THIS YEAR"
      ER25679             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS SEP THIS YEAR"
      ER25680             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS OCT THIS YEAR"
      ER25681             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS NOV THIS YEAR"
      ER25682             FORMAT=1.   LABEL="F14A WTR RECVD FOOD STAMPS DEC THIS YEAR"
      ER25683             FORMAT=1.   LABEL="F15 # FU MEMBERS RECEIVED FOOD STAMPS"   
      ER25684             FORMAT=6.   LABEL="F16 VALUE OF FOOD STAMPS RECD THIS YR"   
      ER25685             FORMAT=1.   LABEL="F16 VALUE OF FOOD STAMPS PER"            
      ER25686             FORMAT=1.   LABEL="ACCURACY OF FOOD STAMPS THIS YEAR"       
      ER25687             FORMAT=1.   LABEL="F17 WTR BUY FOOD TO USE AT HOME"         
      ER25688             FORMAT=8.2  LABEL="F18 REPORTED COST OF FOOD AT HOME"       
      ER25689             FORMAT=1.   LABEL="F18 COST OF FOOD AT HOME PER"            
      ER25690             FORMAT=1.   LABEL="ACCURACY OF FOOD AT HOME-RECD FD STAMPS" 
      ER25691             FORMAT=1.   LABEL="F19 WTR FOOD DELIVERED TO HOME"          
      ER25692             FORMAT=8.2  LABEL="F20 COST OF DELIVERED FOOD"              
      ER25693             FORMAT=1.   LABEL="F20 COST OF DELIVERED FOOD PER"          
      ER25694             FORMAT=1.   LABEL="ACCURACY OF DELIVERD FOOD-RECD FD STAMPS"
      ER25695             FORMAT=8.2  LABEL="F21 COST OF FOOD EATEN OUT"              
      ER25696             FORMAT=1.   LABEL="F21 COST OF FOOD EATEN OUT PER"          
      ER25697             FORMAT=1.   LABEL="ACCURACY OF FOOD EATN OUT-RECD FD STAMPS"
      ER25698             FORMAT=8.2  LABEL="F22 REPORTED COST OF FOOD AT HOME"       
      ER25699             FORMAT=1.   LABEL="F22 COST OF FOOD AT HOME PER"            
      ER25700             FORMAT=1.   LABEL="ACCURACY OF FOOD AT HOME-NO FD STAMPS"   
      ER25701             FORMAT=1.   LABEL="F23 WTR FOOD DELIVERED TO HOME"          
      ER25702             FORMAT=8.2  LABEL="F24 COST OF DELIVERED FOOD"              
      ER25703             FORMAT=1.   LABEL="F24 COST OF DELIVERED FOOD PER"          
      ER25704             FORMAT=1.   LABEL="ACCURACY OF DELIVERED FOOD-NO FD STAMPS" 
      ER25705             FORMAT=8.2  LABEL="F25 COST OF FOOD EATEN OUT"              
      ER25706             FORMAT=1.   LABEL="F25 COST OF FOOD EATEN OUT PER"          
      ER25707             FORMAT=1.   LABEL="ACCURACY OF FOOD EATEN OUT-NO FD STAMPS" 
      ER25708             FORMAT=1.   LABEL="F47 WTR HAVE VEHICLE"                    
      ER25709             FORMAT=2.   LABEL="F48 NUMBER OF VEHICLES"                  
      ER25710             FORMAT=2.   LABEL="F49 MANUFACTURER CODE #1"                
      ER25711             FORMAT=2.   LABEL="F49 VEHICLE MAKE CODE #1"                
      ER25712             FORMAT=4.   LABEL="F49 VEHICLE MODEL YEAR #1"               
      ER25713             FORMAT=1.   LABEL="F49 VEHICLE TYPE CODE #1"                
      ER25714             FORMAT=1.   LABEL="F51 VEHICLE SIZE #1"                     
      ER25715             FORMAT=2.   LABEL="F52 CYPSN OF USUAL DRIVER #1"            
      ER25716             FORMAT=1.   LABEL="F53 HOW ACQUIRED #1"                     
      ER25717             FORMAT=1.   LABEL="F54 WTR NEW OR USED #1"                  
      ER25718             FORMAT=4.   LABEL="F55 YR ACQUIRED #1"                      
      ER25719             FORMAT=2.   LABEL="F56 MO ACQUIRED #1"                      
      ER25720             FORMAT=1.   LABEL="F57 WTR USED FOR BUSINESS #1"            
      ER25721             FORMAT=1.   LABEL="F58 WTR USED MOSTLY FOR BUSINESS #1"     
      ER25722             FORMAT=1.   LABEL="F60 CKPT: WTR OWND/LEASD CAR #1 BY 2003" 
      ER25723             FORMAT=6.   LABEL="F61 TOTAL PRICE #1"                      
      ER25724             FORMAT=1.   LABEL="F62 WTR TRADE-IN #1"                     
      ER25725             FORMAT=6.   LABEL="F63 TRADE-IN AMOUNT #1"                  
      ER25726             FORMAT=6.   LABEL="F64 CASH DOWNPMT AMT #1"                 
      ER25727             FORMAT=1.   LABEL="F65 WTR GOT LOAN #1"                     
      ER25728             FORMAT=6.   LABEL="F66 LOAN AMOUNT #1"                      
      ER25729             FORMAT=6.   LABEL="F67 LOAN PAYMENT AMT #1"                 
      ER25730             FORMAT=1.   LABEL="F67 LOAN PMT AMT PER #1"                 
      ER25731             FORMAT=3.   LABEL="F69 LOAN TOTAL # PMTS #1"                
      ER25732             FORMAT=3.   LABEL="F70 LOAN # PMTS MADE #1"                 
      ER25733             FORMAT=6.   LABEL="F71 LEASE INITIAL OUTLAY #1"             
      ER25734             FORMAT=6.   LABEL="F72 LEASE PMT AMOUNT #1"                 
      ER25735             FORMAT=1.   LABEL="F72 LEASE AMOUNT PER #1"                 
      ER25736             FORMAT=3.   LABEL="F73 LEASE TOTAL # PMTS #1"               
      ER25737             FORMAT=3.   LABEL="F74 LEASE # PMTS MADE #1"                
      ER25738             FORMAT=2.   LABEL="F49 MANUFACTURER CODE #2"                
      ER25739             FORMAT=2.   LABEL="F49 VEHICLE MAKE CODE #2"                
      ER25740             FORMAT=4.   LABEL="F49 VEHICLE MODEL YEAR #2"               
      ER25741             FORMAT=1.   LABEL="F49 VEHICLE TYPE CODE #2"                
      ER25742             FORMAT=1.   LABEL="F51 VEHICLE SIZE #2"                     
      ER25743             FORMAT=2.   LABEL="F52 CYPSN OF USUAL DRIVER #2"            
      ER25744             FORMAT=1.   LABEL="F53 HOW ACQUIRED #2"                     
      ER25745             FORMAT=1.   LABEL="F54 WTR NEW OR USED #2"                  
      ER25746             FORMAT=4.   LABEL="F55 YR ACQUIRED #2"                      
      ER25747             FORMAT=2.   LABEL="F55 MO ACQUIRED #2"                      
      ER25748             FORMAT=1.   LABEL="F57 WTR USED FOR BUSINESS #2"            
      ER25749             FORMAT=1.   LABEL="F58 WTR MOSTLY FOR BUSINESS #2"          
      ER25750             FORMAT=1.   LABEL="F60 CKPT: WTR OWND/LEASD CAR #2 BY 2003" 
      ER25751             FORMAT=6.   LABEL="F61 TOTAL PRICE #2"                      
      ER25752             FORMAT=1.   LABEL="F62 WTR TRADE-IN #2"                     
      ER25753             FORMAT=6.   LABEL="F63 TRADE-IN AMOUNT #2"                  
      ER25754             FORMAT=6.   LABEL="F64 CASH DOWNPMT AMT #2"                 
      ER25755             FORMAT=1.   LABEL="F65 WTR GOT LOAN #2"                     
      ER25756             FORMAT=6.   LABEL="F66 LOAN AMOUNT #2"                      
      ER25757             FORMAT=6.   LABEL="F67 LOAN PAYMENT AMT #2"                 
      ER25758             FORMAT=1.   LABEL="F67 LOAN PMT AMT PER #2"                 
      ER25759             FORMAT=3.   LABEL="F69 LOAN TOT # PMTS #2"                  
      ER25760             FORMAT=3.   LABEL="F70 LOAN # PMTS MADE #2"                 
      ER25761             FORMAT=6.   LABEL="F71 LEASE INITIAL OUTLAY #2"             
      ER25762             FORMAT=6.   LABEL="F72 LEASE PMT AMOUNT #2"                 
      ER25763             FORMAT=1.   LABEL="F72 LEASE AMOUNT PER #2"                 
      ER25764             FORMAT=3.   LABEL="F73 LEASE TOTAL # PMTS #2"               
      ER25765             FORMAT=3.   LABEL="F74 LEASE # PMTS MADE #2"                
      ER25766             FORMAT=2.   LABEL="F49 MANUFACTURER CODE #3"                
      ER25767             FORMAT=2.   LABEL="F49 VEHICLE MAKE CODE #3"                
      ER25768             FORMAT=4.   LABEL="F49 VEHICLE MODEL YEAR #3"               
      ER25769             FORMAT=1.   LABEL="F49 VEHICLE TYPE CODE #3"                
      ER25770             FORMAT=1.   LABEL="F51 VEHICLE SIZE #3"                     
      ER25771             FORMAT=2.   LABEL="F52 CYPSN OF USUAL DRIVER #3"            
      ER25772             FORMAT=1.   LABEL="F53 HOW ACQUIRED #3"                     
      ER25773             FORMAT=1.   LABEL="F54 WTR NEW OR USED #3"                  
      ER25774             FORMAT=4.   LABEL="F55 YR ACQUIRED #3"                      
      ER25775             FORMAT=2.   LABEL="F56 MO ACQUIRED #3"                      
      ER25776             FORMAT=1.   LABEL="F57 WTR USED FOR BUSINESS #3"            
      ER25777             FORMAT=1.   LABEL="F58 WTR MOSTLY FOR BUSINESS #3"          
      ER25778             FORMAT=1.   LABEL="F60 CKPT: WTR OWND/LEASD CAR #3 BY 2003" 
      ER25779             FORMAT=6.   LABEL="F61 TOTAL PRICE #3"                      
      ER25780             FORMAT=1.   LABEL="F62 WTR TRADE-IN #3"                     
      ER25781             FORMAT=6.   LABEL="F63 TRADE-IN AMOUNT #3"                  
      ER25782             FORMAT=6.   LABEL="F64 CASH DOWNPMT AMT #3"                 
      ER25783             FORMAT=1.   LABEL="F65 WTR GOT LOAN #3"                     
      ER25784             FORMAT=6.   LABEL="F66 LOAN AMOUNT #3"                      
      ER25785             FORMAT=6.   LABEL="F67 LOAN PAYMENT AMT #3"                 
      ER25786             FORMAT=1.   LABEL="F67 LOAN PMT AMT PER #3"                 
      ER25787             FORMAT=3.   LABEL="F69 LOAN TOTAL # PMTS #3"                
      ER25788             FORMAT=3.   LABEL="F70 LOAN # PMTS MADE #3"                 
      ER25789             FORMAT=6.   LABEL="F71 LEASE INITIAL OUTLAY #3"             
      ER25790             FORMAT=6.   LABEL="F72 LEASE PMT AMOUNT #3"                 
      ER25791             FORMAT=1.   LABEL="F72 LEASE AMOUNT PER #3"                 
      ER25792             FORMAT=3.   LABEL="F73 LEASE TOTAL # PMTS #3"               
      ER25793             FORMAT=3.   LABEL="F74 LEASE # PMTS MADE #3"                
      ER25794             FORMAT=6.   LABEL="F77 CAR INSURANCE EXPENSE"               
      ER25795             FORMAT=1.   LABEL="F77 CAR INSURANCE PER"                   
      ER25796             FORMAT=1.   LABEL="F78CKPT WTR OTR VEHICLES"                
      ER25797             FORMAT=6.   LABEL="F79 ADDL CAR/LEASE PMTS"                 
      ER25798             FORMAT=5.   LABEL="F80A CAR REPAIR EXPENSES"                
      ER25799             FORMAT=5.   LABEL="F80B GASOLINE EXPENSES"                  
      ER25800             FORMAT=5.   LABEL="F80C PARKING EXPENSES"                   
      ER25801             FORMAT=5.   LABEL="F81A BUS/TRAIN FARES"                    
      ER25802             FORMAT=5.   LABEL="F81B CAB FARE EXPENSES"                  
      ER25803             FORMAT=5.   LABEL="F81C OTR TRANSP EXPENSES"                
      ER25804             FORMAT=1.   LABEL="F82 WTR SCHOOL EXPENSES"                 
      ER25805             FORMAT=6.   LABEL="F83 TOTAL SCHOOL EXPENSES"               
      ER25806             FORMAT=1.   LABEL="F84 WTR OTR SCHOOL EXPENSES"             
      ER25807             FORMAT=6.   LABEL="F86 TOTAL OTR SCHOOL EXPENSES"           
      ER25808             FORMAT=6.   LABEL="F87 COST OF HOME REPAIRS LAST YEAR"      
      ER25809             FORMAT=1.   LABEL="F87 TIME UNIT FOR HOME REPAIRS"          
      ER25810             FORMAT=1.   LABEL="F87A WTR $400 OR MORE"                   
      ER25811             FORMAT=1.   LABEL="F87B WTR $1000 OR MORE"                  
      ER25812             FORMAT=1.   LABEL="F87C WTR $100 OR MORE"                   
      ER25813             FORMAT=6.   LABEL="F88 COST OF HHOLD FURNISHINGS LAST YEAR" 
      ER25814             FORMAT=1.   LABEL="F88 TIME UNIT FOR HHOLD FURNISHINGS"     
      ER25815             FORMAT=1.   LABEL="F88A WTR $500 OR MORE"                   
      ER25816             FORMAT=1.   LABEL="F88B WTR $1500 OR MORE"                  
      ER25817             FORMAT=1.   LABEL="F88C WTR $100 OR MORE"                   
      ER25818             FORMAT=6.   LABEL="F89 COST OF CLOTHING LAST YEAR"          
      ER25819             FORMAT=1.   LABEL="F89 TIME UNIT FOR CLOTHING"              
      ER25820             FORMAT=1.   LABEL="F89A WTR $700 OR MORE"                   
      ER25821             FORMAT=1.   LABEL="F89B WTR$1500 OR MORE"                   
      ER25822             FORMAT=1.   LABEL="F89C WTR $200 OR MORE"                   
      ER25823             FORMAT=6.   LABEL="F90 COST OF TRIPS, VACATIONS LAST YEAR"  
      ER25824             FORMAT=1.   LABEL="F90 TIME UNIT FOR TRIPS, VACATIONS"      
      ER25825             FORMAT=1.   LABEL="F90A WTR $500 OR MORE"                   
      ER25826             FORMAT=1.   LABEL="F90B WTR $1500 OR MORE"                  
      ER25827             FORMAT=1.   LABEL="F90C WTR $200 OR MORE"                   
      ER25828             FORMAT=6.   LABEL="F91 COST OF OTR RECREATION LAST YEAR"    
      ER25829             FORMAT=1.   LABEL="F91 TIME UNIT FOR OTR RECREATON"         
      ER25830             FORMAT=1.   LABEL="F91A WTR $500 OR MORE"                   
      ER25831             FORMAT=1.   LABEL="F91B WTR $1500 OR MORE"                  
      ER25832             FORMAT=1.   LABEL="F91C WTR $200 OR MORE"                   
      ER25833             FORMAT=1.   LABEL="G1A WHETHER HEAD FARMER"                 
      ER25834             FORMAT=7.   LABEL="G2 TOTAL FARM RECEIPTS"                  
      ER25835             FORMAT=7.   LABEL="G3 PYR FARM EXPENSES"                    
      ER25836             FORMAT=7.   LABEL="G4 PYR NET FARM INCOME"                  
      ER25837             FORMAT=1.   LABEL="ACCURACY OF FARM INCOME"                 
      ER25838             FORMAT=1.   LABEL="G5 WHETHER BUSINESS"                     
      ER25839             FORMAT=2.   LABEL="G7A 2-DIGIT INDUSTRY-BUS 1"              
      ER25840             FORMAT=1.   LABEL="G8 HEAD OWN BUSINESS 1?"                 
      ER25841             FORMAT=1.   LABEL="G8 WIFE OWN BUSINESS 1?"                 
      ER25842             FORMAT=1.   LABEL="G8OTR RELATIVE OWN BUS1?"                
      ER25843             FORMAT=1.   LABEL="G8OTHER PERSON OWN BUS1?"                
      ER25844             FORMAT=2.   LABEL="HEAD WORK IN BUSINESS 1"                 
      ER25845             FORMAT=2.   LABEL="HEAD REPORT HRS BUSNS 1"                 
      ER25846             FORMAT=2.   LABEL="WIFE WORK IN BUSINESS 1"                 
      ER25847             FORMAT=2.   LABEL="WIFE REPORT HRS BUSNS 1"                 
      ER25848             FORMAT=1.   LABEL="G10 CORP/UNINCORP BUS1"                  
      ER25849             FORMAT=7.   LABEL="G11 GROSS RECEIPTS BUS1"                 
      ER25850             FORMAT=7.   LABEL="G11A EXPENSES BUS 1"                     
      ER25851             FORMAT=7.   LABEL="G11B PROFIT/LOSS BUS 1"                  
      ER25852             FORMAT=1.   LABEL="ACCURACY OF BUSINESS1 PROFIT/LOSS"       
      ER25853             FORMAT=2.   LABEL="G7A 2-DIGIT INDUSTRY-BUS 2"              
      ER25854             FORMAT=1.   LABEL="G8 HEAD OWN BUSINESS 2?"                 
      ER25855             FORMAT=1.   LABEL="G8 WIFE OWN BUSINESS 2?"                 
      ER25856             FORMAT=1.   LABEL="G8OTR RELATIVE OWN BUS2?"                
      ER25857             FORMAT=1.   LABEL="G8OTHER PERSON OWN BUS2?"                
      ER25858             FORMAT=2.   LABEL="HEAD WORK IN BUSINESS 2"                 
      ER25859             FORMAT=2.   LABEL="HEAD REPORT HRS BUSNS 2"                 
      ER25860             FORMAT=2.   LABEL="WIFE WORK IN BUSINESS 2"                 
      ER25861             FORMAT=2.   LABEL="WIFE REPORT HRS BUSNS 2"                 
      ER25862             FORMAT=1.   LABEL="G10 CORP/UNINCORP BUS2"                  
      ER25863             FORMAT=7.   LABEL="G11 GROSS RECEIPTS BUS 2"                
      ER25864             FORMAT=7.   LABEL="G11A EXPENSES BUS 2"                     
      ER25865             FORMAT=7.   LABEL="G11B PROFIT/LOSS BUS 2"                  
      ER25866             FORMAT=1.   LABEL="ACCURACY OF BUSINESS2 PROFIT/LOSS"       
      ER25867             FORMAT=2.   LABEL="G7A 2-DIGIT INDUSTRY-BUS 3"              
      ER25868             FORMAT=1.   LABEL="G8 HEAD OWN BUSINESS 3?"                 
      ER25869             FORMAT=1.   LABEL="G8 WIFE OWN BUSINESS 3?"                 
      ER25870             FORMAT=1.   LABEL="G8OTR RELATIVE OWN BUS3?"                
      ER25871             FORMAT=1.   LABEL="G8OTHER PERSON OWN BUS3?"                
      ER25872             FORMAT=2.   LABEL="HEAD WORK IN BUSINESS 3"                 
      ER25873             FORMAT=2.   LABEL="HEAD REPORT HRS BUSNS 3"                 
      ER25874             FORMAT=2.   LABEL="WIFE WORK IN BUSINESS 3"                 
      ER25875             FORMAT=2.   LABEL="WIFE REPORT HRS BUSNS 3"                 
      ER25876             FORMAT=1.   LABEL="G10 CORP/UNINCORP BUS3"                  
      ER25877             FORMAT=7.   LABEL="G11 GROSS RECEIPTS BUS 3"                
      ER25878             FORMAT=7.   LABEL="G11A EXPENSES BUS 3"                     
      ER25879             FORMAT=7.   LABEL="G11B PROFIT/LOSS BUS 3"                  
      ER25880             FORMAT=1.   LABEL="ACCURACY OF BUSINESS3 PROFIT/LOSS"       
      ER25881             FORMAT=2.   LABEL="G7A 2-DIGIT INDUSTRY-BUS 4"              
      ER25882             FORMAT=1.   LABEL="G8 HEAD OWN BUSINESS 4?"                 
      ER25883             FORMAT=1.   LABEL="G8 WIFE OWN BUSINESS 4?"                 
      ER25884             FORMAT=1.   LABEL="G8OTR RELATIVE OWN BUS4?"                
      ER25885             FORMAT=1.   LABEL="G8OTHER PERSON OWN BUS4?"                
      ER25886             FORMAT=2.   LABEL="HEAD WORK IN BUSINESS 4"                 
      ER25887             FORMAT=2.   LABEL="HEAD REPORT HRS BUSNS 4"                 
      ER25888             FORMAT=2.   LABEL="WIFE WORK IN BUSINESS 4"                 
      ER25889             FORMAT=2.   LABEL="WIFE REPORT HRS BUSNS 4"                 
      ER25890             FORMAT=1.   LABEL="G10 CORP/UNINCORP BUS4"                  
      ER25891             FORMAT=7.   LABEL="G11 GROSS RECEIPTS BUS 4"                
      ER25892             FORMAT=7.   LABEL="G11A EXPENSES BUS 4"                     
      ER25893             FORMAT=7.   LABEL="G11B PROFIT/LOSS BUS 4"                  
      ER25894             FORMAT=1.   LABEL="ACCURACY OF BUSINESS4 PROFIT/LOSS"       
      ER25895             FORMAT=2.   LABEL="G7A 2-DIGIT INDUSTRY-BUS 5"              
      ER25896             FORMAT=1.   LABEL="G8 HEAD OWN BUSINESS 5?"                 
      ER25897             FORMAT=1.   LABEL="G8 WIFE OWN BUSINESS 5?"                 
      ER25898             FORMAT=1.   LABEL="G8OTR RELATIVE OWN BUS5?"                
      ER25899             FORMAT=1.   LABEL="G8OTHER PERSON OWN BUS5?"                
      ER25900             FORMAT=2.   LABEL="HEAD WORK IN BUSINESS 5"                 
      ER25901             FORMAT=2.   LABEL="HEAD REPORT HRS BUSNS 5"                 
      ER25902             FORMAT=2.   LABEL="WIFE WORK IN BUSINESS 5"                 
      ER25903             FORMAT=2.   LABEL="WIFE REPORT HRS BUSNS 5"                 
      ER25904             FORMAT=1.   LABEL="G10 CORP/UNINCORP BUS5"                  
      ER25905             FORMAT=7.   LABEL="G11 GROSS RECEIPTS BUS 5"                
      ER25906             FORMAT=7.   LABEL="G11A EXPENSES BUS 5"                     
      ER25907             FORMAT=7.   LABEL="G11B PROFIT/LOSS BUS 5"                  
      ER25908             FORMAT=1.   LABEL="ACCURACY OF BUSINESS5 PROFIT/LOSS"       
      ER25909             FORMAT=1.   LABEL="G12 HEAD HAVE WAGES"                     
      ER25910             FORMAT=7.   LABEL="G13 WAGES/SALARY OF HEAD"                
      ER25911             FORMAT=1.   LABEL="ACCURACY OF WAGES/SALARY-HEAD"           
      ER25912             FORMAT=1.   LABEL="G14/16 HD BONUS/OT/COMM"                 
      ER25913             FORMAT=1.   LABEL="HEAD HAVE BONUS"                         
      ER25914             FORMAT=6.   LABEL="AMT HEAD BONUS"                          
      ER25915             FORMAT=1.   LABEL="ACCURACY OF BONUS-HEAD"                  
      ER25916             FORMAT=1.   LABEL="HEAD HAVE OVERTIME"                      
      ER25917             FORMAT=6.   LABEL="AMT HEAD OVERTIME"                       
      ER25918             FORMAT=1.   LABEL="ACCURACY OF OVERTIME-HEAD"               
      ER25919             FORMAT=1.   LABEL="HEAD HAVE TIPS"                          
      ER25920             FORMAT=6.   LABEL="AMT HEAD TIPS"                           
      ER25921             FORMAT=1.   LABEL="ACCURACY OF TIPS-HEAD"                   
      ER25922             FORMAT=1.   LABEL="HEAD HAVE COMMISSION"                    
      ER25923             FORMAT=6.   LABEL="AMT HEAD COMMISSION"                     
      ER25924             FORMAT=1.   LABEL="ACCURACY OF COMMISSION-HEAD"             
      ER25925             FORMAT=1.   LABEL="WTR OTHER LABOR Y-HEAD"                  
      ER25926             FORMAT=6.   LABEL="AMT OTHER LABOR Y-HEAD"                  
      ER25927             FORMAT=1.   LABEL="ACCURACY OF OTHER LABOR Y-HEAD"          
      ER25928             FORMAT=1.   LABEL="WTR WORK HRS FOR WAGES ETC"              
      ER25929             FORMAT=1.   LABEL="G18A WTR HEAD PROF PRACT"                
      ER25930             FORMAT=7.   LABEL="AMT PROF PRACTICE OF HD"                 
      ER25931             FORMAT=1.   LABEL="AMT PROF PRACTICE PER"                   
      ER25932             FORMAT=1.   LABEL="ACCURACY OF PROF PRACTICE-HEAD"          
      ER25933             FORMAT=1.   LABEL="PROF/TRADE INCOME H JAN"                 
      ER25934             FORMAT=1.   LABEL="PROF/TRADE INCOME H FEB"                 
      ER25935             FORMAT=1.   LABEL="PROF/TRADE INCOME H MAR"                 
      ER25936             FORMAT=1.   LABEL="PROF/TRADE INCOME H APR"                 
      ER25937             FORMAT=1.   LABEL="PROF/TRADE INCOME H MAY"                 
      ER25938             FORMAT=1.   LABEL="PROF/TRADE INCOME H JUN"                 
      ER25939             FORMAT=1.   LABEL="PROF/TRADE INCOME H JUL"                 
      ER25940             FORMAT=1.   LABEL="PROF/TRADE INCOME H AUG"                 
      ER25941             FORMAT=1.   LABEL="PROF/TRADE INCOME H SEP"                 
      ER25942             FORMAT=1.   LABEL="PROF/TRADE INCOME H OCT"                 
      ER25943             FORMAT=1.   LABEL="PROF/TRADE INCOME H NOV"                 
      ER25944             FORMAT=1.   LABEL="PROF/TRADE INCOME H DEC"                 
      ER25945             FORMAT=1.   LABEL="G21A WTR WORK HRS FOR PROF PRAC"         
      ER25946             FORMAT=1.   LABEL="G18B WTR HEAD MKT GDNING"                
      ER25947             FORMAT=7.   LABEL="AMT MKT GARDENING OF HD"                 
      ER25948             FORMAT=1.   LABEL="AMT MKT GARDENING PER"                   
      ER25949             FORMAT=1.   LABEL="ACCURACY OF MKT GARDENING-HEAD"          
      ER25950             FORMAT=1.   LABEL="GARDEN/FARM INCOME H JAN"                
      ER25951             FORMAT=1.   LABEL="GARDEN/FARM INCOME H FEB"                
      ER25952             FORMAT=1.   LABEL="GARDEN/FARM INCOME H MAR"                
      ER25953             FORMAT=1.   LABEL="GARDEN/FARM INCOME H APR"                
      ER25954             FORMAT=1.   LABEL="GARDEN/FARM INCOME H MAY"                
      ER25955             FORMAT=1.   LABEL="GARDEN/FARM INCOME H JUN"                
      ER25956             FORMAT=1.   LABEL="GARDEN/FARM INCOME H JUL"                
      ER25957             FORMAT=1.   LABEL="GARDEN/FARM INCOME H AUG"                
      ER25958             FORMAT=1.   LABEL="GARDEN/FARM INCOME H SEP"                
      ER25959             FORMAT=1.   LABEL="GARDEN/FARM INCOME H OCT"                
      ER25960             FORMAT=1.   LABEL="GARDEN/FARM INCOME H NOV"                
      ER25961             FORMAT=1.   LABEL="GARDEN/FARM INCOME H DEC"                
      ER25962             FORMAT=1.   LABEL="G21B WTR WORK HRS FOR MKT GRDNG"         
      ER25963             FORMAT=1.   LABEL="G18C WTR HEAD ROOMERS"                   
      ER25964             FORMAT=7.   LABEL="AMT ROOMERS/BOARDERS HD"                 
      ER25965             FORMAT=1.   LABEL="AMT ROOMERS/BOARDERS PER"                
      ER25966             FORMAT=1.   LABEL="ACCURACY OF ROOMERS/BOARDERS-HEAD"       
      ER25967             FORMAT=1.   LABEL="ROOM/BORD INCOME H JAN"                  
      ER25968             FORMAT=1.   LABEL="ROOM/BORD INCOME H FEB"                  
      ER25969             FORMAT=1.   LABEL="ROOM/BORD INCOME H MAR"                  
      ER25970             FORMAT=1.   LABEL="ROOM/BORD INCOME H APR"                  
      ER25971             FORMAT=1.   LABEL="ROOM/BORD INCOME H MAY"                  
      ER25972             FORMAT=1.   LABEL="ROOM/BORD INCOME H JUN"                  
      ER25973             FORMAT=1.   LABEL="ROOM/BORD INCOME H JUL"                  
      ER25974             FORMAT=1.   LABEL="ROOM/BORD INCOME H AUG"                  
      ER25975             FORMAT=1.   LABEL="ROOM/BORD INCOME H SEP"                  
      ER25976             FORMAT=1.   LABEL="ROOM/BORD INCOME H OCT"                  
      ER25977             FORMAT=1.   LABEL="ROOM/BORD INCOME H NOV"                  
      ER25978             FORMAT=1.   LABEL="ROOM/BORD INCOME H DEC"                  
      ER25979             FORMAT=1.   LABEL="G21C WTR WORK HRS FOR ROOMERS"           
      ER25980             FORMAT=1.   LABEL="G23 WTR INCL EARNINGS XTRA JOB"          
      ER25981             FORMAT=7.   LABEL="AMT FROM XTRA JOBS"                      
      ER25982             FORMAT=1.   LABEL="ACCURACY OF XTRA JOB INCOME-HEAD"        
      ER25983             FORMAT=1.   LABEL="G25A WHETHER RENT HEAD"                  
      ER25984             FORMAT=6.   LABEL="RENT OF HEAD"                            
      ER25985             FORMAT=1.   LABEL="RENT OF HEAD PER"                        
      ER25986             FORMAT=1.   LABEL="ACCURACY OF RENT-HEAD"                   
      ER25987             FORMAT=1.   LABEL="G26A2 WTR RENT JOINT WITH WIFE"          
      ER25988             FORMAT=1.   LABEL="RENT INCOME HEAD JAN"                    
      ER25989             FORMAT=1.   LABEL="RENT INCOME HEAD FEB"                    
      ER25990             FORMAT=1.   LABEL="RENT INCOME HEAD MAR"                    
      ER25991             FORMAT=1.   LABEL="RENT INCOME HEAD APR"                    
      ER25992             FORMAT=1.   LABEL="RENT INCOME HEAD MAY"                    
      ER25993             FORMAT=1.   LABEL="RENT INCOME HEAD JUN"                    
      ER25994             FORMAT=1.   LABEL="RENT INCOME HEAD JUL"                    
      ER25995             FORMAT=1.   LABEL="RENT INCOME HEAD AUG"                    
      ER25996             FORMAT=1.   LABEL="RENT INCOME HEAD SEP"                    
      ER25997             FORMAT=1.   LABEL="RENT INCOME HEAD OCT"                    
      ER25998             FORMAT=1.   LABEL="RENT INCOME HEAD NOV"                    
      ER25999             FORMAT=1.   LABEL="RENT INCOME HEAD DEC"                    
      ER26000             FORMAT=1.   LABEL="G25B WHETHER DIVIDENDS HEAD"             
      ER26001             FORMAT=6.   LABEL="DIVIDENDS OF HEAD"                       
      ER26002             FORMAT=1.   LABEL="DIVIDENDS OF HEAD PER"                   
      ER26003             FORMAT=1.   LABEL="ACCURACY OF DIVIDENDS-HEAD"              
      ER26004             FORMAT=1.   LABEL="G26B2 WTR DIVIDENDS JOINT WITH WIFE"     
      ER26005             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD JAN"                
      ER26006             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD FEB"                
      ER26007             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD MAR"                
      ER26008             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD APR"                
      ER26009             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD MAY"                
      ER26010             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD JUN"                
      ER26011             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD JUL"                
      ER26012             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD AUG"                
      ER26013             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD SEP"                
      ER26014             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD OCT"                
      ER26015             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD NOV"                
      ER26016             FORMAT=1.   LABEL="DIVIDEND INCOME HEAD DEC"                
      ER26017             FORMAT=1.   LABEL="G25C WHETHER INTEREST HEAD"              
      ER26018             FORMAT=6.   LABEL="INTEREST OF HEAD"                        
      ER26019             FORMAT=1.   LABEL="INTEREST OF HEAD PER"                    
      ER26020             FORMAT=1.   LABEL="ACCURACY OF INTEREST-HEAD"               
      ER26021             FORMAT=1.   LABEL="G26C2 WTR INTEREST JOINT WITH WIFE"      
      ER26022             FORMAT=1.   LABEL="INTEREST INCOME HEAD JAN"                
      ER26023             FORMAT=1.   LABEL="INTEREST INCOME HEAD FEB"                
      ER26024             FORMAT=1.   LABEL="INTEREST INCOME HEAD MAR"                
      ER26025             FORMAT=1.   LABEL="INTEREST INCOME HEAD APR"                
      ER26026             FORMAT=1.   LABEL="INTEREST INCOME HEAD MAY"                
      ER26027             FORMAT=1.   LABEL="INTEREST INCOME HEAD JUN"                
      ER26028             FORMAT=1.   LABEL="INTEREST INCOME HEAD JUL"                
      ER26029             FORMAT=1.   LABEL="INTEREST INCOME HEAD AUG"                
      ER26030             FORMAT=1.   LABEL="INTEREST INCOME HEAD SEP"                
      ER26031             FORMAT=1.   LABEL="INTEREST INCOME HEAD OCT"                
      ER26032             FORMAT=1.   LABEL="INTEREST INCOME HEAD NOV"                
      ER26033             FORMAT=1.   LABEL="INTEREST INCOME HEAD DEC"                
      ER26034             FORMAT=1.   LABEL="WHETHER TRUST FUND HEAD"                 
      ER26035             FORMAT=6.   LABEL="G25D TRUST FUND OF HEAD"                 
      ER26036             FORMAT=1.   LABEL="TRUST FUND OF HEAD PER"                  
      ER26037             FORMAT=1.   LABEL="ACCURACY OF TRUST FUND-HEAD"             
      ER26038             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H JAN"                
      ER26039             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H FEB"                
      ER26040             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H MAR"                
      ER26041             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H APR"                
      ER26042             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H MAY"                
      ER26043             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H JUN"                
      ER26044             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H JUL"                
      ER26045             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H AUG"                
      ER26046             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H SEP"                
      ER26047             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H OCT"                
      ER26048             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H NOV"                
      ER26049             FORMAT=1.   LABEL="TRUST/ROYAL INCOME H DEC"                
      ER26050             FORMAT=1.   LABEL="G25E WHETHER ADC/TANF HEAD"              
      ER26051             FORMAT=6.   LABEL="ADC/TANF OF HEAD"                        
      ER26052             FORMAT=1.   LABEL="ADC/TANF OF HEAD PER"                    
      ER26053             FORMAT=1.   LABEL="ACCURACY OF ADC/TANF-HEAD"               
      ER26054             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD JAN"                
      ER26055             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD FEB"                
      ER26056             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD MAR"                
      ER26057             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD APR"                
      ER26058             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD MAY"                
      ER26059             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD JUN"                
      ER26060             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD JUL"                
      ER26061             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD AUG"                
      ER26062             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD SEP"                
      ER26063             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD OCT"                
      ER26064             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD NOV"                
      ER26065             FORMAT=1.   LABEL="ADC/TANF INCOME HEAD DEC"                
      ER26066             FORMAT=1.   LABEL="G25F WHETHER SSI HEAD"                   
      ER26067             FORMAT=1.   LABEL="HEAD SSI SELF/ELSE/BOTH"                 
      ER26068             FORMAT=6.   LABEL="SSI OF HEAD"                             
      ER26069             FORMAT=1.   LABEL="SSI OF HEAD PER"                         
      ER26070             FORMAT=1.   LABEL="ACCURACY OF SSI-HEAD"                    
      ER26071             FORMAT=1.   LABEL="SSI INCOME HEAD JAN"                     
      ER26072             FORMAT=1.   LABEL="SSI INCOME HEAD FEB"                     
      ER26073             FORMAT=1.   LABEL="SSI INCOME HEAD MAR"                     
      ER26074             FORMAT=1.   LABEL="SSI INCOME HEAD APR"                     
      ER26075             FORMAT=1.   LABEL="SSI INCOME HEAD MAY"                     
      ER26076             FORMAT=1.   LABEL="SSI INCOME HEAD JUN"                     
      ER26077             FORMAT=1.   LABEL="SSI INCOME HEAD JUL"                     
      ER26078             FORMAT=1.   LABEL="SSI INCOME HEAD AUG"                     
      ER26079             FORMAT=1.   LABEL="SSI INCOME HEAD SEP"                     
      ER26080             FORMAT=1.   LABEL="SSI INCOME HEAD OCT"                     
      ER26081             FORMAT=1.   LABEL="SSI INCOME HEAD NOV"                     
      ER26082             FORMAT=1.   LABEL="SSI INCOME HEAD DEC"                     
      ER26083             FORMAT=1.   LABEL="G25G WHETHER OTHER WELFARE HD"           
      ER26084             FORMAT=6.   LABEL="OTHER WELFARE OF HEAD"                   
      ER26085             FORMAT=1.   LABEL="OTHER WELFARE OF HD PER"                 
      ER26086             FORMAT=1.   LABEL="ACCURACY OF OTR WELFARE-HEAD"            
      ER26087             FORMAT=1.   LABEL="OTR WELFARE INCOME H JAN"                
      ER26088             FORMAT=1.   LABEL="OTR WELFARE INCOME H FEB"                
      ER26089             FORMAT=1.   LABEL="OTR WELFARE INCOME H MAR"                
      ER26090             FORMAT=1.   LABEL="OTR WELFARE INCOME H APR"                
      ER26091             FORMAT=1.   LABEL="OTR WELFARE INCOME H MAY"                
      ER26092             FORMAT=1.   LABEL="OTR WELFARE INCOME H JUN"                
      ER26093             FORMAT=1.   LABEL="OTR WELFARE INCOME H JUL"                
      ER26094             FORMAT=1.   LABEL="OTR WELFARE INCOME H AUG"                
      ER26095             FORMAT=1.   LABEL="OTR WELFARE INCOME H SEP"                
      ER26096             FORMAT=1.   LABEL="OTR WELFARE INCOME H OCT"                
      ER26097             FORMAT=1.   LABEL="OTR WELFARE INCOME H NOV"                
      ER26098             FORMAT=1.   LABEL="OTR WELFARE INCOME H DEC"                
      ER26099             FORMAT=1.   LABEL="G31 ANY FU MEMB GET SOCSEC"              
      ER26100             FORMAT=1.   LABEL="G37 WHETHER HEAD VA PENSION"             
      ER26101             FORMAT=6.   LABEL="VA PENSION OF HEAD AMT"                  
      ER26102             FORMAT=1.   LABEL="VA PENSION OF HEAD PER"                  
      ER26103             FORMAT=1.   LABEL="ACCURACY OF VA PENSION-HEAD"             
      ER26104             FORMAT=1.   LABEL="VA INCOME HEAD JAN"                      
      ER26105             FORMAT=1.   LABEL="VA INCOME HEAD FEB"                      
      ER26106             FORMAT=1.   LABEL="VA INCOME HEAD MAR"                      
      ER26107             FORMAT=1.   LABEL="VA INCOME HEAD APR"                      
      ER26108             FORMAT=1.   LABEL="VA INCOME HEAD MAY"                      
      ER26109             FORMAT=1.   LABEL="VA INCOME HEAD JUN"                      
      ER26110             FORMAT=1.   LABEL="VA INCOME HEAD JUL"                      
      ER26111             FORMAT=1.   LABEL="VA INCOME HEAD AUG"                      
      ER26112             FORMAT=1.   LABEL="VA INCOME HEAD SEP"                      
      ER26113             FORMAT=1.   LABEL="VA INCOME HEAD OCT"                      
      ER26114             FORMAT=1.   LABEL="VA INCOME HEAD NOV"                      
      ER26115             FORMAT=1.   LABEL="VA INCOME HEAD DEC"                      
      ER26116             FORMAT=1.   LABEL="G40A WTR NONVA RETIREMT-HEAD"            
      ER26117             FORMAT=6.   LABEL="NONVA RETIREMENT-HEAD"                   
      ER26118             FORMAT=1.   LABEL="NONVA RETIREMENT PER-HD"                 
      ER26119             FORMAT=1.   LABEL="ACCURACY OF NONVA RETIREMENT-HEAD"       
      ER26120             FORMAT=1.   LABEL="RETIREMENT INCOME H JAN"                 
      ER26121             FORMAT=1.   LABEL="RETIREMENT INCOME H FEB"                 
      ER26122             FORMAT=1.   LABEL="RETIREMENT INCOME H MAR"                 
      ER26123             FORMAT=1.   LABEL="RETIREMENT INCOME H APR"                 
      ER26124             FORMAT=1.   LABEL="RETIREMENT INCOME H MAY"                 
      ER26125             FORMAT=1.   LABEL="RETIREMENT INCOME H JUN"                 
      ER26126             FORMAT=1.   LABEL="RETIREMENT INCOME H JUL"                 
      ER26127             FORMAT=1.   LABEL="RETIREMENT INCOME H AUG"                 
      ER26128             FORMAT=1.   LABEL="RETIREMENT INCOME H SEP"                 
      ER26129             FORMAT=1.   LABEL="RETIREMENT INCOME H OCT"                 
      ER26130             FORMAT=1.   LABEL="RETIREMENT INCOME H NOV"                 
      ER26131             FORMAT=1.   LABEL="RETIREMENT INCOME H DEC"                 
      ER26132             FORMAT=1.   LABEL="G40B WHETHER HEAD ANNUITIES"             
      ER26133             FORMAT=6.   LABEL="ANNUITIES OF HEAD"                       
      ER26134             FORMAT=1.   LABEL="ANNUITIES OF HEAD PER"                   
      ER26135             FORMAT=1.   LABEL="ACCURACY OF ANNUITIES-HEAD"              
      ER26136             FORMAT=1.   LABEL="ANNUITIES INCOME JAN"                    
      ER26137             FORMAT=1.   LABEL="ANNUITIES INCOME FEB"                    
      ER26138             FORMAT=1.   LABEL="ANNUITIES INCOME MAR"                    
      ER26139             FORMAT=1.   LABEL="ANNUITIES INCOME APR"                    
      ER26140             FORMAT=1.   LABEL="ANNUITIES INCOME MAY"                    
      ER26141             FORMAT=1.   LABEL="ANNUITIES INCOME JUN"                    
      ER26142             FORMAT=1.   LABEL="ANNUITIES INCOME JUL"                    
      ER26143             FORMAT=1.   LABEL="ANNUITIES INCOME AUG"                    
      ER26144             FORMAT=1.   LABEL="ANNUITIES INCOME SEP"                    
      ER26145             FORMAT=1.   LABEL="ANNUITIES INCOME OCT"                    
      ER26146             FORMAT=1.   LABEL="ANNUITIES INCOME NOV"                    
      ER26147             FORMAT=1.   LABEL="ANNUITIES INCOME DEC"                    
      ER26148             FORMAT=1.   LABEL="G40C WHETHER HEAD OTR PENSION"           
      ER26149             FORMAT=6.   LABEL="OTHER PENSION OF HEAD"                   
      ER26150             FORMAT=1.   LABEL="OTHER PENSION OF HD PER"                 
      ER26151             FORMAT=1.   LABEL="ACCURACY OF OTR PENSION-HEAD"            
      ER26152             FORMAT=1.   LABEL="OTR PENSION HEAD JAN"                    
      ER26153             FORMAT=1.   LABEL="OTR PENSION HEAD FEB"                    
      ER26154             FORMAT=1.   LABEL="OTR PENSION HEAD MAR"                    
      ER26155             FORMAT=1.   LABEL="OTR PENSION HEAD APR"                    
      ER26156             FORMAT=1.   LABEL="OTR PENSION HEAD MAY"                    
      ER26157             FORMAT=1.   LABEL="OTR PENSION HEAD JUN"                    
      ER26158             FORMAT=1.   LABEL="OTR PENSION HEAD JUL"                    
      ER26159             FORMAT=1.   LABEL="OTR PENSION HEAD AUG"                    
      ER26160             FORMAT=1.   LABEL="OTR PENSION HEAD SEP"                    
      ER26161             FORMAT=1.   LABEL="OTR PENSION HEAD OCT"                    
      ER26162             FORMAT=1.   LABEL="OTR PENSION HEAD NOV"                    
      ER26163             FORMAT=1.   LABEL="OTR PENSION HEAD DEC"                    
      ER26164             FORMAT=1.   LABEL="G43 NUM OF HEAD NON VA PENSN"            
      ER26165             FORMAT=1.   LABEL="G44A WTR UNEMPL COMP OF HEAD"            
      ER26166             FORMAT=6.   LABEL="AMT UNEMPL COMP OF HEAD"                 
      ER26167             FORMAT=1.   LABEL="AMT UNEMPL COMP HD PER"                  
      ER26168             FORMAT=1.   LABEL="ACCURACY OF UNEMPL COMP-HEAD"            
      ER26169             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD JAN"                
      ER26170             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD FEB"                
      ER26171             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD MAR"                
      ER26172             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD APR"                
      ER26173             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD MAY"                
      ER26174             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD JUN"                
      ER26175             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD JUL"                
      ER26176             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD AUG"                
      ER26177             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD SEP"                
      ER26178             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD OCT"                
      ER26179             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD NOV"                
      ER26180             FORMAT=1.   LABEL="UNEMPLOY INCOME HEAD DEC"                
      ER26181             FORMAT=1.   LABEL="G44B WTR WORKMEN COMP OF HEAD"           
      ER26182             FORMAT=6.   LABEL="AMT WORKMEN COMP OF HEAD"                
      ER26183             FORMAT=1.   LABEL="AMT WORKMEN COMP HD PER"                 
      ER26184             FORMAT=1.   LABEL="ACCURACY OF WORKMEN COMP-HEAD"           
      ER26185             FORMAT=1.   LABEL="WORKER COMP INCOME H JAN"                
      ER26186             FORMAT=1.   LABEL="WORKER COMP INCOME H FEB"                
      ER26187             FORMAT=1.   LABEL="WORKER COMP INCOME H MAR"                
      ER26188             FORMAT=1.   LABEL="WORKER COMP INCOME H APR"                
      ER26189             FORMAT=1.   LABEL="WORKER COMP INCOME H MAY"                
      ER26190             FORMAT=1.   LABEL="WORKER COMP INCOME H JUN"                
      ER26191             FORMAT=1.   LABEL="WORKER COMP INCOME H JUL"                
      ER26192             FORMAT=1.   LABEL="WORKER COMP INCOME H AUG"                
      ER26193             FORMAT=1.   LABEL="WORKER COMP INCOME H SEP"                
      ER26194             FORMAT=1.   LABEL="WORKER COMP INCOME H OCT"                
      ER26195             FORMAT=1.   LABEL="WORKER COMP INCOME H NOV"                
      ER26196             FORMAT=1.   LABEL="WORKER COMP INCOME H DEC"                
      ER26197             FORMAT=1.   LABEL="G44C WTR CHILD SUPPORT OF HD"            
      ER26198             FORMAT=6.   LABEL="AMT CHILD SUPPORT OF HD"                 
      ER26199             FORMAT=1.   LABEL="AMT CHILD SUPPORT HD PER"                
      ER26200             FORMAT=1.   LABEL="ACCURACY OF CHILD SUPPORT-HEAD"          
      ER26201             FORMAT=1.   LABEL="CHILD SUPPORT INC H JAN"                 
      ER26202             FORMAT=1.   LABEL="CHILD SUPPORT INC H FEB"                 
      ER26203             FORMAT=1.   LABEL="CHILD SUPPORT INC H MAR"                 
      ER26204             FORMAT=1.   LABEL="CHILD SUPPORT INC H APR"                 
      ER26205             FORMAT=1.   LABEL="CHILD SUPPORT INC H MAY"                 
      ER26206             FORMAT=1.   LABEL="CHILD SUPPORT INC H JUN"                 
      ER26207             FORMAT=1.   LABEL="CHILD SUPPORT INC H JUL"                 
      ER26208             FORMAT=1.   LABEL="CHILD SUPPORT INC H AUG"                 
      ER26209             FORMAT=1.   LABEL="CHILD SUPPORT INC H SEP"                 
      ER26210             FORMAT=1.   LABEL="CHILD SUPPORT INC H OCT"                 
      ER26211             FORMAT=1.   LABEL="CHILD SUPPORT INC H NOV"                 
      ER26212             FORMAT=1.   LABEL="CHILD SUPPORT INC H DEC"                 
      ER26213             FORMAT=1.   LABEL="G44D WTR ALIMONY OF HEAD"                
      ER26214             FORMAT=6.   LABEL="AMT ALIMONY OF HEAD"                     
      ER26215             FORMAT=1.   LABEL="AMT ALIMONY OF HEAD PER"                 
      ER26216             FORMAT=1.   LABEL="ACCURACY OF ALIMONY-HEAD"                
      ER26217             FORMAT=1.   LABEL="ALIMONY INCOME HEAD JAN"                 
      ER26218             FORMAT=1.   LABEL="ALIMONY INCOME HEAD FEB"                 
      ER26219             FORMAT=1.   LABEL="ALIMONY INCOME HEAD MAR"                 
      ER26220             FORMAT=1.   LABEL="ALIMONY INCOME HEAD APR"                 
      ER26221             FORMAT=1.   LABEL="ALIMONY INCOME HEAD MAY"                 
      ER26222             FORMAT=1.   LABEL="ALIMONY INCOME HEAD JUN"                 
      ER26223             FORMAT=1.   LABEL="ALIMONY INCOME HEAD JUL"                 
      ER26224             FORMAT=1.   LABEL="ALIMONY INCOME HEAD AUG"                 
      ER26225             FORMAT=1.   LABEL="ALIMONY INCOME HEAD SEP"                 
      ER26226             FORMAT=1.   LABEL="ALIMONY INCOME HEAD OCT"                 
      ER26227             FORMAT=1.   LABEL="ALIMONY INCOME HEAD NOV"                 
      ER26228             FORMAT=1.   LABEL="ALIMONY INCOME HEAD DEC"                 
      ER26229             FORMAT=1.   LABEL="G44E WTR HELP FRM RELATIV HEAD"          
      ER26230             FORMAT=6.   LABEL="AMT HELP FRM RELATIV HD"                 
      ER26231             FORMAT=1.   LABEL="AMT HELP FRM RELATIV PER"                
      ER26232             FORMAT=1.   LABEL="ACCURACY OF HELP FRM RELATIV-HEAD"       
      ER26233             FORMAT=1.   LABEL="HELP FROM RELATIVE H JAN"                
      ER26234             FORMAT=1.   LABEL="HELP FROM RELATIVE H FEB"                
      ER26235             FORMAT=1.   LABEL="HELP FROM RELATIVE H MAR"                
      ER26236             FORMAT=1.   LABEL="HELP FROM RELATIVE H APR"                
      ER26237             FORMAT=1.   LABEL="HELP FROM RELATIVE H MAY"                
      ER26238             FORMAT=1.   LABEL="HELP FROM RELATIVE H JUN"                
      ER26239             FORMAT=1.   LABEL="HELP FROM RELATIVE H JUL"                
      ER26240             FORMAT=1.   LABEL="HELP FROM RELATIVE H AUG"                
      ER26241             FORMAT=1.   LABEL="HELP FROM RELATIVE H SEP"                
      ER26242             FORMAT=1.   LABEL="HELP FROM RELATIVE H OCT"                
      ER26243             FORMAT=1.   LABEL="HELP FROM RELATIVE H NOV"                
      ER26244             FORMAT=1.   LABEL="HELP FROM RELATIVE H DEC"                
      ER26245             FORMAT=1.   LABEL="G44F WTR HELP FRM OTHERS HEAD"           
      ER26246             FORMAT=6.   LABEL="AMT HELP FRM OTHERS HD"                  
      ER26247             FORMAT=1.   LABEL="AMT HELP FRM OTHERS PER"                 
      ER26248             FORMAT=1.   LABEL="ACCURACY OF HELP FRM OTHERS-HEAD"        
      ER26249             FORMAT=1.   LABEL="HELP FROM OTHERS H JAN"                  
      ER26250             FORMAT=1.   LABEL="HELP FROM OTHERS H FEB"                  
      ER26251             FORMAT=1.   LABEL="HELP FROM OTHERS H MAR"                  
      ER26252             FORMAT=1.   LABEL="HELP FROM OTHERS H APR"                  
      ER26253             FORMAT=1.   LABEL="HELP FROM OTHERS H MAY"                  
      ER26254             FORMAT=1.   LABEL="HELP FROM OTHERS H JUN"                  
      ER26255             FORMAT=1.   LABEL="HELP FROM OTHERS H JUL"                  
      ER26256             FORMAT=1.   LABEL="HELP FROM OTHERS H AUG"                  
      ER26257             FORMAT=1.   LABEL="HELP FROM OTHERS H SEP"                  
      ER26258             FORMAT=1.   LABEL="HELP FROM OTHERS H OCT"                  
      ER26259             FORMAT=1.   LABEL="HELP FROM OTHERS H NOV"                  
      ER26260             FORMAT=1.   LABEL="HELP FROM OTHERS H DEC"                  
      ER26261             FORMAT=1.   LABEL="G44G WTR ANYTHING ELSE OF HD"            
      ER26262             FORMAT=6.   LABEL="AMT ANYTHING ELSE OF HD"                 
      ER26263             FORMAT=1.   LABEL="AMT ANYTHING ELSE PER"                   
      ER26264             FORMAT=1.   LABEL="ACCURACY OF ANYTHING ELSE-HEAD"          
      ER26265             FORMAT=1.   LABEL="ANY OTHER INCOME H JAN"                  
      ER26266             FORMAT=1.   LABEL="ANY OTHER INCOME H FEB"                  
      ER26267             FORMAT=1.   LABEL="ANY OTHER INCOME H MAR"                  
      ER26268             FORMAT=1.   LABEL="ANY OTHER INCOME H APR"                  
      ER26269             FORMAT=1.   LABEL="ANY OTHER INCOME H MAY"                  
      ER26270             FORMAT=1.   LABEL="ANY OTHER INCOME H JUN"                  
      ER26271             FORMAT=1.   LABEL="ANY OTHER INCOME H JUL"                  
      ER26272             FORMAT=1.   LABEL="ANY OTHER INCOME H AUG"                  
      ER26273             FORMAT=1.   LABEL="ANY OTHER INCOME H SEP"                  
      ER26274             FORMAT=1.   LABEL="ANY OTHER INCOME H OCT"                  
      ER26275             FORMAT=1.   LABEL="ANY OTHER INCOME H NOV"                  
      ER26276             FORMAT=1.   LABEL="ANY OTHER INCOME H DEC"                  
      ER26277             FORMAT=1.   LABEL="G49 WTR WIFE IN FU NOW"                  
      ER26278             FORMAT=1.   LABEL="G50 WHETHER WIFE HAD INCOME"             
      ER26279             FORMAT=1.   LABEL="G51A WHETHER WIFE LABOR INC"             
      ER26280             FORMAT=1.   LABEL="G51B WHETHER WFE INC FRM WORK"           
      ER26281             FORMAT=7.   LABEL="WAGES/SALARY OF WIFE"                    
      ER26282             FORMAT=1.   LABEL="ACCURACY OF WAGES/SALARY-WIFE"           
      ER26283             FORMAT=1.   LABEL="G52B WTR WORK HOURS FOR WIFE"            
      ER26284             FORMAT=1.   LABEL="G53 WHETHER UNEMPLOYMENT WFE"            
      ER26285             FORMAT=6.   LABEL="UNEMPLOYMNT COMP OF WIFE"                
      ER26286             FORMAT=1.   LABEL="UNEMPLOYMNT COMP WFE PER"                
      ER26287             FORMAT=1.   LABEL="ACCURACY OF UNEMPLOYMENT COMP-WIFE"      
      ER26288             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE JAN"                
      ER26289             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE FEB"                
      ER26290             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE MAR"                
      ER26291             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE APR"                
      ER26292             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE MAY"                
      ER26293             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE JUN"                
      ER26294             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE JUL"                
      ER26295             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE AUG"                
      ER26296             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE SEP"                
      ER26297             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE OCT"                
      ER26298             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE NOV"                
      ER26299             FORMAT=1.   LABEL="UNEMPLOY INCOME WIFE DEC"                
      ER26300             FORMAT=1.   LABEL="G56 WHETHER WORKERS COMP WFE"            
      ER26301             FORMAT=6.   LABEL="WORKERS COMP OF WIFE"                    
      ER26302             FORMAT=1.   LABEL="WORKERS COMP OF WIFE PER"                
      ER26303             FORMAT=1.   LABEL="ACCURACY OF WORKERS COMP-WIFE"           
      ER26304             FORMAT=1.   LABEL="WORKER COMP INCOME W JAN"                
      ER26305             FORMAT=1.   LABEL="WORKER COMP INCOME W FEB"                
      ER26306             FORMAT=1.   LABEL="WORKER COMP INCOME W MAR"                
      ER26307             FORMAT=1.   LABEL="WORKER COMP INCOME W APR"                
      ER26308             FORMAT=1.   LABEL="WORKER COMP INCOME W MAY"                
      ER26309             FORMAT=1.   LABEL="WORKER COMP INCOME W JUN"                
      ER26310             FORMAT=1.   LABEL="WORKER COMP INCOME W JUL"                
      ER26311             FORMAT=1.   LABEL="WORKER COMP INCOME W AUG"                
      ER26312             FORMAT=1.   LABEL="WORKER COMP INCOME W SEP"                
      ER26313             FORMAT=1.   LABEL="WORKER COMP INCOME W OCT"                
      ER26314             FORMAT=1.   LABEL="WORKER COMP INCOME W NOV"                
      ER26315             FORMAT=1.   LABEL="WORKER COMP INCOME W DEC"                
      ER26316             FORMAT=1.   LABEL="G59A WHETHER WIFE RENT"                  
      ER26317             FORMAT=6.   LABEL="RENT OF WIFE AMT"                        
      ER26318             FORMAT=1.   LABEL="RENT OF WIFE PER"                        
      ER26319             FORMAT=1.   LABEL="ACCURACY OF RENT-WIFE"                   
      ER26320             FORMAT=1.   LABEL="G59A3 WTR RENT ADDITIONAL TO HEAD AMT"   
      ER26321             FORMAT=1.   LABEL="RENT INCOME WIFE JAN"                    
      ER26322             FORMAT=1.   LABEL="RENT INCOME WIFE FEB"                    
      ER26323             FORMAT=1.   LABEL="RENT INCOME WIFE MAR"                    
      ER26324             FORMAT=1.   LABEL="RENT INCOME WIFE APR"                    
      ER26325             FORMAT=1.   LABEL="RENT INCOME WIFE MAY"                    
      ER26326             FORMAT=1.   LABEL="RENT INCOME WIFE JUN"                    
      ER26327             FORMAT=1.   LABEL="RENT INCOME WIFE JUL"                    
      ER26328             FORMAT=1.   LABEL="RENT INCOME WIFE AUG"                    
      ER26329             FORMAT=1.   LABEL="RENT INCOME WIFE SEP"                    
      ER26330             FORMAT=1.   LABEL="RENT INCOME WIFE OCT"                    
      ER26331             FORMAT=1.   LABEL="RENT INCOME WIFE NOV"                    
      ER26332             FORMAT=1.   LABEL="RENT INCOME WIFE DEC"                    
      ER26333             FORMAT=1.   LABEL="G59B WHETHER WIFE DIVIDENDS"             
      ER26334             FORMAT=6.   LABEL="DIVIDENDS OF WIFE AMT"                   
      ER26335             FORMAT=1.   LABEL="DIVIDENDS OF WIFE PER"                   
      ER26336             FORMAT=1.   LABEL="ACCURACY OF DIVIDENDS-WIFE"              
      ER26337             FORMAT=1.   LABEL="G59B3 WTR DIVS ADDITIONAL TO HEAD AMT"   
      ER26338             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE JAN"                
      ER26339             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE FEB"                
      ER26340             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE MAR"                
      ER26341             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE APR"                
      ER26342             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE MAY"                
      ER26343             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE JUN"                
      ER26344             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE JUL"                
      ER26345             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE AUG"                
      ER26346             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE SEP"                
      ER26347             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE OCT"                
      ER26348             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE NOV"                
      ER26349             FORMAT=1.   LABEL="DIVIDEND INCOME WIFE DEC"                
      ER26350             FORMAT=1.   LABEL="G59C WHETHER WIFE INTEREST"              
      ER26351             FORMAT=6.   LABEL="INTEREST OF WIFE AMT"                    
      ER26352             FORMAT=1.   LABEL="INTEREST OF WIFE AMT PER"                
      ER26353             FORMAT=1.   LABEL="ACCURACY OF INTEREST-WIFE"               
      ER26354             FORMAT=1.   LABEL="G59C3 WTR INTEREST ADDITNL TO HEAD AMT"  
      ER26355             FORMAT=1.   LABEL="INTEREST INCOME WIFE JAN"                
      ER26356             FORMAT=1.   LABEL="INTEREST INCOME WIFE FEB"                
      ER26357             FORMAT=1.   LABEL="INTEREST INCOME WIFE MAR"                
      ER26358             FORMAT=1.   LABEL="INTEREST INCOME WIFE APR"                
      ER26359             FORMAT=1.   LABEL="INTEREST INCOME WIFE MAY"                
      ER26360             FORMAT=1.   LABEL="INTEREST INCOME WIFE JUN"                
      ER26361             FORMAT=1.   LABEL="INTEREST INCOME WIFE JUL"                
      ER26362             FORMAT=1.   LABEL="INTEREST INCOME WIFE AUG"                
      ER26363             FORMAT=1.   LABEL="INTEREST INCOME WIFE SEP"                
      ER26364             FORMAT=1.   LABEL="INTEREST INCOME WIFE OCT"                
      ER26365             FORMAT=1.   LABEL="INTEREST INCOME WIFE NOV"                
      ER26366             FORMAT=1.   LABEL="INTEREST INCOME WIFE DEC"                
      ER26367             FORMAT=1.   LABEL="G59D WHETHER WIFE TRUST FUND"            
      ER26368             FORMAT=6.   LABEL="TRUST FUND OF WIFE AMT"                  
      ER26369             FORMAT=1.   LABEL="TRUST FUND OF WIFE PER"                  
      ER26370             FORMAT=1.   LABEL="ACCURACY OF TRUST FUND-WIFE"             
      ER26371             FORMAT=1.   LABEL="TRUST INCOME WIFE JAN"                   
      ER26372             FORMAT=1.   LABEL="TRUST INCOME WIFE FEB"                   
      ER26373             FORMAT=1.   LABEL="TRUST INCOME WIFE MAR"                   
      ER26374             FORMAT=1.   LABEL="TRUST INCOME WIFE APR"                   
      ER26375             FORMAT=1.   LABEL="TRUST INCOME WIFE MAY"                   
      ER26376             FORMAT=1.   LABEL="TRUST INCOME WIFE JUN"                   
      ER26377             FORMAT=1.   LABEL="TRUST INCOME WIFE JUL"                   
      ER26378             FORMAT=1.   LABEL="TRUST INCOME WIFE AUG"                   
      ER26379             FORMAT=1.   LABEL="TRUST INCOME WIFE SEP"                   
      ER26380             FORMAT=1.   LABEL="TRUST INCOME WIFE OCT"                   
      ER26381             FORMAT=1.   LABEL="TRUST INCOME WIFE NOV"                   
      ER26382             FORMAT=1.   LABEL="TRUST INCOME WIFE DEC"                   
      ER26383             FORMAT=1.   LABEL="G60A WHETHER WIFE RECD SSI"              
      ER26384             FORMAT=1.   LABEL="G60A1 WIFE SSI SELF/ELSE/BOTH"           
      ER26385             FORMAT=6.   LABEL="SSI OF WIFE AMT"                         
      ER26386             FORMAT=1.   LABEL="SSI OF WIFE AMT PER"                     
      ER26387             FORMAT=1.   LABEL="ACCURACY OF SSI-WIFE"                    
      ER26388             FORMAT=1.   LABEL="SSI INCOME WIFE JAN"                     
      ER26389             FORMAT=1.   LABEL="SSI INCOME WIFE FEB"                     
      ER26390             FORMAT=1.   LABEL="SSI INCOME WIFE MAR"                     
      ER26391             FORMAT=1.   LABEL="SSI INCOME WIFE APR"                     
      ER26392             FORMAT=1.   LABEL="SSI INCOME WIFE MAY"                     
      ER26393             FORMAT=1.   LABEL="SSI INCOME WIFE JUN"                     
      ER26394             FORMAT=1.   LABEL="SSI INCOME WIFE JUL"                     
      ER26395             FORMAT=1.   LABEL="SSI INCOME WIFE AUG"                     
      ER26396             FORMAT=1.   LABEL="SSI INCOME WIFE SEP"                     
      ER26397             FORMAT=1.   LABEL="SSI INCOME WIFE OCT"                     
      ER26398             FORMAT=1.   LABEL="SSI INCOME WIFE NOV"                     
      ER26399             FORMAT=1.   LABEL="SSI INCOME WIFE DEC"                     
      ER26400             FORMAT=1.   LABEL="G60B WTR WIFE RECD ADC/TANF"             
      ER26401             FORMAT=6.   LABEL="ADC/TANF OF WIFE AMT"                    
      ER26402             FORMAT=1.   LABEL="ADC/TANF OF WIFE AMT PER"                
      ER26403             FORMAT=1.   LABEL="ACCURACY OF ADC/TANF-WIFE"               
      ER26404             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE JAN"                
      ER26405             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE FEB"                
      ER26406             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE MAR"                
      ER26407             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE APR"                
      ER26408             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE MAY"                
      ER26409             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE JUN"                
      ER26410             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE JUL"                
      ER26411             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE AUG"                
      ER26412             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE SEP"                
      ER26413             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE OCT"                
      ER26414             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE NOV"                
      ER26415             FORMAT=1.   LABEL="ADC/TANF INCOME WIFE DEC"                
      ER26416             FORMAT=1.   LABEL="G60C WTR WF RECD CHILD SUPPRT"           
      ER26417             FORMAT=6.   LABEL="CHILD SUPPORT OF WF AMT"                 
      ER26418             FORMAT=1.   LABEL="CHILD SUPPORT OF WF PER"                 
      ER26419             FORMAT=1.   LABEL="ACCURACY OF CHILD SUPPORT-WIFE"          
      ER26420             FORMAT=1.   LABEL="CHILD SUPPORT INC W JAN"                 
      ER26421             FORMAT=1.   LABEL="CHILD SUPPORT INC W FEB"                 
      ER26422             FORMAT=1.   LABEL="CHILD SUPPORT INC W MAR"                 
      ER26423             FORMAT=1.   LABEL="CHILD SUPPORT INC W APR"                 
      ER26424             FORMAT=1.   LABEL="CHILD SUPPORT INC W MAY"                 
      ER26425             FORMAT=1.   LABEL="CHILD SUPPORT INC W JUN"                 
      ER26426             FORMAT=1.   LABEL="CHILD SUPPORT INC W JUL"                 
      ER26427             FORMAT=1.   LABEL="CHILD SUPPORT INC W AUG"                 
      ER26428             FORMAT=1.   LABEL="CHILD SUPPORT INC W SEP"                 
      ER26429             FORMAT=1.   LABEL="CHILD SUPPORT INC W OCT"                 
      ER26430             FORMAT=1.   LABEL="CHILD SUPPORT INC W NOV"                 
      ER26431             FORMAT=1.   LABEL="CHILD SUPPORT INC W DEC"                 
      ER26432             FORMAT=1.   LABEL="G60D WTR WF RECD OTR WELFARE"            
      ER26433             FORMAT=6.   LABEL="OTHER WELFARE OF WF AMT"                 
      ER26434             FORMAT=1.   LABEL="OTHER WELFARE OF WF PER"                 
      ER26435             FORMAT=1.   LABEL="ACCURACY OF OTHER WELFARE-WIFE"          
      ER26436             FORMAT=1.   LABEL="OTHER WELFARE INC W JAN"                 
      ER26437             FORMAT=1.   LABEL="OTHER WELFARE INC W FEB"                 
      ER26438             FORMAT=1.   LABEL="OTHER WELFARE INC W MAR"                 
      ER26439             FORMAT=1.   LABEL="OTHER WELFARE INC W APR"                 
      ER26440             FORMAT=1.   LABEL="OTHER WELFARE INC W MAY"                 
      ER26441             FORMAT=1.   LABEL="OTHER WELFARE INC W JUN"                 
      ER26442             FORMAT=1.   LABEL="OTHER WELFARE INC W JUL"                 
      ER26443             FORMAT=1.   LABEL="OTHER WELFARE INC W AUG"                 
      ER26444             FORMAT=1.   LABEL="OTHER WELFARE INC W SEP"                 
      ER26445             FORMAT=1.   LABEL="OTHER WELFARE INC W OCT"                 
      ER26446             FORMAT=1.   LABEL="OTHER WELFARE INC W NOV"                 
      ER26447             FORMAT=1.   LABEL="OTHER WELFARE INC W DEC"                 
      ER26448             FORMAT=1.   LABEL="G61 WTR WF RECD PENS/ANNUITY"            
      ER26449             FORMAT=6.   LABEL="PENSION/ANNUITY WF AMT"                  
      ER26450             FORMAT=1.   LABEL="PENSION/ANNUITY WF PER"                  
      ER26451             FORMAT=1.   LABEL="ACCURACY OF PENSION/ANNUITY-WIFE"        
      ER26452             FORMAT=1.   LABEL="PENSION/ANNUITY W JAN"                   
      ER26453             FORMAT=1.   LABEL="PENSION/ANNUITY W FEB"                   
      ER26454             FORMAT=1.   LABEL="PENSION/ANNUITY W MAR"                   
      ER26455             FORMAT=1.   LABEL="PENSION/ANNUITY W APR"                   
      ER26456             FORMAT=1.   LABEL="PENSION/ANNUITY W MAY"                   
      ER26457             FORMAT=1.   LABEL="PENSION/ANNUITY W JUN"                   
      ER26458             FORMAT=1.   LABEL="PENSION/ANNUITY W JUL"                   
      ER26459             FORMAT=1.   LABEL="PENSION/ANNUITY W AUG"                   
      ER26460             FORMAT=1.   LABEL="PENSION/ANNUITY W SEP"                   
      ER26461             FORMAT=1.   LABEL="PENSION/ANNUITY W OCT"                   
      ER26462             FORMAT=1.   LABEL="PENSION/ANNUITY W NOV"                   
      ER26463             FORMAT=1.   LABEL="PENSION/ANNUITY W DEC"                   
      ER26464             FORMAT=1.   LABEL="G62A WTR WF HELP FR RELATIVES"           
      ER26465             FORMAT=6.   LABEL="HELP FR RELATIVES WF AMT"                
      ER26466             FORMAT=1.   LABEL="HELP FR RELS WF PER"                     
      ER26467             FORMAT=1.   LABEL="ACCURACY OF HELP FRM RELATIVES-WIFE"     
      ER26468             FORMAT=1.   LABEL="HELP FR RELATIVES WF JAN"                
      ER26469             FORMAT=1.   LABEL="HELP FR RELATIVES WF FEB"                
      ER26470             FORMAT=1.   LABEL="HELP FR RELATIVES WF MAR"                
      ER26471             FORMAT=1.   LABEL="HELP FR RELATIVES WF APR"                
      ER26472             FORMAT=1.   LABEL="HELP FR RELATIVES WF MAY"                
      ER26473             FORMAT=1.   LABEL="HELP FR RELATIVES WF JUN"                
      ER26474             FORMAT=1.   LABEL="HELP FR RELATIVES WF JUL"                
      ER26475             FORMAT=1.   LABEL="HELP FR RELATIVES WF AUG"                
      ER26476             FORMAT=1.   LABEL="HELP FR RELATIVES WF SEP"                
      ER26477             FORMAT=1.   LABEL="HELP FR RELATIVES WF OCT"                
      ER26478             FORMAT=1.   LABEL="HELP FR RELATIVES WF NOV"                
      ER26479             FORMAT=1.   LABEL="HELP FR RELATIVES WF DEC"                
      ER26480             FORMAT=1.   LABEL="G62B WTR WF HELP FROM FRIENDS"           
      ER26481             FORMAT=6.   LABEL="HELP FR FRIENDS WF AMT"                  
      ER26482             FORMAT=1.   LABEL="HELP FR FRIENDS WF PER"                  
      ER26483             FORMAT=1.   LABEL="ACCURACY OF HELP FRM FRIENDS-WIFE"       
      ER26484             FORMAT=1.   LABEL="HELP FROM FRIENDS W JAN"                 
      ER26485             FORMAT=1.   LABEL="HELP FROM FRIENDS W FEB"                 
      ER26486             FORMAT=1.   LABEL="HELP FROM FRIENDS W MAR"                 
      ER26487             FORMAT=1.   LABEL="HELP FROM FRIENDS W APR"                 
      ER26488             FORMAT=1.   LABEL="HELP FROM FRIENDS W MAY"                 
      ER26489             FORMAT=1.   LABEL="HELP FROM FRIENDS W JUN"                 
      ER26490             FORMAT=1.   LABEL="HELP FROM FRIENDS W JUL"                 
      ER26491             FORMAT=1.   LABEL="HELP FROM FRIENDS W AUG"                 
      ER26492             FORMAT=1.   LABEL="HELP FROM FRIENDS W SEP"                 
      ER26493             FORMAT=1.   LABEL="HELP FROM FRIENDS W OCT"                 
      ER26494             FORMAT=1.   LABEL="HELP FROM FRIENDS W NOV"                 
      ER26495             FORMAT=1.   LABEL="HELP FROM FRIENDS W DEC"                 
      ER26496             FORMAT=1.   LABEL="G63 WTR WFE RECD OTR INCOME"             
      ER26497             FORMAT=5.   LABEL="WIFE OTHER INCOME AMT"                   
      ER26498             FORMAT=1.   LABEL="WIFE OTHER INCOME PER"                   
      ER26499             FORMAT=1.   LABEL="ACCURACY OF OTHER INCOME-WIFE"           
      ER26500             FORMAT=1.   LABEL="ANY OTHER INCOME W JAN"                  
      ER26501             FORMAT=1.   LABEL="ANY OTHER INCOME W FEB"                  
      ER26502             FORMAT=1.   LABEL="ANY OTHER INCOME W MAR"                  
      ER26503             FORMAT=1.   LABEL="ANY OTHER INCOME W APR"                  
      ER26504             FORMAT=1.   LABEL="ANY OTHER INCOME W MAY"                  
      ER26505             FORMAT=1.   LABEL="ANY OTHER INCOME W JUN"                  
      ER26506             FORMAT=1.   LABEL="ANY OTHER INCOME W JUL"                  
      ER26507             FORMAT=1.   LABEL="ANY OTHER INCOME W AUG"                  
      ER26508             FORMAT=1.   LABEL="ANY OTHER INCOME W SEP"                  
      ER26509             FORMAT=1.   LABEL="ANY OTHER INCOME W OCT"                  
      ER26510             FORMAT=1.   LABEL="ANY OTHER INCOME W NOV"                  
      ER26511             FORMAT=1.   LABEL="ANY OTHER INCOME W DEC"                  
      ER26512             FORMAT=1.   LABEL="G99 WTR LUMP SUM PAYMNTS"                
      ER26513             FORMAT=7.   LABEL="G100 LUMP SUM PAYMENTS"                  
      ER26514             FORMAT=7.   LABEL="G101 INHERITANCE"                        
      ER26515             FORMAT=1.   LABEL="G102 WTR ITEMIZE FOR TAX"                
      ER26516             FORMAT=6.   LABEL="G102A ITEMIZED CHARITABLE CONTRIB AMT"   
      ER26517             FORMAT=6.   LABEL="G102B ITEMIZED MEDICAL EXPENSES AMT"     
      ER26518             FORMAT=1.   LABEL="G103 WTR HELP OTRS"                      
      ER26519             FORMAT=2.   LABEL="G104 # OTRS SUPPORTED"                   
      ER26520             FORMAT=2.   LABEL="G105 WHO SUPPORT      1"                 
      ER26521             FORMAT=2.   LABEL="G105 WHO SUPPORT      2"                 
      ER26522             FORMAT=2.   LABEL="G105 WHO SUPPORT      3"                 
      ER26523             FORMAT=2.   LABEL="G105 WHO SUPPORT      4"                 
      ER26524             FORMAT=2.   LABEL="G105 WHO SUPPORT      5"                 
      ER26525             FORMAT=7.   LABEL="G106 TOTAL SUPP OF OTRS"                 
      ER26526             FORMAT=1.   LABEL="G107 ANY CHILD SUPPORT"                  
      ER26527             FORMAT=7.   LABEL="AMT OF CHLD SUPPRT GIVEN"                
      ER26528             FORMAT=1.   LABEL="G109 ANY ALIMONY"                        
      ER26529             FORMAT=7.   LABEL="AMT OF ALIMONY GIVEN"                    
      ER26530             FORMAT=1.   LABEL="G112 WTR DEPNDT OTRS"                    
      ER26531             FORMAT=2.   LABEL="G113 NUMBER DEPNDT OTR"                  
      ER26532             FORMAT=1.   LABEL="G114 WTR DEPNDT OTHS"                    
      ER26533             FORMAT=1.   LABEL="W1 WTR OTR REAL ESTATE"                  
      ER26534             FORMAT=1.   LABEL="W1A WTR SECOND HOME"                     
      ER26535             FORMAT=9.   LABEL="W2 PROFIT IF SOLD OTR REAL ESTATE"       
      ER26536             FORMAT=1.   LABEL="W3 WTR PROFIT GE 50,000"                 
      ER26537             FORMAT=1.   LABEL="W4 WTR PROFIT GE 150,000"                
      ER26538             FORMAT=1.   LABEL="W5 WTR PROFIT GE 5,000"                  
      ER26539             FORMAT=9.   LABEL="W6 PROFIT IF SOLD VEHICLES"              
      ER26540             FORMAT=1.   LABEL="W7 WTR PROFIT GE 10,000"                 
      ER26541             FORMAT=1.   LABEL="W8 WTR PROFIT GE 25,000"                 
      ER26542             FORMAT=1.   LABEL="W9 WTR PROFIT GE 2,000"                  
      ER26543             FORMAT=1.   LABEL="W10 WTR OWN BUSINESS/FARM"               
      ER26544             FORMAT=9.   LABEL="W11 PROFIT IF SOLD BUSINESS/FARM"        
      ER26545             FORMAT=1.   LABEL="W12 WTR PROFIT GE 50,000"                
      ER26546             FORMAT=1.   LABEL="W13 WTR PROFIT GE 200,000"               
      ER26547             FORMAT=1.   LABEL="W14 WTR PROFIT GE 10,000"                
      ER26548             FORMAT=1.   LABEL="W15 WTR OWN NON-IRA STOCK"               
      ER26549             FORMAT=9.   LABEL="W16 PROFIT IF SOLD NON-IRA STOCK"        
      ER26550             FORMAT=1.   LABEL="W17 WTR PROFIT GE 25,000"                
      ER26551             FORMAT=1.   LABEL="W18 WTR PROFIT GE 50,000"                
      ER26552             FORMAT=1.   LABEL="W19 WTR PROFIT GE 5,000"                 
      ER26553             FORMAT=1.   LABEL="W20 WTR PROFIT GE 100,000"               
      ER26554             FORMAT=1.   LABEL="W20D WTR DIVIDEND AMT CORRECT"           
      ER26555             FORMAT=6.   LABEL="W20E REVISED DIVIDENDS"                  
      ER26556             FORMAT=1.   LABEL="W20E REVISED DIVIDENDS PER"              
      ER26557             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN JAN"       
      ER26558             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN FEB"       
      ER26559             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN MAR"       
      ER26560             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN APR"       
      ER26561             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN MAY"       
      ER26562             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN JUN"       
      ER26563             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN JUL"       
      ER26564             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN AUG"       
      ER26565             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN SEP"       
      ER26566             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN OCT"       
      ER26567             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN NOV"       
      ER26568             FORMAT=1.   LABEL="W20F WTR REC REV DIVIDENDS IN DEC"       
      ER26569             FORMAT=1.   LABEL="W21 WTR IRA/PRIVATE ANNUITY"             
      ER26570             FORMAT=1.   LABEL="W21A HOW FUNDS INVESTED"                 
      ER26571             FORMAT=9.   LABEL="W22 VALUE OF IRA/ANNUITY"                
      ER26572             FORMAT=1.   LABEL="W23 WTR VALUE GE 25,000"                 
      ER26573             FORMAT=1.   LABEL="W24 WTR VALUE GE 50,000"                 
      ER26574             FORMAT=1.   LABEL="W26 WTR VALUE GE 100,000"                
      ER26575             FORMAT=1.   LABEL="W25 WTR VALUE GE 5,000"                  
      ER26576             FORMAT=1.   LABEL="W27 WTR CK/SAVINGS/CD, ETC"              
      ER26577             FORMAT=9.   LABEL="W28 AMT ALL ACCOUNTS"                    
      ER26578             FORMAT=1.   LABEL="W29 WTR VALUE GE 5,000"                  
      ER26579             FORMAT=1.   LABEL="W30 WTR VALUE GE 10,000"                 
      ER26580             FORMAT=1.   LABEL="W31 WTR VALUE GE 50,000"                 
      ER26581             FORMAT=1.   LABEL="W31D WTR INTEREST AMT CORRECT"           
      ER26582             FORMAT=6.   LABEL="W31E REVISED INTEREST"                   
      ER26583             FORMAT=1.   LABEL="W31E REVISED INTEREST PER"               
      ER26584             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN JAN"        
      ER26585             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN FEB"        
      ER26586             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN MAR"        
      ER26587             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN APR"        
      ER26588             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN MAY"        
      ER26589             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN JUN"        
      ER26590             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN JUL"        
      ER26591             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN AUG"        
      ER26592             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN SEP"        
      ER26593             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN OCT"        
      ER26594             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN NOV"        
      ER26595             FORMAT=1.   LABEL="W31F WTR REC REV INTEREST IN DEC"        
      ER26596             FORMAT=1.   LABEL="W32 WTR VALUE GE 1,000"                  
      ER26597             FORMAT=1.   LABEL="W33 WTR BONDS/INSURANCE, ETC."           
      ER26598             FORMAT=9.   LABEL="W34 PROFIT IF SOLD BONDS/INSURANCE"      
      ER26599             FORMAT=1.   LABEL="W35 WTR PROFIT GE 10,000"                
      ER26600             FORMAT=1.   LABEL="W36 WTR PROFIT GE 25,000"                
      ER26601             FORMAT=1.   LABEL="W37 WTR PROFIT GE 2,000"                 
      ER26602             FORMAT=1.   LABEL="W38 WTR OTHER DEBTS"                     
      ER26603             FORMAT=9.   LABEL="W39 VALUE ALL DEBTS"                     
      ER26604             FORMAT=1.   LABEL="W40 WTR DEBTS GE 2,000"                  
      ER26605             FORMAT=1.   LABEL="W41 WTR DEBTS GE 5,000"                  
      ER26606             FORMAT=1.   LABEL="W42 WTR DEBTS GE 1,000"                  
      ER26607             FORMAT=1.   LABEL="W43 WTR CHANGED IRA/PRIVATE ANNUITY"     
      ER26608             FORMAT=9.   LABEL="W44 AMT INVESTED IN IRA/ANNUITY"         
      ER26609             FORMAT=1.   LABEL="W45 WTR INVEST GE 10,000"                
      ER26610             FORMAT=1.   LABEL="W46 WTR INVEST GE 50,000"                
      ER26611             FORMAT=1.   LABEL="W47 WTR INVEST GE 5,000"                 
      ER26612             FORMAT=1.   LABEL="W48 WTR CASHED PNSN/ANNTY/IRA"           
      ER26613             FORMAT=9.   LABEL="W49 VALUE PENSION/ANNUITY/IRA"           
      ER26614             FORMAT=1.   LABEL="W50 WTR VALUE GE 10,000"                 
      ER26615             FORMAT=1.   LABEL="W51 WTR VALUE GE 50,000"                 
      ER26616             FORMAT=1.   LABEL="W52 WTR VALUE GE 100,000"                
      ER26617             FORMAT=1.   LABEL="W53 WTR VALUE GE 5,000"                  
      ER26618             FORMAT=1.   LABEL="W54 WTR SOLD HOME"                       
      ER26619             FORMAT=9.   LABEL="W55 HOME SELLING PRICE"                  
      ER26620             FORMAT=1.   LABEL="W56 WTR PRICE GE 60,000"                 
      ER26621             FORMAT=1.   LABEL="W57 WTR PRICE GE 120,000"                
      ER26622             FORMAT=1.   LABEL="W58 WTR PRICE GE 30,000"                 
      ER26623             FORMAT=1.   LABEL="W59 WTR BOUGHT OTR REAL ESTATE"          
      ER26624             FORMAT=9.   LABEL="W60 AMT IN REAL ESTATE"                  
      ER26625             FORMAT=1.   LABEL="W61 WTR AMT GE 60,000"                   
      ER26626             FORMAT=1.   LABEL="W62 WTR AMT GE 120,000"                  
      ER26627             FORMAT=1.   LABEL="W63 WTR AMT GE 30,000"                   
      ER26628             FORMAT=1.   LABEL="W64 WTR SOLD OTR REAL ESTATE"            
      ER26629             FORMAT=9.   LABEL="W65 AMT FROM OTR REAL ESTATE"            
      ER26630             FORMAT=1.   LABEL="W66 WTR AMT GE 60,000"                   
      ER26631             FORMAT=1.   LABEL="W67 WTR AMT GE 120,000"                  
      ER26632             FORMAT=1.   LABEL="W68 WTR AMT GE 30,000"                   
      ER26633             FORMAT=1.   LABEL="W69 WTR MADE ADDITION/REPAIRS"           
      ER26634             FORMAT=9.   LABEL="W70 COST OF ADDITION/REPAIRS"            
      ER26635             FORMAT=1.   LABEL="W71 WTR COST GE 25,000"                  
      ER26636             FORMAT=1.   LABEL="W72 WTR COST GE 75,000"                  
      ER26637             FORMAT=1.   LABEL="W73 WTR INVESTED IN BUSNES/FARM"         
      ER26638             FORMAT=9.   LABEL="W74 AMT INVESTED IN BUSINESS/FARM"       
      ER26639             FORMAT=1.   LABEL="W75 WTR AMT GE 25,000"                   
      ER26640             FORMAT=1.   LABEL="W76 WTR AMT GE 100,000"                  
      ER26641             FORMAT=1.   LABEL="W77 WTR AMT GE 10,000"                   
      ER26642             FORMAT=1.   LABEL="W78 WTR SOLD BUSINESS/FARM"              
      ER26643             FORMAT=9.   LABEL="W79 AMT FROM BUSINESS/FARM"              
      ER26644             FORMAT=1.   LABEL="W80 WTR AMT GE 25,000"                   
      ER26645             FORMAT=1.   LABEL="W81 WTR AMT GE 100,000"                  
      ER26646             FORMAT=1.   LABEL="W82 WTR AMT GE 10,000"                   
      ER26647             FORMAT=1.   LABEL="W83 WTR BOUGHT NON-IRA STOCK"            
      ER26648             FORMAT=1.   LABEL="W84 WTR ALSO SOLD STOCK"                 
      ER26649             FORMAT=1.   LABEL="W85 WTR BOUGHT MORE/SOLD MORE"           
      ER26650             FORMAT=9.   LABEL="W86 BALANCE IN/OUT STOCKS"               
      ER26651             FORMAT=1.   LABEL="W87 WTR STOCKS GE 20,000"                
      ER26652             FORMAT=1.   LABEL="W88 WTR STOCKS GE 50,000"                
      ER26653             FORMAT=1.   LABEL="W90 WTR STOCKS GE 100,000"               
      ER26654             FORMAT=1.   LABEL="W89 WTR STOCKS GE 5,000"                 
      ER26655             FORMAT=9.   LABEL="W91 AMT INVESTED IN STOCKS"              
      ER26656             FORMAT=1.   LABEL="W92 WTR AMT GE 20,000"                   
      ER26657             FORMAT=1.   LABEL="W93 WTR AMT GE 50,000"                   
      ER26658             FORMAT=1.   LABEL="W94 WTR AMT GE 100,000"                  
      ER26659             FORMAT=1.   LABEL="W95 WTR AMT GE 5,000"                    
      ER26660             FORMAT=1.   LABEL="W96 WTR SOLD NON-IRA STOCK"              
      ER26661             FORMAT=9.   LABEL="W97 AMT NON-IRA STOCK"                   
      ER26662             FORMAT=1.   LABEL="W98 WTR AMT GE 20,000"                   
      ER26663             FORMAT=1.   LABEL="W99 WTR AMT GE 50,000"                   
      ER26664             FORMAT=1.   LABEL="W100 WTR AMT GE 100,000"                 
      ER26665             FORMAT=1.   LABEL="W101 WTR AMT GE 5,000"                   
      ER26666             FORMAT=1.   LABEL="W102 WTR MOVER OUT W/ASSETS"             
      ER26667             FORMAT=9.   LABEL="W103 VALUE ASSETS MOVED OUT"             
      ER26668             FORMAT=1.   LABEL="W104 WTR VALUE GE 10,000"                
      ER26669             FORMAT=1.   LABEL="W105 WTR VALUE GE 25,000"                
      ER26670             FORMAT=1.   LABEL="W106 WTR VALUE GE 100,000"               
      ER26671             FORMAT=1.   LABEL="W107 WTR VALUE GE 5,000"                 
      ER26672             FORMAT=9.   LABEL="W108 VALUE DEBTS MOVED OUT"              
      ER26673             FORMAT=1.   LABEL="W109 WTR VALUE GE 10,000"                
      ER26674             FORMAT=1.   LABEL="W110 WTR VALUE GE 25,000"                
      ER26675             FORMAT=1.   LABEL="W111 WTR VALUE GE 5,000"                 
      ER26676             FORMAT=1.   LABEL="W112 CKPT: FU COMPOSITION"               
      ER26677             FORMAT=1.   LABEL="W113 WTR MOVER IN ASSETS"                
      ER26678             FORMAT=9.   LABEL="W114 VALUE ASSETS MOVED IN"              
      ER26679             FORMAT=1.   LABEL="W115 WTR VALUE GE 10,000"                
      ER26680             FORMAT=1.   LABEL="W116 WTR VALUE GE 25,000"                
      ER26681             FORMAT=1.   LABEL="W117 WTR VALUE GE 100,000"               
      ER26682             FORMAT=1.   LABEL="W118 WTR VALUE GE 5,000"                 
      ER26683             FORMAT=9.   LABEL="W119 VALUE DEBTS MOVE IN"                
      ER26684             FORMAT=1.   LABEL="W120 WTR VALUE GE 10,000"                
      ER26685             FORMAT=1.   LABEL="W121 WTR VALUE GE 25,000"                
      ER26686             FORMAT=1.   LABEL="W122 WTR VALUE GE 5,000"                 
      ER26687             FORMAT=1.   LABEL="W123 WTR RECD GIFT/INHERITANCE"          
      ER26688             FORMAT=4.   LABEL="W124 YR RECD GIFT/INHERIT-#1"            
      ER26689             FORMAT=9.   LABEL="W125 VALUE GIFT/INHERIT-#1"              
      ER26690             FORMAT=1.   LABEL="W126 WTR VALUE GE 25,000"                
      ER26691             FORMAT=1.   LABEL="W127 WTR VALUE GE 75,000"                
      ER26692             FORMAT=1.   LABEL="W128 WTR GIFT/INHERITANCE-#2"            
      ER26693             FORMAT=4.   LABEL="W129 YR RECD GIFT/INHERIT-#2"            
      ER26694             FORMAT=9.   LABEL="W130 VALUE GIFT/INHERIT-#2"              
      ER26695             FORMAT=1.   LABEL="W131 WTR VALUE GE 25,000"                
      ER26696             FORMAT=1.   LABEL="W132 WTR VALUE GE 75,000"                
      ER26697             FORMAT=1.   LABEL="W133 WTR GIFT/INHERITANCE-#3"            
      ER26698             FORMAT=4.   LABEL="W133A YR REC GIFT/INHERIT-#3"            
      ER26699             FORMAT=9.   LABEL="W133B VALUE GIFT/INHERIT-#3"             
      ER26700             FORMAT=1.   LABEL="W133C WTR VALUE GE 25,000"               
      ER26701             FORMAT=1.   LABEL="W133D WTR VALUE GE 75,000"               
      ER26702             FORMAT=1.   LABEL="P0 WTR WORKING NOW"                      
      ER26703             FORMAT=1.   LABEL="P1 WTR PNSN AT CURR JOB"                 
      ER26704             FORMAT=2.   LABEL="P6 # YRS IN PENSION PLAN"                
      ER26705             FORMAT=4.   LABEL="P6 YR JOINED PENSION PLAN"               
      ER26706             FORMAT=1.   LABEL="P7 WTR EVER ELIG FOR PLAN"               
      ER26707             FORMAT=3.   LABEL="P8 # YRS TILL ELIGIBLE"                  
      ER26708             FORMAT=1.   LABEL="P9 WTR VESTED"                           
      ER26709             FORMAT=3.   LABEL="P10 # YRS TILL VESTED"                   
      ER26710             FORMAT=1.   LABEL="P11 WTR CONTRIB TO PENSION"              
      ER26711             FORMAT=1.   LABEL="P12 WTR CONTRIB REQUIRED"                
      ER26712             FORMAT=7.   LABEL="P13 REQUIRED AMT"                        
      ER26713             FORMAT=1.   LABEL="P13 REQUIRED AMT PER"                    
      ER26714             FORMAT=3.   LABEL="P13 REQUIRED PCT"                        
      ER26715             FORMAT=1.   LABEL="P14 WTR VOLUNTARY CONTRIB"               
      ER26716             FORMAT=7.   LABEL="P15 VOLUNTARY AMT"                       
      ER26717             FORMAT=1.   LABEL="P15 VOLUNTARY AMT PER"                   
      ER26718             FORMAT=3.   LABEL="P15 VOLUNTARY PCT"                       
      ER26719             FORMAT=1.   LABEL="P16 HOW BENEFIT FIGURED"                 
      ER26720             FORMAT=1.   LABEL="P17 WTR EMPLYR CONTRIB"                  
      ER26721             FORMAT=7.   LABEL="P18 AMT EMPLYR CONTRIB"                  
      ER26722             FORMAT=1.   LABEL="P18 EMPLYR AMT PER"                      
      ER26723             FORMAT=3.   LABEL="P18 PCT EMPLYR CONTRIB"                  
      ER26724             FORMAT=3.   LABEL="P19 AGE PENSION INCL EMPLYR CONTRIB"     
      ER26725             FORMAT=9.   LABEL="P20 AMT IN PENSION ACCT NOW"             
      ER26726             FORMAT=1.   LABEL="P20A HOW FUNDS INVESTED"                 
      ER26727             FORMAT=9.   LABEL="P21 AMT COULD TAKE IF LEAVE EMPLYR"      
      ER26728             FORMAT=1.   LABEL="P21 AMT PER IF LEAVE EMPLYR"             
      ER26729             FORMAT=3.   LABEL="P21 PCT COULD TAKE IF LEAVE EMPLYR"      
      ER26730             FORMAT=1.   LABEL="P22 CKPT: TYPE PENSION"                  
      ER26731             FORMAT=1.   LABEL="P23 BENEFIT FORMULA"                     
      ER26732             FORMAT=3.   LABEL="P24 AGE FULL BENEFITS"                   
      ER26733             FORMAT=3.   LABEL="P25 # YRS NEC FOR FULL BENEFITS"         
      ER26734             FORMAT=3.   LABEL="P26 AGE IF AGE+YRS"                      
      ER26735             FORMAT=3.   LABEL="P26 # YRS IF AGE+YRS"                    
      ER26736             FORMAT=1.   LABEL="P27 WTR REC PART PNSN IF RETIRE EARLY"   
      ER26737             FORMAT=1.   LABEL="P28 EARLY RETRMT FORMULA"                
      ER26738             FORMAT=3.   LABEL="P29 AGE ELIG PART BENEFITS"              
      ER26739             FORMAT=3.   LABEL="P30 # YRS ELIG PART BENEFITS"            
      ER26740             FORMAT=3.   LABEL="P31 AGE IF AGE+YRS"                      
      ER26741             FORMAT=3.   LABEL="P31 # YRS IF AGE+YRS"                    
      ER26742             FORMAT=3.   LABEL="P32 AGE EXPECT RECEIVE BENEFITS"         
      ER26743             FORMAT=1.   LABEL="P33 WTR CAN ESTIMATE BENEFIT"            
      ER26744             FORMAT=7.   LABEL="P34 ESTIMATED BENEFIT AMT"               
      ER26745             FORMAT=1.   LABEL="P34 ESTIMATED BENEFIT PER"               
      ER26746             FORMAT=3.   LABEL="P34 ESTIMATED BENEFIT PCT"               
      ER26747             FORMAT=9.   LABEL="P34 ESTIMATED LUMP SUM BENEFIT"          
      ER26748             FORMAT=1.   LABEL="P35 WTR BENEFICIARY"                     
      ER26749             FORMAT=1.   LABEL="P36 AMT BENEFICIARY RECEIVES"            
      ER26750             FORMAT=1.   LABEL="P37 WTR PNSN LESSENED BY SOC SEC"        
      ER26751             FORMAT=1.   LABEL="P38 WHEN SOC SEC CHG PNSN AMT"           
      ER26752             FORMAT=2.   LABEL="P39 USUAL RETIREMNT AGE OF OTRS"         
      ER26753             FORMAT=2.   LABEL="P39 USUAL # YRS OTRS RETIRE"             
      ER26754             FORMAT=3.   LABEL="P40 AGE PLAN STOP WORK"                  
      ER26755             FORMAT=4.   LABEL="P40 YR PLAN STOP WORK"                   
      ER26756             FORMAT=3.   LABEL="P41 AGE WILL STOP WORK"                  
      ER26757             FORMAT=4.   LABEL="P41 YR WILL STOP WORK"                   
      ER26758             FORMAT=1.   LABEL="P42 WTR TAX-DEFER PLAN"                  
      ER26759             FORMAT=1.   LABEL="P43 WTR EMPLYR CONTRIB"                  
      ER26760             FORMAT=7.   LABEL="P44 AMT EMPLYR CONTRIB"                  
      ER26761             FORMAT=1.   LABEL="P44 EMPLYR CONTRIB PER"                  
      ER26762             FORMAT=3.   LABEL="P44 PCT EMPLYR CONTRIB"                  
      ER26763             FORMAT=1.   LABEL="P45 WTR PNSN W/PREV EMPLYR"              
      ER26764             FORMAT=1.   LABEL="P46 TYPE PREV PENSION-#1"                
      ER26765             FORMAT=8.   LABEL="P47 ACCT AMT WHEN LEFT PREV EMPLYR-#1"   
      ER26766             FORMAT=1.   LABEL="P48 WHAT DID W/PREV PNSN-#1"             
      ER26767             FORMAT=8.   LABEL="P49 AMT NOW PREV PNSN ACCT-#1"           
      ER26768             FORMAT=2.   LABEL="P50 AGE REC IF ANNUITY-#1"               
      ER26769             FORMAT=7.   LABEL="P51 AMT PREV ANNUITY-#1"                 
      ER26770             FORMAT=1.   LABEL="P51 PREV ANNUITY PER-#1"                 
      ER26771             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN1-#1"            
      ER26772             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN2-#1"            
      ER26773             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN3-#1"            
      ER26774             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN4-#1"            
      ER26775             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN5-#1"            
      ER26776             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN6-#1"            
      ER26777             FORMAT=2.   LABEL="P53 MO REC PREV PNSN-#1"                 
      ER26778             FORMAT=4.   LABEL="P53 YR REC PREV PNSN-#1"                 
      ER26779             FORMAT=7.   LABEL="P54 PREV PNSN BENEFIT AMT-#1"            
      ER26780             FORMAT=1.   LABEL="P54 BENEFIT PER-#1"                      
      ER26781             FORMAT=1.   LABEL="P55 WTR BENEFITS COLA-#1"                
      ER26782             FORMAT=1.   LABEL="P56 WTR BENEFITS EVER COLA-#1"           
      ER26783             FORMAT=7.   LABEL="P57 PREV PNSN CASH SETTLEMNT AMT-#1"     
      ER26784             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN1-#1"             
      ER26785             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN2-#1"             
      ER26786             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN3-#1"             
      ER26787             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN4-#1"             
      ER26788             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN5-#1"             
      ER26789             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN6-#1"             
      ER26790             FORMAT=7.   LABEL="P59 PREV PNSN IRA AMT-#1"                
      ER26791             FORMAT=2.   LABEL="P60 # YRS IN PREV PLAN-#1"               
      ER26792             FORMAT=2.   LABEL="P61 AGE EXPECT REC PREV PNSN-#1"         
      ER26793             FORMAT=6.   LABEL="P62 AMT EXPECT REC PREV PNSN-#1"         
      ER26794             FORMAT=1.   LABEL="P62 PREV PNSN PER-#1"                    
      ER26795             FORMAT=3.   LABEL="P62 PCT EXPECT REC PREV PNSN-#1"         
      ER26796             FORMAT=8.   LABEL="P62 LUMP SUM EXPECT PREV PNSN-#1"        
      ER26797             FORMAT=7.   LABEL="P63 ACCT AMT WHEN LEFT PREV EMPLYR-#1"   
      ER26798             FORMAT=1.   LABEL="P64 WHAT DID W/PREV PNSN-#1"             
      ER26799             FORMAT=8.   LABEL="P65 ACCT AMT PREV PNSN NOW-#1"           
      ER26800             FORMAT=2.   LABEL="P66 AGE BEGAN REC ANNUITY-#1"            
      ER26801             FORMAT=7.   LABEL="P67 AMT PREV ANNUITY-#1"                 
      ER26802             FORMAT=1.   LABEL="P67 PREV ANNUITY PER-#1"                 
      ER26803             FORMAT=2.   LABEL="P68 AGE ELIG PREV PNSN-#1"               
      ER26804             FORMAT=1.   LABEL="P69 WTR SECOND PREV PENSION"             
      ER26805             FORMAT=1.   LABEL="P46 TYPE PREV PENSION-#2"                
      ER26806             FORMAT=8.   LABEL="P47 ACCT AMT WHEN LEFT PREV EMPLYR-#2"   
      ER26807             FORMAT=1.   LABEL="P48 WHAT DID W/PREV PNSN-#2"             
      ER26808             FORMAT=8.   LABEL="P49 AMT NOW PREV PNSN ACCT-#2"           
      ER26809             FORMAT=2.   LABEL="P50 AGE REC IF ANNUITY-#2"               
      ER26810             FORMAT=7.   LABEL="P51 AMT PREV ANNUITY-#2"                 
      ER26811             FORMAT=1.   LABEL="P51 PREV ANNUITY PER-#2"                 
      ER26812             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN1-#2"            
      ER26813             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN2-#2"            
      ER26814             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN3-#2"            
      ER26815             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN4-#2"            
      ER26816             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN5-#2"            
      ER26817             FORMAT=1.   LABEL="P52 STATUS PREV PNSN MEN6-#2"            
      ER26818             FORMAT=2.   LABEL="P53 MO REC PREV PNSN-#2"                 
      ER26819             FORMAT=4.   LABEL="P53 YR REC PREV PNSN-#2"                 
      ER26820             FORMAT=7.   LABEL="P54 PREV PNSN BENEFIT AMT-#2"            
      ER26821             FORMAT=1.   LABEL="P54 BENEFIT PER-#2"                      
      ER26822             FORMAT=1.   LABEL="P55 WTR BENEFITS COLA-#2"                
      ER26823             FORMAT=1.   LABEL="P56 WTR BENEFITS EVER COLA-#2"           
      ER26824             FORMAT=7.   LABEL="P57 PREV PNSN CASH SETTLEMNT AMT-#2"     
      ER26825             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN1-#2"             
      ER26826             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN2-#2"             
      ER26827             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN3-#2"             
      ER26828             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN4-#2"             
      ER26829             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN5-#2"             
      ER26830             FORMAT=1.   LABEL="P58 WHAT DID W/CASH MEN6-#2"             
      ER26831             FORMAT=7.   LABEL="P59 PREV PNSN IRA AMT-#2"                
      ER26832             FORMAT=2.   LABEL="P60 # YRS IN PREV PLAN-#2"               
      ER26833             FORMAT=2.   LABEL="P61 AGE EXPECT REC PREV PNSN-#2"         
      ER26834             FORMAT=6.   LABEL="P62 AMT EXPECT REC PREV PNSN-#2"         
      ER26835             FORMAT=1.   LABEL="P62 PREV PNSN PER-#2"                    
      ER26836             FORMAT=3.   LABEL="P62 PCT EXPECT REC PREV PNSN-#2"         
      ER26837             FORMAT=8.   LABEL="P62 LUMP SUM EXPECT PREV PNSN-#2"        
      ER26838             FORMAT=7.   LABEL="P63 ACCT AMT WHEN LEFT PREV EMPLYR-#2"   
      ER26839             FORMAT=1.   LABEL="P64 WHAT DID W/PREV PNSN-#2"             
      ER26840             FORMAT=8.   LABEL="P65 ACCT AMT PREV PNSN NOW-#2"           
      ER26841             FORMAT=2.   LABEL="P66 AGE BEGAN REC ANNUITY-#2"            
      ER26842             FORMAT=7.   LABEL="P67 AMT PREV ANNUITY-#2"                 
      ER26843             FORMAT=1.   LABEL="P67 PREV ANNUITY PER-#2"                 
      ER26844             FORMAT=2.   LABEL="P68 AGE ELIG PREV PNSN-#2"               
      ER26845             FORMAT=1.   LABEL="P69 WTR 3RD PREV PENSION"                
      ER26846             FORMAT=1.   LABEL="P70 WTR WORKING NOW"                     
      ER26847             FORMAT=1.   LABEL="P71 WTR PNSN AT CURR JOB"                
      ER26848             FORMAT=2.   LABEL="P76 # YRS IN PENSION PLAN"               
      ER26849             FORMAT=4.   LABEL="P76 YR JOINED PENSION PLAN"              
      ER26850             FORMAT=1.   LABEL="P77 WTR EVER ELIG FOR PLAN"              
      ER26851             FORMAT=3.   LABEL="P78 # YRS TILL ELIGIBLE"                 
      ER26852             FORMAT=1.   LABEL="P79 WTR VESTED"                          
      ER26853             FORMAT=3.   LABEL="P80 # YRS TILL VESTED"                   
      ER26854             FORMAT=1.   LABEL="P81 WTR CONTRIB TO PENSION"              
      ER26855             FORMAT=1.   LABEL="P82 WTR CONTRIB REQUIRED"                
      ER26856             FORMAT=7.   LABEL="P83 REQUIRED AMT"                        
      ER26857             FORMAT=1.   LABEL="P83 REQUIRED AMT PER"                    
      ER26858             FORMAT=3.   LABEL="P83 REQUIRED PCT"                        
      ER26859             FORMAT=1.   LABEL="P84 WTR VOLUNTARY CONTRIB"               
      ER26860             FORMAT=7.   LABEL="P85 VOLUNTARY AMT"                       
      ER26861             FORMAT=1.   LABEL="P85 VOLUNTARY AMT PER"                   
      ER26862             FORMAT=3.   LABEL="P85 VOLUNTARY PCT"                       
      ER26863             FORMAT=1.   LABEL="P86 HOW BENEFIT FIGURED"                 
      ER26864             FORMAT=1.   LABEL="P87 WTR EMPLYR CONTRIB"                  
      ER26865             FORMAT=7.   LABEL="P88 AMT EMPLYR CONTRIB"                  
      ER26866             FORMAT=1.   LABEL="P88 EMPLYR AMT PER"                      
      ER26867             FORMAT=3.   LABEL="P88 PCT EMPLYR CONTRIB"                  
      ER26868             FORMAT=3.   LABEL="P89 AGE PENSION INCL EMPLYR CONTRIB"     
      ER26869             FORMAT=9.   LABEL="P90 AMT IN PENSION ACCT NOW"             
      ER26870             FORMAT=1.   LABEL="P90A HOW FUNDS INVESTED"                 
      ER26871             FORMAT=9.   LABEL="P91 AMT COULD TAKE IF LEAVE EMPLYR"      
      ER26872             FORMAT=1.   LABEL="P91 AMT PER IF LEAVE EMPLYR"             
      ER26873             FORMAT=3.   LABEL="P91 PCT COULD TAKE IF LEAVE EMPLYR"      
      ER26874             FORMAT=1.   LABEL="P92 CKPT: TYPE PENSION"                  
      ER26875             FORMAT=1.   LABEL="P93 BENEFIT FORMULA"                     
      ER26876             FORMAT=3.   LABEL="P94 AGE FULL BENEFITS"                   
      ER26877             FORMAT=3.   LABEL="P95 # YRS NEC FOR FULL BENEFITS"         
      ER26878             FORMAT=3.   LABEL="P96 AGE IF AGE+YRS"                      
      ER26879             FORMAT=3.   LABEL="P96 # YRS IF AGE+YRS"                    
      ER26880             FORMAT=1.   LABEL="P97 WTR REC PART PNSN IF RETIRE EARLY"   
      ER26881             FORMAT=1.   LABEL="P98 EARLY RETRMT FORMULA"                
      ER26882             FORMAT=3.   LABEL="P99 AGE ELIG PART BENEFITS"              
      ER26883             FORMAT=3.   LABEL="P100 # YRS ELIG PART BENEFITS"           
      ER26884             FORMAT=3.   LABEL="P101 AGE IF AGE+YRS"                     
      ER26885             FORMAT=3.   LABEL="P101 # YRS IF AGE+YRS"                   
      ER26886             FORMAT=3.   LABEL="P102 AGE EXPECT RECEIVE BENEFITS"        
      ER26887             FORMAT=1.   LABEL="P103 WTR CAN ESTIMATE BENEFIT"           
      ER26888             FORMAT=7.   LABEL="P104 ESTIMATED BENEFIT AMT"              
      ER26889             FORMAT=1.   LABEL="P104 ESTIMATED BENEFIT PER"              
      ER26890             FORMAT=3.   LABEL="P104 ESTIMATED BENEFIT PCT"              
      ER26891             FORMAT=9.   LABEL="P104 ESTIMATED LUMP SUM BENEFIT"         
      ER26892             FORMAT=1.   LABEL="P105 WTR BENEFICIARY"                    
      ER26893             FORMAT=1.   LABEL="P106 AMT BENEFICIARY RECEIVES"           
      ER26894             FORMAT=1.   LABEL="P107 WTR PNSN LESSENED BY SOC SEC"       
      ER26895             FORMAT=1.   LABEL="P108 WHEN SOC SEC CHG PNSN AMT"          
      ER26896             FORMAT=2.   LABEL="P109 USUAL RETIRMNT AGE OF OTRS"         
      ER26897             FORMAT=2.   LABEL="P109 USUAL # YRS OTRS RETIRE"            
      ER26898             FORMAT=3.   LABEL="P110 AGE PLAN STOP WORK"                 
      ER26899             FORMAT=4.   LABEL="P110 YR PLAN STOP WORK"                  
      ER26900             FORMAT=3.   LABEL="P111 AGE WILL STOP WORK"                 
      ER26901             FORMAT=4.   LABEL="P111 YR WILL STOP WORK"                  
      ER26902             FORMAT=1.   LABEL="P112 WTR TAX-DEFER PLAN"                 
      ER26903             FORMAT=1.   LABEL="P113 WTR EMPLYR CONTRIB"                 
      ER26904             FORMAT=7.   LABEL="P114 AMT EMPLYR CONTRIB"                 
      ER26905             FORMAT=1.   LABEL="P114 EMPLYR CONTRIB PER"                 
      ER26906             FORMAT=3.   LABEL="P114 PCT EMPLYR CONTRIB"                 
      ER26907             FORMAT=1.   LABEL="P115 WTR PNSN W/PREV EMPLYR"             
      ER26908             FORMAT=1.   LABEL="P116 TYPE PREV PENSION-#1"               
      ER26909             FORMAT=8.   LABEL="P117 ACCT AMT WHEN LEFT PREV EMPLYR-#1"  
      ER26910             FORMAT=1.   LABEL="P118 WHAT DID W/PREV PNSN-#1"            
      ER26911             FORMAT=8.   LABEL="P119 AMT NOW PREV PNSN ACCT-#1"          
      ER26912             FORMAT=2.   LABEL="P120 AGE REC IF ANNUITY-#1"              
      ER26913             FORMAT=7.   LABEL="P121 AMT PREV ANNUITY-#1"                
      ER26914             FORMAT=1.   LABEL="P121 PREV ANNUITY PER-#1"                
      ER26915             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN1-#1"           
      ER26916             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN2-#1"           
      ER26917             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN3-#1"           
      ER26918             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN4-#1"           
      ER26919             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN5-#1"           
      ER26920             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN6-#1"           
      ER26921             FORMAT=2.   LABEL="P123 MO REC PREV PNSN-#1"                
      ER26922             FORMAT=4.   LABEL="P123 YR REC PREV PNSN-#1"                
      ER26923             FORMAT=7.   LABEL="P124 PREV PNSN BENEFIT AMT-#1"           
      ER26924             FORMAT=1.   LABEL="P124 BENEFIT PER-#1"                     
      ER26925             FORMAT=1.   LABEL="P125 WTR BENEFITS COLA-#1"               
      ER26926             FORMAT=1.   LABEL="P126 WTR BENEFITS EVER COLA-#1"          
      ER26927             FORMAT=7.   LABEL="P127 PREV PNSN CASH SETTLEMNT AMT-#1"    
      ER26928             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN1-#1"            
      ER26929             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN2-#1"            
      ER26930             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN3-#1"            
      ER26931             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN4-#1"            
      ER26932             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN5-#1"            
      ER26933             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN6-#1"            
      ER26934             FORMAT=7.   LABEL="P129 PREV PNSN IRA AMT-#1"               
      ER26935             FORMAT=2.   LABEL="P130 # YRS IN PREV PLAN-#1"              
      ER26936             FORMAT=2.   LABEL="P131 AGE EXPECT REC PREV PNSN-#1"        
      ER26937             FORMAT=6.   LABEL="P132 AMT EXPECT REC PREV PNSN-#1"        
      ER26938             FORMAT=1.   LABEL="P132 PREV PNSN PER-#1"                   
      ER26939             FORMAT=3.   LABEL="P132 PCT EXPECT REC PREV PNSN-#1"        
      ER26940             FORMAT=8.   LABEL="P132 LUMP SUM EXPECT PREV PNSN-#1"       
      ER26941             FORMAT=7.   LABEL="P133 ACCT AMT WHEN LEFT PREV EMPLYR-#1"  
      ER26942             FORMAT=1.   LABEL="P134 WHAT DID W/PREV PNSN-#1"            
      ER26943             FORMAT=8.   LABEL="P135 ACCT AMT PREV PNSN NOW-#1"          
      ER26944             FORMAT=2.   LABEL="P136 AGE BEGAN REC ANNUITY-#1"           
      ER26945             FORMAT=7.   LABEL="P137 AMT PREV ANNUITY-#1"                
      ER26946             FORMAT=1.   LABEL="P137 PREV ANNUITY PER-#1"                
      ER26947             FORMAT=2.   LABEL="P138 AGE ELIG PREV PNSN-#1"              
      ER26948             FORMAT=1.   LABEL="P139 WTR SECOND PREV PENSION"            
      ER26949             FORMAT=1.   LABEL="P116 TYPE PREV PENSION-#2"               
      ER26950             FORMAT=8.   LABEL="P117 ACCT AMT WHEN LEFT PREV EMPLYR-#2"  
      ER26951             FORMAT=1.   LABEL="P118 WHAT DID W/PREV PNSN-#2"            
      ER26952             FORMAT=8.   LABEL="P119 AMT NOW PREV PNSN ACCT-#2"          
      ER26953             FORMAT=2.   LABEL="P120 AGE REC IF ANNUITY-#2"              
      ER26954             FORMAT=7.   LABEL="P121 AMT PREV ANNUITY-#2"                
      ER26955             FORMAT=1.   LABEL="P121 PREV ANNUITY PER-#2"                
      ER26956             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN1-#2"           
      ER26957             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN2-#2"           
      ER26958             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN3-#2"           
      ER26959             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN4-#2"           
      ER26960             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN5-#2"           
      ER26961             FORMAT=1.   LABEL="P122 STATUS PREV PNSN MEN6-#2"           
      ER26962             FORMAT=2.   LABEL="P123 MO REC PREV PNSN-#2"                
      ER26963             FORMAT=4.   LABEL="P123 YR REC PREV PNSN-#2"                
      ER26964             FORMAT=7.   LABEL="P124 PREV PNSN BENEFIT AMT-#2"           
      ER26965             FORMAT=1.   LABEL="P124 BENEFIT PER-#2"                     
      ER26966             FORMAT=1.   LABEL="P125 WTR BENEFITS COLA-#2"               
      ER26967             FORMAT=1.   LABEL="P126 WTR BENEFITS EVER COLA-#2"          
      ER26968             FORMAT=7.   LABEL="P127 PREV PNSN CASH SETTLEMNT AMT-#2"    
      ER26969             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN1-#2"            
      ER26970             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN2-#2"            
      ER26971             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN3-#2"            
      ER26972             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN4-#2"            
      ER26973             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN5-#2"            
      ER26974             FORMAT=1.   LABEL="P128 WHAT DID W/CASH MEN6-#2"            
      ER26975             FORMAT=7.   LABEL="P129 PREV PNSN IRA AMT-#2"               
      ER26976             FORMAT=2.   LABEL="P130 # YRS IN PREV PLAN-#2"              
      ER26977             FORMAT=2.   LABEL="P131 AGE EXPECT REC PREV PNSN-#2"        
      ER26978             FORMAT=6.   LABEL="P132 AMT EXPECT REC PREV PNSN-#2"        
      ER26979             FORMAT=1.   LABEL="P132 PREV PNSN PER-#2"                   
      ER26980             FORMAT=3.   LABEL="P132 PCT EXPECT REC PREV PNSN-#2"        
      ER26981             FORMAT=8.   LABEL="P132 LUMP SUM EXPECT PREV PNSN-#2"       
      ER26982             FORMAT=7.   LABEL="P133 ACCT AMT WHEN LEFT PREV EMPLYR-#2"  
      ER26983             FORMAT=1.   LABEL="P134 WHAT DID W/PREV PNSN-#2"            
      ER26984             FORMAT=8.   LABEL="P135 ACCT AMT PREV PNSN NOW-#2"          
      ER26985             FORMAT=2.   LABEL="P136 AGE BEGAN REC ANNUITY-#2"           
      ER26986             FORMAT=7.   LABEL="P137 AMT PREV ANNUITY-#2"                
      ER26987             FORMAT=1.   LABEL="P137 PREV ANNUITY PER-#2"                
      ER26988             FORMAT=2.   LABEL="P138 AGE ELIG PREV PNSN-#2"              
      ER26989             FORMAT=1.   LABEL="P139 WTR 3RD PREV PENSION"               
      ER26990             FORMAT=1.   LABEL="H1 HEALTH STATUS-HEAD"                   
      ER26991             FORMAT=1.   LABEL="H1A WTR HLTH BETTER/WORSE-HEAD"          
      ER26992             FORMAT=1.   LABEL="H1B WTR HEALTH BETTER-HEAD"              
      ER26993             FORMAT=1.   LABEL="H1C WTR HEALTH WORSE-HEAD"               
      ER26994             FORMAT=1.   LABEL="H1D HEALTH STATUS, BIRTH TO AGE 16-HD"   
      ER26995             FORMAT=1.   LABEL="H2 WTR LIMIT TYPE/AMT WRK- HEAD"         
      ER26996             FORMAT=1.   LABEL="H3 WTR UNABLE TO DO SOME TYPES WORK-HD"  
      ER26997             FORMAT=1.   LABEL="H4 WTR LIMIT AMT WRK CAN DO-HEAD"        
      ER26998             FORMAT=1.   LABEL="H5A WTR HAD STROKE-HEAD"                 
      ER26999             FORMAT=3.   LABEL="H6A1 AGE AT FIRST STROKE-HEAD"           
      ER27000             FORMAT=1.   LABEL="H6A2 WTR SECOND STROKE-HEAD"             
      ER27001             FORMAT=1.   LABEL="H7A WTR STROKE LIMIT DAILY ACTIVITY-HD"  
      ER27002             FORMAT=1.   LABEL="H5B WTR HEART ATTACK-HEAD"               
      ER27003             FORMAT=3.   LABEL="H6B1 AGE AT FIRST HEART ATTACK-HD"       
      ER27004             FORMAT=1.   LABEL="H6B2 WTR SECOND HEART ATTACK-HD"         
      ER27005             FORMAT=1.   LABEL="H7B WTR HEART ATTACK LIMIT ACTIVITY-HD"  
      ER27006             FORMAT=1.   LABEL="H5C WTR HEART DISEASE-HEAD"              
      ER27007             FORMAT=3.   LABEL="H6C1 AGE FIRST HAD HEART DISEASE-HD"     
      ER27008             FORMAT=1.   LABEL="H6C2 WTR HRT DISEASE GOT WORSE-HD"       
      ER27009             FORMAT=1.   LABEL="H7C WTR HRT DISEASE LIMIT ACTIVITY-HD"   
      ER27010             FORMAT=1.   LABEL="H5D WTR HYPERTENSION-HEAD"               
      ER27011             FORMAT=3.   LABEL="H6D1 AGE FIRST HAD HYPERTENSION-HD"      
      ER27012             FORMAT=1.   LABEL="H6D2 WTR HYPERTENSION GOT WORSE-HD"      
      ER27013             FORMAT=1.   LABEL="H7D WTR HYPERTENSION LIMIT ACTIVITY-HD"  
      ER27014             FORMAT=1.   LABEL="H5E WTR ASTHMA-HEAD"                     
      ER27015             FORMAT=3.   LABEL="H6E1 AGE FIRST HAD ASTHMA-HEAD"          
      ER27016             FORMAT=1.   LABEL="H6E2 WTR ASTHMA GOT WORSE-HEAD"          
      ER27017             FORMAT=1.   LABEL="H7E WTR ASTHMA LIMIT DAILY ACTIVITY-HD"  
      ER27018             FORMAT=1.   LABEL="H5F WTR LUNG DISEASE-HEAD"               
      ER27019             FORMAT=3.   LABEL="H6F1 AGE FIRST HAD LUNG DISEASE-HD"      
      ER27020             FORMAT=1.   LABEL="H6F2 WTR LUNG DISEASE GOT WORSE-HD"      
      ER27021             FORMAT=1.   LABEL="H7F WTR LUNG DISEASE LIMIT ACTIVITY-HD"  
      ER27022             FORMAT=1.   LABEL="H5G WTR DIABETES-HEAD"                   
      ER27023             FORMAT=3.   LABEL="H6G1 AGE FIRST HAD DIABETES-HEAD"        
      ER27024             FORMAT=1.   LABEL="H6G2 WTR DIABETES GOT WORSE-HEAD"        
      ER27025             FORMAT=1.   LABEL="H7G WTR DIABETES LIMIT ACTIVITY-HD"      
      ER27026             FORMAT=1.   LABEL="H5H WTR ARTHRITIS-HEAD"                  
      ER27027             FORMAT=3.   LABEL="H6H1 AGE FIRST HAD ARTHRITIS-HEAD"       
      ER27028             FORMAT=1.   LABEL="H6H2 WTR ARTHRITIS GOT WORSE-HEAD"       
      ER27029             FORMAT=1.   LABEL="H7H WTR ARTHRITIS LIMIT ACTIVITY-HD"     
      ER27030             FORMAT=1.   LABEL="H5I WTR MEMORY LOSS-HEAD"                
      ER27031             FORMAT=3.   LABEL="H6I1 AGE FIRST HAD MEMORY LOSS-HD"       
      ER27032             FORMAT=1.   LABEL="H6I2 WTR MEMORY LOSS GOT WORSE-HD"       
      ER27033             FORMAT=1.   LABEL="H7I WTR MEMORY LOSS LIMIT ACTIVITY-HD"   
      ER27034             FORMAT=1.   LABEL="H5J WTR LEARNING DISORDER-HEAD"          
      ER27035             FORMAT=3.   LABEL="H6J1 AGE FIRST HAD LRNG DISORDER-HD"     
      ER27036             FORMAT=1.   LABEL="H6J2 WTR LRNG DISORDER GOT WORSE-HD"     
      ER27037             FORMAT=1.   LABEL="H7J WTR LRNG DISORDR LIMIT ACTIVITY-HD"  
      ER27038             FORMAT=1.   LABEL="H5K WTR CANCER-HEAD"                     
      ER27039             FORMAT=3.   LABEL="H6K1 AGE FIRST HAD CANCER-HEAD"          
      ER27040             FORMAT=1.   LABEL="H6K2 WTR CANCER GOT WORSE-HEAD"          
      ER27041             FORMAT=1.   LABEL="H6K3 WTR TREATING, RMSSN, OR CURED-HD"   
      ER27042             FORMAT=2.   LABEL="H6K4 TYPE OF CANCER MENTION 1-HEAD"      
      ER27043             FORMAT=2.   LABEL="H6K4 TYPE OF CANCER MENTION 2-HEAD"      
      ER27044             FORMAT=1.   LABEL="H7K WTR CANCER LIMIT ACTIVITY-HEAD"      
      ER27045             FORMAT=1.   LABEL="H5L WTR PSYCH PROBLEM-HEAD"              
      ER27046             FORMAT=3.   LABEL="H6L1 AGE FIRST HAD PSYCH PROB-HEAD"      
      ER27047             FORMAT=2.   LABEL="H6L2 TYPE OF PSYCH PROB MENTION 1-HD"    
      ER27048             FORMAT=2.   LABEL="H6L2 TYPE OF PSYCH PROB MENTION 2-HD"    
      ER27049             FORMAT=2.   LABEL="H6L2 TYPE OF PSYCH PROB MENTION 3-HD"    
      ER27050             FORMAT=1.   LABEL="H6L3 WTR PSYCH PROB GOT WORSE-HD"        
      ER27051             FORMAT=1.   LABEL="H7L WTR PSYCH PROB LIMIT ACTIVITY-HD"    
      ER27052             FORMAT=1.   LABEL="H5M WTR OTR CHRONIC CONDITION-HD"        
      ER27053             FORMAT=3.   LABEL="H6M1 AGE FIRST HAD CHRON COND-HEAD"      
      ER27054             FORMAT=1.   LABEL="H6M3 WTR CHRON COND GOT WORSE-HD"        
      ER27055             FORMAT=1.   LABEL="H7M WTR CHRON COND LIMIT ACTIVITY-HD"    
      ER27056             FORMAT=1.   LABEL="H8 WTR HOSPITALIZED IN 2004-HEAD"        
      ER27057             FORMAT=3.   LABEL="H8 # NIGHTS IN HOSPITAL-HEAD"            
      ER27058             FORMAT=2.   LABEL="H8 # WEEKS IN HOSPITAL-HEAD"             
      ER27059             FORMAT=1.   LABEL="H9A WTR PROBLEM BATHING-HEAD"            
      ER27060             FORMAT=1.   LABEL="H10A1 WTR SOMEONE HELPS BATHE-HD"        
      ER27061             FORMAT=1.   LABEL="H10A2 WTR NEED EQUIP TO BATHE-HD"        
      ER27062             FORMAT=1.   LABEL="H9B WTR PROBLEM DRESSING-HEAD"           
      ER27063             FORMAT=1.   LABEL="H10B1 WTR SOMEONE HELPS DRESS-HD"        
      ER27064             FORMAT=1.   LABEL="H10B2 WTR NEED EQUIP TO DRESS-HD"        
      ER27065             FORMAT=1.   LABEL="H9 WTR PROBLEM EATING-HEAD"              
      ER27066             FORMAT=1.   LABEL="H10C1 WTR SOMEONE HELPS EATNG-HD"        
      ER27067             FORMAT=1.   LABEL="H10C2 WTR NEED EQUIP TO EAT-HD"          
      ER27068             FORMAT=1.   LABEL="H9D WTR PROB GET IN/OUT BED/CHAIR-HD"    
      ER27069             FORMAT=1.   LABEL="H10D1 WTR SOMEONE HELPS BED/CHAIR-HD"    
      ER27070             FORMAT=1.   LABEL="H10D2 WTR NEED EQUIP FOR BED/CHAIR-HD"   
      ER27071             FORMAT=1.   LABEL="H9E WTR PROBLEM WALKING-HEAD"            
      ER27072             FORMAT=1.   LABEL="H10E1 WTR SOMEONE HELPS WALK-HD"         
      ER27073             FORMAT=1.   LABEL="H10E2 WTR NEED EQUIP TO WALK-HD"         
      ER27074             FORMAT=1.   LABEL="H9F WTR PROBLEM GETTING OUTSIDE-HD"      
      ER27075             FORMAT=1.   LABEL="H10F1 WTR SOMEONE HELPS GET OUT-HD"      
      ER27076             FORMAT=1.   LABEL="H10F2 WTR NEED EQUIP TO GO OUTSIDE-HD"   
      ER27077             FORMAT=1.   LABEL="H9G WTR PROBLEM USE TOILET-HD"           
      ER27078             FORMAT=1.   LABEL="H10G1 WTR SOMEONE HELPS TOILET-HD"       
      ER27079             FORMAT=1.   LABEL="H10G2 WTR NEED EQUIP TO USE TOILET-HD"   
      ER27080             FORMAT=1.   LABEL="H11A WTR DIFFICULT PREPARE MEALS"        
      ER27081             FORMAT=1.   LABEL="H11B HEALTH/PHYSICAL PROBLEM?"           
      ER27082             FORMAT=1.   LABEL="H11C WTR DIFFICULT SHOPPING"             
      ER27083             FORMAT=1.   LABEL="H11D HEALTH/PHYSICAL PROBLEM?"           
      ER27084             FORMAT=1.   LABEL="H11E WTR DIFFICULT MANAGE MONEY"         
      ER27085             FORMAT=1.   LABEL="H11F HEALTH/PHYSICAL PROBLEM?"           
      ER27086             FORMAT=1.   LABEL="H11G WTR TELEPHONE DIFFICULT"            
      ER27087             FORMAT=1.   LABEL="H11H HEALTH/PHYSICAL PROBLEM?"           
      ER27088             FORMAT=1.   LABEL="H11J WTR HEAVY HSWRK DIFFICULT"          
      ER27089             FORMAT=1.   LABEL="H11K HEALTH/PHYSICAL PROBLEM?"           
      ER27090             FORMAT=1.   LABEL="H11L WTR LIGHT HSWRK DIFFICULT"          
      ER27091             FORMAT=1.   LABEL="H11M HEALTH/PHYSICAL PROBLEM?"           
      ER27092             FORMAT=3.   LABEL="H12A FREQ OF HVY PHYSICAL ACTIVITY-HD"   
      ER27093             FORMAT=1.   LABEL="H12A TIME UNIT FOR HVY PHYS ACTIVITY-HD" 
      ER27094             FORMAT=3.   LABEL="H12B FREQ OF LITE PHYSICAL ACTIVITY-HD"  
      ER27095             FORMAT=1.   LABEL="H12B TIME UNIT FOR LITE PHYS ACTIVITY-HD"
      ER27096             FORMAT=3.   LABEL="H12C FREQ OF STRENGTH PHYS ACTIVITY-HD"  
      ER27097             FORMAT=1.   LABEL="H12C TIME UNIT STRNGTH PHYS ACTVTY-HD"   
      ER27098             FORMAT=1.   LABEL="H13 WTR SMOKE CIGARETTES-HEAD"           
      ER27099             FORMAT=3.   LABEL="H14 # CIGARETTES PER DAY-HEAD"           
      ER27100             FORMAT=2.   LABEL="H15 AGE WHEN FIRST SMOKED-HEAD"          
      ER27101             FORMAT=1.   LABEL="H16 WTR EVER SMOKED CIGARETTES-HEAD"     
      ER27102             FORMAT=3.   LABEL="H17 # CIGARETTES PER DAY-HEAD"           
      ER27103             FORMAT=2.   LABEL="H18 AGE LAST SMOKED REGULARLY-HEAD"      
      ER27104             FORMAT=2.   LABEL="H19 AGE FIRST SMOKED REGULARLY-HEAD"     
      ER27105             FORMAT=1.   LABEL="H20 WTR DRINK ALCOHOL-HEAD"              
      ER27106             FORMAT=1.   LABEL="H21A HOW OFTEN HAVE DRINKS-HD"           
      ER27107             FORMAT=2.   LABEL="H21B # ALCOHOLIC DRINKS PER DAY-HD"      
      ER27108             FORMAT=3.   LABEL="H21C # DAYS HAD 4-5 DRINKS-HEAD"         
      ER27109             FORMAT=3.   LABEL="H22 WEIGHT"                              
      ER27110             FORMAT=1.   LABEL="H23 HEIGHT-FEET"                         
      ER27111             FORMAT=2.   LABEL="H23 HEIGHT-INCHES"                       
      ER27112             FORMAT=1.   LABEL="H24 WTR WIFE IN FU NOW"                  
      ER27113             FORMAT=1.   LABEL="H25 HEALTH STATUS-WIFE"                  
      ER27114             FORMAT=1.   LABEL="H25A WTR HLTH BETTER/WORSE-WIFE"         
      ER27115             FORMAT=1.   LABEL="H25B WTR  HEALTH BETTER-WIFE"            
      ER27116             FORMAT=1.   LABEL="H25C WTR HEALTH WORSE-WIFE"              
      ER27117             FORMAT=1.   LABEL="H25D HEALTH STATUS, BIRTH TO AGE 16-WF"  
      ER27118             FORMAT=1.   LABEL="H26 WTR TYPE/AMT WORK LIMITED-WIFE"      
      ER27119             FORMAT=1.   LABEL="H27 WTR UNABLE TO DO SOME TYPES WORK-WF" 
      ER27120             FORMAT=1.   LABEL="H28 WTR LIMIT AMT WORK CAN DO-WIFE"      
      ER27121             FORMAT=1.   LABEL="H29A WTR HAD STROKE-WIFE"                
      ER27122             FORMAT=3.   LABEL="H30A1 AGE AT FIRST STROKE-WIFE"          
      ER27123             FORMAT=1.   LABEL="H30A2 WTR SECOND STROKE-WIFE"            
      ER27124             FORMAT=1.   LABEL="H31A WTR STROKE LIMIT DAILY ACTIVITY-WF" 
      ER27125             FORMAT=1.   LABEL="H29B WTR HEART ATTACK-WIFE"              
      ER27126             FORMAT=3.   LABEL="H30B1 AGE AT FIRST HEART ATTACK-WF"      
      ER27127             FORMAT=1.   LABEL="H30B2 WTR SECOND HEART ATTACK-WF"        
      ER27128             FORMAT=1.   LABEL="H31B WTR HRT ATTACK LIMIT ACTIVITY-WF"   
      ER27129             FORMAT=1.   LABEL="H29C WTR HEART DISEASE-WIFE"             
      ER27130             FORMAT=3.   LABEL="H30C1 AGE FIRST HAD HEART DISEASE-WF"    
      ER27131             FORMAT=1.   LABEL="H30C2 WTR HRT DISEASE GOT WORSE-WF"      
      ER27132             FORMAT=1.   LABEL="H31C WTR HRT DISEASE LIMIT ACTIVITY-WF"  
      ER27133             FORMAT=1.   LABEL="H29D WTR HYPERTENSION-WIFE"              
      ER27134             FORMAT=3.   LABEL="H30D1 AGE FIRST HAD HYPERTENSION-WF"     
      ER27135             FORMAT=1.   LABEL="H30D2 WTR HYPERTENSION GOT WORSE-WF"     
      ER27136             FORMAT=1.   LABEL="H31D WTR HYPERTENSION LIMIT ACTIVITY-WF" 
      ER27137             FORMAT=1.   LABEL="H29E WTR ASTHMA-WIFE"                    
      ER27138             FORMAT=3.   LABEL="H30E1 AGE FIRST HAD ASTHMA-WIFE"         
      ER27139             FORMAT=1.   LABEL="H30E2 WTR ASTHMA GOT WORSE-WIFE"         
      ER27140             FORMAT=1.   LABEL="H31E WTR ASTHMA LIMIT DAILY ACTIVITY-WF" 
      ER27141             FORMAT=1.   LABEL="H29F WTR LUNG DISEASE-WIFE"              
      ER27142             FORMAT=3.   LABEL="H30F1 AGE FIRST HAD LUNG DISEASE-WF"     
      ER27143             FORMAT=1.   LABEL="H30F2 WTR LUNG DISEASE GOT WORSE-WF"     
      ER27144             FORMAT=1.   LABEL="H31F WTR LUNG DISEASE LIMIT ACTIVITY-WF" 
      ER27145             FORMAT=1.   LABEL="H29G WTR DIABETES-WIFE"                  
      ER27146             FORMAT=3.   LABEL="H30G1 AGE FIRST HAD DIABETES-WIFE"       
      ER27147             FORMAT=1.   LABEL="H30G2 WTR DIABETES GOT WORSE-WIFE"       
      ER27148             FORMAT=1.   LABEL="H31G WTR DIABETES LIMIT ACTIVITY-WF"     
      ER27149             FORMAT=1.   LABEL="H29H WTR ARTHRITIS-WIFE"                 
      ER27150             FORMAT=3.   LABEL="H30H1 AGE FIRST HAD ARTHRITIS-WIFE"      
      ER27151             FORMAT=1.   LABEL="H30H2 WTR ARTHRITIS GOT WORSE-WIFE"      
      ER27152             FORMAT=1.   LABEL="H31H WTR ARTHRITIS LIMIT ACTIVITY-WF"    
      ER27153             FORMAT=1.   LABEL="H29I WTR MENTAL LOSS-WIFE"               
      ER27154             FORMAT=3.   LABEL="H30I1 AGE FIRST HAD MEMORY LOSS-WF"      
      ER27155             FORMAT=1.   LABEL="H30I2 WTR MEMORY LOSS GOT WORSE-WF"      
      ER27156             FORMAT=1.   LABEL="H31I WTR MEMORY LOSS LIMIT ACTIVITY-WF"  
      ER27157             FORMAT=1.   LABEL="H29J WTR LEARNING DISORDER-WIFE"         
      ER27158             FORMAT=3.   LABEL="H30J1 AGE FIRST HAD LRNG DISORDER-WF"    
      ER27159             FORMAT=1.   LABEL="H30J2 WTR LRNG DISORDER GOT WORSE-WF"    
      ER27160             FORMAT=1.   LABEL="H31J WTR LRNG DISORDR LIMIT ACTIVITY-WF" 
      ER27161             FORMAT=1.   LABEL="H29K WTR CANCER-WIFE"                    
      ER27162             FORMAT=3.   LABEL="H30K1 AGE FIRST HAD CANCER-WIFE"         
      ER27163             FORMAT=1.   LABEL="H30K2 WTR CANCER GOT WORSE-WIFE"         
      ER27164             FORMAT=1.   LABEL="H30K3 WTR TREATING, RMSSN, OR CURED-WF"  
      ER27165             FORMAT=2.   LABEL="H30K4 TYPE OF CANCER MENTION 1-WIFE"     
      ER27166             FORMAT=2.   LABEL="H30K4 TYPE OF CANCER MENTION 2-WIFE"     
      ER27167             FORMAT=1.   LABEL="H31K WTR CANCER LIMIT ACTIVITY-WIFE"     
      ER27168             FORMAT=1.   LABEL="H29L WTR PSYCH PROBLEM-WIFE"             
      ER27169             FORMAT=3.   LABEL="H30L1 AGE FIRST HAD PSYCH PROB-WIFE"     
      ER27170             FORMAT=2.   LABEL="H30L2 TYPE OF PSYCH PROB MENTION 1-WF"   
      ER27171             FORMAT=2.   LABEL="H30L2 TYPE OF PSYCH PROB MENTION 2-WF"   
      ER27172             FORMAT=2.   LABEL="H30L2 TYPE OF PSYCH PROB MENTION 3-WF"   
      ER27173             FORMAT=1.   LABEL="H30L3 WTR PSYCH PROB GOT WORSE-WF"       
      ER27174             FORMAT=1.   LABEL="H31L WTR PSYCH PROB LIMIT ACTIVITY-WF"   
      ER27175             FORMAT=1.   LABEL="H29M WTR OTR CHRONIC CONDITION-WF"       
      ER27176             FORMAT=3.   LABEL="H30M1 AGE FIRST HAD CHRON COND-WIFE"     
      ER27177             FORMAT=1.   LABEL="H30M3 WTR CHRON COND GOT WORSE-WF"       
      ER27178             FORMAT=1.   LABEL="H31M WTR CHRON COND LIMIT ACTIVITY-WF"   
      ER27179             FORMAT=1.   LABEL="H32 WTR HOSPITALIZED IN 2004-WIFE"       
      ER27180             FORMAT=3.   LABEL="H32A # NIGHTS HOSPITALIZED-WIFE"         
      ER27181             FORMAT=2.   LABEL="H32A # WEEKS HOSPITALIZED-WIFE"          
      ER27182             FORMAT=1.   LABEL="H33A WTR PROBLEM BATHING-WIFE"           
      ER27183             FORMAT=1.   LABEL="H34A1 WTR SOMEONE HELPS BATHE-WF"        
      ER27184             FORMAT=1.   LABEL="H34A2 WTR NEED EQUIP TO BATHE-WF"        
      ER27185             FORMAT=1.   LABEL="H33B WTR PROBLEM DRESSING-WIFE"          
      ER27186             FORMAT=1.   LABEL="H34B1 WTR SOMEONE HELPS DRESS-WF"        
      ER27187             FORMAT=1.   LABEL="H34B2 WTR NEED EQUIP TO DRESS-WF"        
      ER27188             FORMAT=1.   LABEL="H33 WTR PROBLEM EATING-WIFE"             
      ER27189             FORMAT=1.   LABEL="H34C1 WTR SOMEONE HELPS EATNG-WF"        
      ER27190             FORMAT=1.   LABEL="H34C2 WTR NEED EQUIP TO EAT-WF"          
      ER27191             FORMAT=1.   LABEL="H33D WTR PROB GET IN/OUT BED/CHAIR-WF"   
      ER27192             FORMAT=1.   LABEL="H34D1 WTR SOMEONE HELPS BED/CHAIR-WF"    
      ER27193             FORMAT=1.   LABEL="H34D2 WTR NEED EQUIP FOR BED/CHAIR-WF"   
      ER27194             FORMAT=1.   LABEL="H33E WTR PROBLEM WALKING-WIFE"           
      ER27195             FORMAT=1.   LABEL="H34E1 WTR SOMEONE HELPS WALK-WF"         
      ER27196             FORMAT=1.   LABEL="H34E2 WTR NEED EQUIP TO WALK-WF"         
      ER27197             FORMAT=1.   LABEL="H33F WTR PROBLEM GETTING OUTSIDE-WF"     
      ER27198             FORMAT=1.   LABEL="H34F1 WTR SOMEONE HELPS GET OUT-WF"      
      ER27199             FORMAT=1.   LABEL="H34F2 WTR NEED EQUIP TO GO OUTSIDE-WF"   
      ER27200             FORMAT=1.   LABEL="H33G WTR PROBLEM USE TOILET-WF"          
      ER27201             FORMAT=1.   LABEL="H34G1 WTR SOMEONE HELPS TOILET-WF"       
      ER27202             FORMAT=1.   LABEL="H34G2 WTR NEED EQUIP TO USE TOILET-WF"   
      ER27203             FORMAT=1.   LABEL="H35A WTR DIFFICULT PREPARE MEALS"        
      ER27204             FORMAT=1.   LABEL="H35B HEALTH/PHYSICAL PROBLEM?"           
      ER27205             FORMAT=1.   LABEL="H35C WTR DIFFICULT SHOPPING"             
      ER27206             FORMAT=1.   LABEL="H35D HEALTH/PHYSICAL PROBLEM?"           
      ER27207             FORMAT=1.   LABEL="H35E WTR DIFFICULT MANAGE MONEY"         
      ER27208             FORMAT=1.   LABEL="H35F HEALTH/PHYSICAL PROBLEM?"           
      ER27209             FORMAT=1.   LABEL="H35G WTR TELEPHONE DIFFICULT"            
      ER27210             FORMAT=1.   LABEL="H35H HEALTH/PHYSICAL PROBLEM?"           
      ER27211             FORMAT=1.   LABEL="H35J WTR HEAVY HSWRK DIFFICULT"          
      ER27212             FORMAT=1.   LABEL="H35K HEALTH/PHYSICAL PROBLEM?"           
      ER27213             FORMAT=1.   LABEL="H35L WTR LIGHT HSWRK DIFFICULT"          
      ER27214             FORMAT=1.   LABEL="H35M HEALTH/PHYSCIAL PROBLEM?"           
      ER27215             FORMAT=3.   LABEL="H36A FREQ OF HVY PHYSICAL ACTIVITY-WF"   
      ER27216             FORMAT=1.   LABEL="H36A TIME UNIT FOR HVY PHYS ACTIVITY-WF" 
      ER27217             FORMAT=3.   LABEL="H36B FREQ OF LITE PHYSICAL ACTIVITY-WF"  
      ER27218             FORMAT=1.   LABEL="H36B TIME UNIT FOR LITE PHYS ACTIVITY-WF"
      ER27219             FORMAT=3.   LABEL="H36C FREQ OF STRENGTH PHYS ACTIVITY-WF"  
      ER27220             FORMAT=1.   LABEL="H36C TIME UNIT STRNGTH PHYS ACTVTY-WF"   
      ER27221             FORMAT=1.   LABEL="H37 WTR SMOKE CIGARETTES-WIFE"           
      ER27222             FORMAT=3.   LABEL="H38 # CIGARETTES PER DAY-WIFE"           
      ER27223             FORMAT=2.   LABEL="H39 AGE WHEN FIRST SMOKED-WIFE"          
      ER27224             FORMAT=1.   LABEL="H40 WTR EVER SMOKED CIGARETTES-WIFE"     
      ER27225             FORMAT=3.   LABEL="H41 # CIGARETTES PER DAY-WIFE"           
      ER27226             FORMAT=2.   LABEL="H42 AGE LAST SMOKED REGULARLY-WIFE"      
      ER27227             FORMAT=2.   LABEL="H43 AGE FIRST SMOKED REGULARLY-WIFE"     
      ER27228             FORMAT=1.   LABEL="H44 WTR DRINK ALCOHOL-WIFE"              
      ER27229             FORMAT=1.   LABEL="H45A HOW OFTEN HAVE DRINKS-WF"           
      ER27230             FORMAT=2.   LABEL="H45B # ALCOHOLIC DRINKS PER DAY-WF"      
      ER27231             FORMAT=3.   LABEL="H45C # DAYS HAD 4-5 DRINKS-WIFE"         
      ER27232             FORMAT=3.   LABEL="H46 WEIGHT"                              
      ER27233             FORMAT=1.   LABEL="H47 HEIGHT-FEET"                         
      ER27234             FORMAT=2.   LABEL="H47 HEIGHT-INCHES"                       
      ER27235             FORMAT=1.   LABEL="H48 CKPT: WTR OTHERS IN FU"              
      ER27236             FORMAT=1.   LABEL="H49 WTR OTHERS IN FU IN POOR HEALTH"     
      ER27237             FORMAT=1.   LABEL="H60 WTR FU MEMBER W/HLTH INS LAST 2 YRS" 
      ER27238             FORMAT=6.   LABEL="H63 TOTAL PAID FOR HLTH INS LAST 2 YRS"  
      ER27239             FORMAT=6.   LABEL="H64 TOTAL HOSPITAL/NURSNG HOME EXPENSES" 
      ER27240             FORMAT=1.   LABEL="H65 WTR TOTAL EXPENSE GE 10,000"         
      ER27241             FORMAT=1.   LABEL="H66 WTR TOTAL EXPENSE GE 20,000"         
      ER27242             FORMAT=1.   LABEL="H67 WTR TOTAL EXPENSE GE 50,000"         
      ER27243             FORMAT=1.   LABEL="H68 WTR TOTAL EXPENSE GE 5,000"          
      ER27244             FORMAT=1.   LABEL="H69 WTR TOTAL EXPENSE GE 500"            
      ER27245             FORMAT=6.   LABEL="H70 TOT DR/OUTPT SURGRY/DENTAL EXPENSES" 
      ER27246             FORMAT=1.   LABEL="H71 WTR TOTAL EXPENSE GE 1,000"          
      ER27247             FORMAT=1.   LABEL="H72 WTR TOTAL EXPENSE GE 5,000"          
      ER27248             FORMAT=1.   LABEL="H73 WTR TOTAL EXPENSE GE 20,000"         
      ER27249             FORMAT=1.   LABEL="H74 WTR TOTAL EXPENSE GE 500"            
      ER27250             FORMAT=1.   LABEL="H75 WTR TOTAL EXPENSE GE 200"            
      ER27251             FORMAT=6.   LABEL="H76 TOTAL PRESCRIPTN/OTR SVCS EXPENSES"  
      ER27252             FORMAT=1.   LABEL="H77 WTR TOTAL EXPENSE GE 5,000"          
      ER27253             FORMAT=1.   LABEL="H78 WTR TOTAL EXPENSE GE 10,000"         
      ER27254             FORMAT=1.   LABEL="H79 WTR TOTAL EXPENSE GE 20,000"         
      ER27255             FORMAT=1.   LABEL="H80 WTR TOTAL EXPENSE GE 1,000"          
      ER27256             FORMAT=1.   LABEL="H81 WTR TOTAL EXPENSE GE 500"            
      ER27257             FORMAT=8.   LABEL="H82 TOTAL COST ALL MEDICAL CARE"         
      ER27258             FORMAT=1.   LABEL="H83 WTR TOTAL COST GE 25,000"            
      ER27259             FORMAT=1.   LABEL="H84 WTR TOTAL COST GE 100,000"           
      ER27260             FORMAT=1.   LABEL="H85 WTR TOTAL COST GE 500,000"           
      ER27261             FORMAT=1.   LABEL="H86 WTR TOTAL COST GE 5,000"             
      ER27262             FORMAT=1.   LABEL="H87 WTR TOTAL COST GE 1,000"             
      ER27263             FORMAT=1.   LABEL="K1 CKPT: WTR NEW WIFE IN FU"             
      ER27264             FORMAT=2.   LABEL="K2 STATE WHERE FATHER BORN-WF"           
      ER27265             FORMAT=2.   LABEL="K3 STATE FATHER GREW UP-WF"              
      ER27266             FORMAT=1.   LABEL="K4 WTR FATHER EDUCATED IN US-WF"         
      ER27267             FORMAT=2.   LABEL="K5 EDUCATION OF FATHER IN US-WF"         
      ER27268             FORMAT=1.   LABEL="K6 WTR FATHER READ/WRITE-WF"             
      ER27269             FORMAT=1.   LABEL="K7 CKPT:  WTR FATHER ED ALL IN US-WF"    
      ER27270             FORMAT=2.   LABEL="K8 YRS FOREIGN EDUCATION OF FATHR-WF"    
      ER27271             FORMAT=1.   LABEL="K9 FOREIGN DEGREES OF FATHER-WF"         
      ER27272             FORMAT=3.   LABEL="K10-10A OCCUPATION OF FATHER-WF"         
      ER27273             FORMAT=3.   LABEL="K11 INDUSTRY OF FATHER-WF"               
      ER27274             FORMAT=2.   LABEL="K12 STATE WHERE MOTHER BORN-WF"          
      ER27275             FORMAT=2.   LABEL="K13 STATE MOTHER GREW UP-WF"             
      ER27276             FORMAT=1.   LABEL="K14 WTR MOTHER EDUCATED IN US-WF"        
      ER27277             FORMAT=2.   LABEL="K15 EDUCATION OF MOTHER IN US-WF"        
      ER27278             FORMAT=1.   LABEL="K16 WTR MOTHER READ/WRITE-WF"            
      ER27279             FORMAT=1.   LABEL="K17 CKPT:  WTR MOTHER ED ALL IN US-WF"   
      ER27280             FORMAT=2.   LABEL="K18 YRS FOREIGN EDUCATION OF MOTHR-WF"   
      ER27281             FORMAT=1.   LABEL="K19 FOREIGN DEGREES OF MOTHER-WF"        
      ER27282             FORMAT=3.   LABEL="K20-20A OCCUPATION OF MOTHER-WF"         
      ER27283             FORMAT=3.   LABEL="K21 INDUSTRY OF MOTHER-WF"               
      ER27284             FORMAT=1.   LABEL="K22 WHETHER BROTHERS-WF"                 
      ER27285             FORMAT=2.   LABEL="K23 # BROTHERS-WIFE"                     
      ER27286             FORMAT=1.   LABEL="K24 WTR ONLY BRO STILL ALIVE-WF"         
      ER27287             FORMAT=1.   LABEL="K25 WTR ONLY BRO OLDER THAN WIFE"        
      ER27288             FORMAT=2.   LABEL="K26 # BROTHERS STILL ALIVE-WF"           
      ER27289             FORMAT=1.   LABEL="K27 WTR ANY BRO OLDER THAN WIFE"         
      ER27290             FORMAT=1.   LABEL="K28 WHETHER SISTERS-WF"                  
      ER27291             FORMAT=2.   LABEL="K29 # SISTERS-WIFE"                      
      ER27292             FORMAT=1.   LABEL="K30 WTR ONLY SIS STILL ALIVE-WF"         
      ER27293             FORMAT=1.   LABEL="K31 WTR ONLY SIS OLDER THAN WIFE"        
      ER27294             FORMAT=2.   LABEL="K32 # SISTERS STILL ALIVE-WF"            
      ER27295             FORMAT=1.   LABEL="K33 WTR ANY SIS OLDER THAN WIFE"         
      ER27296             FORMAT=1.   LABEL="K33A SPANISH DESCENT-WIFE"               
      ER27297             FORMAT=1.   LABEL="K34 RACE OF WIFE-MENTION 1"              
      ER27298             FORMAT=1.   LABEL="K34 RACE OF WIFE-MENTION 2"              
      ER27299             FORMAT=1.   LABEL="K34 RACE OF WIFE-MENTION 3"              
      ER27300             FORMAT=1.   LABEL="K34 RACE OF WIFE-MENTION 4"              
      ER27301             FORMAT=1.   LABEL="K34A ETHNIC GROUP-WF"                    
      ER27302             FORMAT=2.   LABEL="K34A NATIONALITY MENTION 1-WF"           
      ER27303             FORMAT=2.   LABEL="K34A NATIONALITY MENTION 2-WF"           
      ER27304             FORMAT=1.   LABEL="K35 WTR EVER IN MILITARY-WF"             
      ER27305             FORMAT=1.   LABEL="K36 WTR WIFE EDUCATED IN US"             
      ER27306             FORMAT=1.   LABEL="K37 WTR GRADUATED HS-WF"                 
      ER27307             FORMAT=2.   LABEL="K38 MO GRADUATED HS-WF"                  
      ER27308             FORMAT=4.   LABEL="K38 YR GRADUATED HS-WF"                  
      ER27309             FORMAT=2.   LABEL="K39 GRADE LEVEL IF GED-WF"               
      ER27310             FORMAT=2.   LABEL="K40 MO LAST IN SCHOOL IF GED-WF"         
      ER27311             FORMAT=4.   LABEL="K40 YR LAST IN SCHOOL IF GED-WF"         
      ER27312             FORMAT=2.   LABEL="K41 MO RECEIVED GED-WF"                  
      ER27313             FORMAT=4.   LABEL="K41 YR RECEIVED GED-WF"                  
      ER27314             FORMAT=2.   LABEL="K42 GRADE OF SCHOOL FINISHED-W"          
      ER27315             FORMAT=2.   LABEL="K43 MO LAST IN SCHOOL-WF"                
      ER27316             FORMAT=4.   LABEL="K43 YR LAST IN SCHOOL-WF"                
      ER27317             FORMAT=1.   LABEL="K44 WTR ATTENDED COLLEGE-WF"             
      ER27318             FORMAT=2.   LABEL="K45 MO LAST ATTENDED COLLEGE-WF"         
      ER27319             FORMAT=4.   LABEL="K45 YR LAST ATTENDED COLLEGE-WF"         
      ER27320             FORMAT=1.   LABEL="K46 HGHST YR COLL COMPLETED-WF"          
      ER27321             FORMAT=1.   LABEL="K47 WTR RECD COLLEGE DEGREE-WF"          
      ER27322             FORMAT=2.   LABEL="K48 HGHST COLLEGE DEGREE RECD-WF"        
      ER27323             FORMAT=2.   LABEL="K51 MO RECD COLLEGE DEGREE-WF"           
      ER27324             FORMAT=4.   LABEL="K51 YR RECD COLLEGE DEGREE-WF"           
      ER27325             FORMAT=2.   LABEL="K53 YRS FOREIGN EDUCATION-WF"            
      ER27326             FORMAT=1.   LABEL="K54 FOREIGN DEGREES-WIFE"                
      ER27327             FORMAT=1.   LABEL="K55 WTR RECD OTR DEG/CERT-WF"            
      ER27328             FORMAT=1.   LABEL="K56 TYPE 1ST OTR DEG/CERT-WF"            
      ER27329             FORMAT=2.   LABEL="K57 FIELD 1ST OTR DEG/CERT-WF"           
      ER27330             FORMAT=2.   LABEL="K58 INST/ORG OF 1ST OTR DEG/CERT-WF"     
      ER27331             FORMAT=2.   LABEL="K59 MO RECD 1ST OTR DEG/CERT-WF"         
      ER27332             FORMAT=4.   LABEL="K59 YR RECD 1ST OTR DEG/CERT-WF"         
      ER27333             FORMAT=1.   LABEL="K60 WTR 2ND DEGREE/CERT-WF"              
      ER27334             FORMAT=1.   LABEL="K56 TYPE 2ND OTR DEG/CERT-WF"            
      ER27335             FORMAT=2.   LABEL="K57 FIELD 2ND OTR DEG/CERT-WF"           
      ER27336             FORMAT=2.   LABEL="K58 INST/ORG OF 2ND OTR DEG/CERT-WF"     
      ER27337             FORMAT=2.   LABEL="K59 MO RECD 2ND OTR DEG/CERT-WF"         
      ER27338             FORMAT=4.   LABEL="K59 YR RECD 2ND OTR DEG/CERT-WF"         
      ER27339             FORMAT=1.   LABEL="K60 WTR 3RD DEGREE/CERT-WF"              
      ER27340             FORMAT=1.   LABEL="K56 TYPE 3RD OTR DEG/CERT-WF"            
      ER27341             FORMAT=2.   LABEL="K57 FIELD 3RD OTR DEG/CERT-WF"           
      ER27342             FORMAT=2.   LABEL="K58 INST/ORG OF 3RD OTR DEG/CERT-WF"     
      ER27343             FORMAT=2.   LABEL="K59 MO RECD 3RD OTR DEG/CERT-WF"         
      ER27344             FORMAT=4.   LABEL="K59 YR RECD 3RD OTR DEG/CERT-WF"         
      ER27345             FORMAT=1.   LABEL="K60 WTR 4TH DEGREE/CERT-WF"              
      ER27346             FORMAT=2.   LABEL="K61 RELIGIOUS PREFERENCE-WF"             
      ER27347             FORMAT=2.   LABEL="K62 RELIG DENOMINATION-WF"               
      ER27348             FORMAT=2.   LABEL="K63 #YRS WRKD SINCE 18-WF"               
      ER27349             FORMAT=2.   LABEL="K64 #YR WRKED FULLTIME-WF"               
      ER27350             FORMAT=3.   LABEL="K65-65A OCCUPATION 1ST FULL TIME JOB-WF" 
      ER27351             FORMAT=3.   LABEL="K66 INDUSTRY 1ST FULL-TIME JOB-WF"       
      ER27352             FORMAT=1.   LABEL="L1 CKPT: WTR NEW HEAD IN FU"             
      ER27353             FORMAT=2.   LABEL="L2 STATE WHERE FATHER BORN-HD"           
      ER27354             FORMAT=2.   LABEL="L3 STATE FATHER GREW UP-HD"              
      ER27355             FORMAT=1.   LABEL="L4 WTR FATHER EDUCATED IN US-HD"         
      ER27356             FORMAT=2.   LABEL="L5 EDUCATION OF FATHER IN US-HD"         
      ER27357             FORMAT=1.   LABEL="L6 WTR FATHER READ/WRITE-HD"             
      ER27358             FORMAT=1.   LABEL="L7 CKPT:  WTR FATHER ED ALL IN US-HD"    
      ER27359             FORMAT=2.   LABEL="L8 YRS FOREIGN EDUCATION OF FATHR-HD"    
      ER27360             FORMAT=1.   LABEL="L9 FOREIGN DEGREES OF FATHER-HD"         
      ER27361             FORMAT=3.   LABEL="L10-10A OCCUPATION OF FATHER-HD"         
      ER27362             FORMAT=3.   LABEL="L11 INDUSTRY OF FATHER-HD"               
      ER27363             FORMAT=2.   LABEL="L12 STATE WHERE MOTHER BORN-HD"          
      ER27364             FORMAT=2.   LABEL="L13 STATE MOTHER GREW UP-HD"             
      ER27365             FORMAT=1.   LABEL="L14 WTR MOTHER EDUCATED IN US-H"         
      ER27366             FORMAT=2.   LABEL="L15 EDUCATION OF MOTHER IN US-HD"        
      ER27367             FORMAT=1.   LABEL="L16 WTR MOTHER READ/WRITE-HD"            
      ER27368             FORMAT=1.   LABEL="L17 CKPT:  WTR MOTHER ED ALL IN US-HD"   
      ER27369             FORMAT=2.   LABEL="L18 YRS FOREIGN EDUCATION OF MOTHR-HD"   
      ER27370             FORMAT=1.   LABEL="L19 FOREIGN DEGREES OF MOTHER-HD"        
      ER27371             FORMAT=3.   LABEL="L20-20A OCCUPATION OF MOTHER-HD"         
      ER27372             FORMAT=3.   LABEL="L21 INDUSTRY OF MOTHER-HD"               
      ER27373             FORMAT=1.   LABEL="L22 WHETHER BROTHERS-HD"                 
      ER27374             FORMAT=2.   LABEL="L23 # BROTHERS-HEAD"                     
      ER27375             FORMAT=1.   LABEL="L24 WTR ONLY BRO STILL ALIVE-HD"         
      ER27376             FORMAT=1.   LABEL="L25 WTR ONLY BRO OLDER THAN HEAD"        
      ER27377             FORMAT=2.   LABEL="L26 # BROTHERS STILL ALIVE-HD"           
      ER27378             FORMAT=1.   LABEL="L27 WTR ANY BRO OLDER THAN HEAD"         
      ER27379             FORMAT=1.   LABEL="L28 WHETHER SISTERS-HD"                  
      ER27380             FORMAT=2.   LABEL="L29 # SISTERS-HEAD"                      
      ER27381             FORMAT=1.   LABEL="L30 WTR ONLY SIS STILL ALIVE-HD"         
      ER27382             FORMAT=1.   LABEL="L31 WTR ONLY SIS OLDER THAN HEAD"        
      ER27383             FORMAT=2.   LABEL="L32 # SISTERS STILL ALIVE-HD"            
      ER27384             FORMAT=1.   LABEL="L33 WTR ANY SIS OLDER THAN HEAD"         
      ER27385             FORMAT=1.   LABEL="L34 GREW UP FARM OR?-HD"                 
      ER27386             FORMAT=2.   LABEL="L34 STATE WHERE HEAD GREW UP"            
      ER27387             FORMAT=1.   LABEL="L35 WTR EVER LIVED IN OTR STATE-HD"      
      ER27388             FORMAT=1.   LABEL="L36 WTR EVER MOVED FOR JOB-HD"           
      ER27389             FORMAT=1.   LABEL="L37 WTR DID NOT MOVE FOR JOB-HD"         
      ER27390             FORMAT=1.   LABEL="L38 PARENTS POOR OR?-HD"                 
      ER27391             FORMAT=1.   LABEL="L39 WTR LIVED W/BOTH PARENTS-HD"         
      ER27392             FORMAT=1.   LABEL="L39A SPANISH DESCENT-HEAD"               
      ER27393             FORMAT=1.   LABEL="L40 RACE OF HEAD-MENTION 1"              
      ER27394             FORMAT=1.   LABEL="L40 RACE OF HEAD-MENTION 2"              
      ER27395             FORMAT=1.   LABEL="L40 RACE OF HEAD-MENTION 3"              
      ER27396             FORMAT=1.   LABEL="L40 RACE OF HEAD-MENTION 4"              
      ER27397             FORMAT=1.   LABEL="L41 ETHNIC GROUP-HD"                     
      ER27398             FORMAT=2.   LABEL="L41 NATIONALITY MENTION 1-HD"            
      ER27399             FORMAT=2.   LABEL="L41 NATIONALITY MENTION 2-HD"            
      ER27400             FORMAT=1.   LABEL="L42 WTR EVER IN MILITARY-HD"             
      ER27401             FORMAT=1.   LABEL="L43 WTR HEAD EDUCATED IN US"             
      ER27402             FORMAT=1.   LABEL="L44 WTR GRADUATED HS-HD"                 
      ER27403             FORMAT=2.   LABEL="L45 MO GRADUATED HS-HD"                  
      ER27404             FORMAT=4.   LABEL="L45 YR GRADUATED HS-HD"                  
      ER27405             FORMAT=2.   LABEL="L46 GRADE LEVEL IF GED-HD"               
      ER27406             FORMAT=2.   LABEL="L47 MO LAST IN SCHOOL IF GED-HD"         
      ER27407             FORMAT=4.   LABEL="L47 YR LAST IN SCHOOL IF GED-HD"         
      ER27408             FORMAT=2.   LABEL="L48 MO RECEIVED GED-HD"                  
      ER27409             FORMAT=4.   LABEL="L48 YR RECEIVED GED-HD"                  
      ER27410             FORMAT=2.   LABEL="L49 GRADE OF SCHOOL FINISHED-HD"         
      ER27411             FORMAT=2.   LABEL="L50 MO LAST IN SCHOOL-HD"                
      ER27412             FORMAT=4.   LABEL="L50 YR LAST IN SCHOOL-HD"                
      ER27413             FORMAT=1.   LABEL="L51 WTR ATTENDED COLLEGE-HD"             
      ER27414             FORMAT=2.   LABEL="L52 MO LAST ATTENDED COLLEGE-HD"         
      ER27415             FORMAT=4.   LABEL="L52 YR LAST ATTENDED COLLEGE-HD"         
      ER27416             FORMAT=1.   LABEL="L53 HGHST YR COLL COMPLETED-HD"          
      ER27417             FORMAT=1.   LABEL="L54 WTR RECD COLLEGE DEGREE-HD"          
      ER27418             FORMAT=2.   LABEL="L55 HGHST COLLEGE DEGREE RECD-HD"        
      ER27419             FORMAT=2.   LABEL="L58 MO RECD COLLEGE DEGREE-HD"           
      ER27420             FORMAT=4.   LABEL="L58 YR RECD COLLEGE DEGREE-HD"           
      ER27421             FORMAT=2.   LABEL="L60 YRS FOREIGN EDUCATION-HD"            
      ER27422             FORMAT=1.   LABEL="L61 FOREIGN DEGREES-HEAD"                
      ER27423             FORMAT=1.   LABEL="L62 WTR REC OTR DEG/CERT-HD"             
      ER27424             FORMAT=1.   LABEL="L63 TYPE 1ST OTR DEG/CERT-HD"            
      ER27425             FORMAT=2.   LABEL="L64 FIELD 1ST OTR DEG/CERT-HD"           
      ER27426             FORMAT=2.   LABEL="L65 INST/ORG OF 1ST OTR DEG/CERT-HD"     
      ER27427             FORMAT=2.   LABEL="L66 MO RECD 1ST OTR DEG/CERT-HD"         
      ER27428             FORMAT=4.   LABEL="L66 YR RECD 1ST OTR DEG/CERT-HD"         
      ER27429             FORMAT=1.   LABEL="L67 WTR 2ND DEGREE/CERT-HD"              
      ER27430             FORMAT=1.   LABEL="L63 TYPE 2ND OTR DEG/CERT-HD"            
      ER27431             FORMAT=2.   LABEL="L64 FIELD 2ND OTR DEG/CERT-HD"           
      ER27432             FORMAT=2.   LABEL="L65 INST/ORG OF 2ND OTR DEG/CERT-HD"     
      ER27433             FORMAT=2.   LABEL="L66 MO RECD 2ND OTR DEG/CERT-HD"         
      ER27434             FORMAT=4.   LABEL="L66 YR RECD 2ND OTR DEG/CERT-HD"         
      ER27435             FORMAT=1.   LABEL="L67 WTR 3RD DEGREE/CERT-HD"              
      ER27436             FORMAT=1.   LABEL="L63 TYPE 3RD OTR DEG/CERT-HD"            
      ER27437             FORMAT=2.   LABEL="L64 FIELD 3RD OTR DEG/CERT-HD"           
      ER27438             FORMAT=2.   LABEL="L65 INST/ORG OF 3RD OTR DEG/CERT-HD"     
      ER27439             FORMAT=2.   LABEL="L66 MO RECD 3RD OTR DEG/CERT-HD"         
      ER27440             FORMAT=4.   LABEL="L66 YR RECD 3RD OTR DEG/CERT-HD"         
      ER27441             FORMAT=1.   LABEL="L67 WTR 4TH DEGREE/CERT-HD"              
      ER27442             FORMAT=2.   LABEL="L68 RELIGIOUS PREFERENCE-HD"             
      ER27443             FORMAT=2.   LABEL="L69 RELIG DENOMINATION-HD"               
      ER27444             FORMAT=2.   LABEL="L70 #YRS WRKD SINCE 18-HD"               
      ER27445             FORMAT=2.   LABEL="L71 #YR WRKED FULLTIME-HD"               
      ER27446             FORMAT=3.   LABEL="L72-72A OCCUPATION 1ST FULL TIME JOB-HD" 
      ER27447             FORMAT=3.   LABEL="L73 INDUSTRY 1ST FULL TIME JOB-HD"       
      ER27448             FORMAT=1.   LABEL="L74 # DIFF JOBS OR?-HD"                  
      ER27449             FORMAT=1.   LABEL="M1 WTR DONATION>25 TO CHARITY LAST YEAR" 
      ER27450             FORMAT=1.   LABEL="M2 WTR DONATED TO RELIGIOUS ORGANIZATION"
      ER27451             FORMAT=6.   LABEL="M2A DOLLAR AMT OF RELIGIOUS DONATIONS"   
      ER27452             FORMAT=1.   LABEL="M2B WTR RELIGIOUS DONATIONS GE 300"      
      ER27453             FORMAT=1.   LABEL="M2C WTR RELIGIOUS DONATIONS GE 1,000"    
      ER27454             FORMAT=1.   LABEL="M2D WTR RELIGIOUS DONATIONS GE 2,500"    
      ER27455             FORMAT=1.   LABEL="M2E WTR RELIGIOUS DONATIONS GE 100"      
      ER27456             FORMAT=1.   LABEL="M3 WTR DONATD TO COMBO PURPOSE ORGANIZTN"
      ER27457             FORMAT=6.   LABEL="M3A DOLLAR AMT OF COMBO DONATIONS"       
      ER27458             FORMAT=1.   LABEL="M3B WTR COMBO DONATIONS GE 200"          
      ER27459             FORMAT=1.   LABEL="M3C WTR COMBO DONATIONS GE 500"          
      ER27460             FORMAT=1.   LABEL="M3D WTR COMBO DONATIONS GE 1,000"        
      ER27461             FORMAT=1.   LABEL="M3E WTR COMBO DONATIONS GE 100"          
      ER27462             FORMAT=1.   LABEL="M4 WTR DONATED TO ORGANIZATION FOR NEEDY"
      ER27463             FORMAT=5.   LABEL="M4A DOLLAR AMT OF NEEDY DONATIONS"       
      ER27464             FORMAT=1.   LABEL="M4B WTR NEEDY DONATIONS GE 200"          
      ER27465             FORMAT=1.   LABEL="M4C WTR NEEDY DONATIONS GE 500"          
      ER27466             FORMAT=1.   LABEL="M4D WTR NEEDY DONATIONS GE 1,000"        
      ER27467             FORMAT=1.   LABEL="M4E WTR NEEDY DONATIONS GE 100"          
      ER27468             FORMAT=1.   LABEL="M5 WTR DONATED TO ORGANIZATN FOR HEALTH" 
      ER27469             FORMAT=5.   LABEL="M5A DOLLAR AMT OF HEALTH DONATIONS"      
      ER27470             FORMAT=1.   LABEL="M5B WTR HEALTH DONATIONS GE 200"         
      ER27471             FORMAT=1.   LABEL="M5C WTR HEALTH DONATIONS GE 500"         
      ER27472             FORMAT=1.   LABEL="M5D WTR HEALTH DONATIONS GE 1,000"       
      ER27473             FORMAT=1.   LABEL="M5E WTR HEALTH DONATIONS GE 100"         
      ER27474             FORMAT=1.   LABEL="M6 WTR DONATED TO ORGANZTION FOR EDUCATN"
      ER27475             FORMAT=5.   LABEL="M6A DOLLAR AMT OF EDUCATION DONATIONS"   
      ER27476             FORMAT=1.   LABEL="M6B WTR EDUCATION DONATIONS GE 200"      
      ER27477             FORMAT=1.   LABEL="M6C WTR EDUCATION DONATIONS GE 500"      
      ER27478             FORMAT=1.   LABEL="M6D WTR EDUCATION DONATIONS GE 1,000"    
      ER27479             FORMAT=1.   LABEL="M6E WTR EDUCATION DONATIONS GE 100"      
      ER27480             FORMAT=1.   LABEL="M7 WTR DONATED TO YOUTH ORGANIZATIONS"   
      ER27481             FORMAT=5.   LABEL="M7A DOLLAR AMT OF YOUTH ORG DONATIONS"   
      ER27482             FORMAT=1.   LABEL="M7B WTR YOUTH ORG DONATIONS GE 200"      
      ER27483             FORMAT=1.   LABEL="M7C WTR YOUTH ORG DONATIONS GE 500"      
      ER27484             FORMAT=1.   LABEL="M7D WTR YOUTH ORG DONATIONS GE 1,000"    
      ER27485             FORMAT=1.   LABEL="M7E WTR YOUTH ORG DONATIONS GE 100"      
      ER27486             FORMAT=1.   LABEL="M8 WTR DONATED TO CULTURAL ORGS"         
      ER27487             FORMAT=5.   LABEL="M8A DOLLAR AMT OF CULTURAL DONATIONS"    
      ER27488             FORMAT=1.   LABEL="M8B WTR CULTURAL DONATIONS GE 200"       
      ER27489             FORMAT=1.   LABEL="M8C WTR CULTURAL DONATIONS GE 500"       
      ER27490             FORMAT=1.   LABEL="M8D WTR CULTURAL DONATIONS GE 1,000"     
      ER27491             FORMAT=1.   LABEL="M8E WTR CULTURAL DONATIONS GE 100"       
      ER27492             FORMAT=1.   LABEL="M9 WTR DONATED TO COMMUNITY ORGS"        
      ER27493             FORMAT=5.   LABEL="M9A DOLLAR AMT OF COMMUNITY DONATIONS"   
      ER27494             FORMAT=1.   LABEL="M9B WTR COMMUNITY DONATIONS GE 200"      
      ER27495             FORMAT=1.   LABEL="M9C WTR COMMUNITY DONATIONS GE 500"      
      ER27496             FORMAT=1.   LABEL="M9D WTR COMMUNITY DONATIONS GE 1,000"    
      ER27497             FORMAT=1.   LABEL="M9E WTR COMMUNITY DONATIONS GE 100"      
      ER27498             FORMAT=1.   LABEL="M10 WTR DONATED TO ENVIRONMENT ORGS"     
      ER27499             FORMAT=5.   LABEL="M10A DOLLAR AMT OF ENVIRONMENT DONATION" 
      ER27500             FORMAT=1.   LABEL="M10B WTR ENVIRONMENT DONATIONS GE 200"   
      ER27501             FORMAT=1.   LABEL="M10C WTR ENVIRONMENT DONATIONS GE 500"   
      ER27502             FORMAT=1.   LABEL="M10D WTR ENVIRONMENT DONATIONS GE 1,000" 
      ER27503             FORMAT=1.   LABEL="M10E WTR ENVIRONMENT DONATIONS GE 100"   
      ER27504             FORMAT=1.   LABEL="M11 WTR DONATED TO INTERNATL/PEACE ORG"  
      ER27505             FORMAT=5.   LABEL="M11A DOLLAR AMT OF INTERNATL/PEACE DNTN" 
      ER27506             FORMAT=1.   LABEL="M11B WTR INTERNATL/PEACE DNTNS GE 200"   
      ER27507             FORMAT=1.   LABEL="M11C WTR INTERNATL/PEACE DNTNS GE 500"   
      ER27508             FORMAT=1.   LABEL="M11D WTR INTERNATL/PEACE DNTNS GE 1,000" 
      ER27509             FORMAT=1.   LABEL="M11E WTR INTERNATL/PEACE DNTNS GE 100"   
      ER27510             FORMAT=1.   LABEL="M12 WTR DONATED TO OTHER ORGANIZATIONS"  
      ER27511             FORMAT=5.   LABEL="M12B DOLLAR AMT OF OTHER DONATIONS"      
      ER27512             FORMAT=1.   LABEL="M12C WTR OTHER DONATIONS GE 200"         
      ER27513             FORMAT=1.   LABEL="M12D WTR OTHER DONATIONS GE 500"         
      ER27514             FORMAT=1.   LABEL="M12E WTR OTHER DONATIONS GE 1,000"       
      ER27515             FORMAT=1.   LABEL="M12F WTR OTHER DONATIONS GE 100"         
      ER27516             FORMAT=1.   LABEL="M13A WHO DECIDED CHARITABLE SUPPORT"     
      ER27517             FORMAT=1.   LABEL="M13B WTR H/W IS MAJOR DECISION MAKER"    
      ER27518             FORMAT=1.   LABEL="M13C WHO DECIDED CHARITABLE SUPPORT"     
      ER27519             FORMAT=2.   LABEL="M13D SEQ NUMBER OF MAIN DECISION MAKER"  
      ER27520             FORMAT=1.   LABEL="M14 WTR HEAD VOLUNTEERED PAST MONTH"     
      ER27521             FORMAT=1.   LABEL="M14A WTR HEAD VOLUNTEERED LAST YEAR"     
      ER27522             FORMAT=1.   LABEL="M14B WTR HD/WF VOLUNTEERED PAST MONTH"   
      ER27523             FORMAT=1.   LABEL="M14C WTR HD/WF VOLUNTEERED LAST YR"      
      ER27524             FORMAT=2.   LABEL="M15A HOW OFTEN HD RELIG VLNTEER LAST YR" 
      ER27525             FORMAT=1.   LABEL="M15A HOW OFTEN HD RELIG VOLUNTEER PER"   
      ER27526             FORMAT=1.   LABEL="M15C HD NAME FOR PLACE OF WORSHIP"       
      ER27527             FORMAT=2.   LABEL="M15D HD HOURS VOLUNTEER EACH TIME"       
      ER27528             FORMAT=2.   LABEL="M15D HD MINUTES VOLUNTEER EACH TIME"     
      ER27529             FORMAT=5.   LABEL="M15E HD ANNUAL HRS RELIG VOLUNTEER"      
      ER27530             FORMAT=1.   LABEL="M15F WTR HD MORE/FEWER HRS THAN M15E"    
      ER27531             FORMAT=5.   LABEL="M15G HD ESTIMATE RELIG VLNTEER ANN HRS"  
      ER27532             FORMAT=1.   LABEL="M15H WTR M15G INCLUDES EXTRA VOLUNTEER"  
      ER27533             FORMAT=5.   LABEL="M15I ANN HRS REGULAR VLNTEER+EXTRA"      
      ER27534             FORMAT=2.   LABEL="M18A HOW OFTEN WF RELIG VLNTEER LAST YR" 
      ER27535             FORMAT=1.   LABEL="M18A HOW OFTEN WF RELIG VOLUNTEER PER"   
      ER27536             FORMAT=1.   LABEL="M18C WF NAME FOR PLACE OF WORSHIP"       
      ER27537             FORMAT=2.   LABEL="M18D WF HOURS  VOLUNTEER EACH TIME"      
      ER27538             FORMAT=2.   LABEL="M18D WF MINUTES VOLUNTEER EACH TIME"     
      ER27539             FORMAT=5.   LABEL="M18E WF ANNUAL HRS RELIG VOLUNTEER"      
      ER27540             FORMAT=1.   LABEL="M18F WTR WF MORE/FEWER HRS THAN M18E"    
      ER27541             FORMAT=5.   LABEL="M18G WF ESTIMATE RELIG VLNTEER ANN HRS"  
      ER27542             FORMAT=1.   LABEL="M18H WTR M18G INCLUDES EXTRA VOLUNTEER"  
      ER27543             FORMAT=5.   LABEL="M18I ANN HRS REGULAR VLNTEER+EXTRA"      
      ER27544             FORMAT=2.   LABEL="M21A HOW OFTEN HD YOUTH VLNTEER LAST YR" 
      ER27545             FORMAT=1.   LABEL="M21A HOW OFTEN HD YOUTH VOLUNTEER PER"   
      ER27546             FORMAT=2.   LABEL="M21C HD HOURS VOLUNTEER EACH TIME"       
      ER27547             FORMAT=2.   LABEL="M21C HD MINUTES VOLUNTEER EACH TIME"     
      ER27548             FORMAT=5.   LABEL="M21D HD ANNUAL HRS YOUTH VOLUNTEER"      
      ER27549             FORMAT=1.   LABEL="M21E WTR HD MORE/FEWER HRS THAN M21D"    
      ER27550             FORMAT=5.   LABEL="M21F HD ESTIMATE YOUTH VLNTEER ANN HRS"  
      ER27551             FORMAT=1.   LABEL="M21G WTR M21F INCLUDES EXTRA VOLUNTEER"  
      ER27552             FORMAT=5.   LABEL="M21H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER27553             FORMAT=2.   LABEL="M23A HOW OFTEN WF YOUTH VLNTEER LAST YR" 
      ER27554             FORMAT=1.   LABEL="M23A HOW OFTEN WF YOUTH VOLUNTEER PER"   
      ER27555             FORMAT=2.   LABEL="M23C WF HOURS VOLUNTEER EACH TIME"       
      ER27556             FORMAT=2.   LABEL="M23C WF MINUTES VOLUNTEER EACH TIME"     
      ER27557             FORMAT=5.   LABEL="M23D WF ANNUAL HRS YOUTH VOLUNTEER"      
      ER27558             FORMAT=1.   LABEL="M23E WTR WF MORE/FEWER HRS THAN M23D"    
      ER27559             FORMAT=5.   LABEL="M23F HD ESTIMATE YOUTH VLNTEER ANN HRS"  
      ER27560             FORMAT=1.   LABEL="M23G WTR M23F INCLUDES EXTRA VOLUNTEER"  
      ER27561             FORMAT=5.   LABEL="M23H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER27562             FORMAT=2.   LABEL="M25A HOW OFTEN HD SENIOR VLNTEER LAST YR"
      ER27563             FORMAT=1.   LABEL="M25A HOW OFTEN HD SENIOR VOLUNTEER PER"  
      ER27564             FORMAT=2.   LABEL="M25C HD HOURS VOLUNTEER EACH TIME"       
      ER27565             FORMAT=2.   LABEL="M25C HD MINUTES VOLUNTEER EACH TIME"     
      ER27566             FORMAT=5.   LABEL="M25D HD ANNUAL HRS SENIOR VOLUNTEER"     
      ER27567             FORMAT=1.   LABEL="M25E WTR HD MORE/FEWER HRS THAN M25D"    
      ER27568             FORMAT=5.   LABEL="M25F HD ESTIMATE SENIOR VLNTEER ANN HRS" 
      ER27569             FORMAT=1.   LABEL="M25G WTR M25F INCLUDES EXTRA VOLUNTEER"  
      ER27570             FORMAT=5.   LABEL="M25H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER27571             FORMAT=2.   LABEL="M27A HOW OFTEN WF SENIOR VLNTEER LAST YR"
      ER27572             FORMAT=1.   LABEL="M27A HOW OFTEN WF SENIOR VOLUNTEER PER"  
      ER27573             FORMAT=2.   LABEL="M27C WF HOURS VOLUNTEER EACH TIME"       
      ER27574             FORMAT=2.   LABEL="M27C WF MINUTES VOLUNTEER EACH TIME"     
      ER27575             FORMAT=5.   LABEL="M27D WF ANNUAL HRS SENIOR VOLUNTEER"     
      ER27576             FORMAT=1.   LABEL="M27E WTR WF MORE/FEWER HRS THAN M27D"    
      ER27577             FORMAT=5.   LABEL="M27F WF ESTIMATE SENIOR VLNTEER ANN HRS" 
      ER27578             FORMAT=1.   LABEL="M27G WTR M27F INCLUDES EXTRA VOLUNTEER"  
      ER27579             FORMAT=5.   LABEL="M27H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER27580             FORMAT=2.   LABEL="M29A HOW OFTEN HD HEALTH VLNTEER LAST YR"
      ER27581             FORMAT=1.   LABEL="M29A HOW OFTEN HD HEALTH VOLUNTEER PER"  
      ER27582             FORMAT=2.   LABEL="M29C HD HOURS VOLUNTEER EACH TIME"       
      ER27583             FORMAT=2.   LABEL="M29C HD MINUTES VOLUNTEER EACH TIME"     
      ER27584             FORMAT=5.   LABEL="M29D HD ANNUAL HRS HEALTH VOLUNTEER"     
      ER27585             FORMAT=1.   LABEL="M29E WTR HD MORE/FEWER HRS THAN M29D"    
      ER27586             FORMAT=5.   LABEL="M29F HD ESTIMATE HEALTH VLNTEER ANN HRS" 
      ER27587             FORMAT=1.   LABEL="M29G WTR M29F INCLUDES EXTRA VOLUNTEER"  
      ER27588             FORMAT=5.   LABEL="M29H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER27589             FORMAT=2.   LABEL="M31A HOW OFTEN WF HEALTH VLNTEER LAST YR"
      ER27590             FORMAT=1.   LABEL="M31A HOW OFTEN WF HEALTH VOLUNTEER PER"  
      ER27591             FORMAT=2.   LABEL="M31C WF HOURS VOLUNTEER EACH TIME"       
      ER27592             FORMAT=2.   LABEL="M31C WF MINUTES VOLUNTEER EACH TIME"     
      ER27593             FORMAT=5.   LABEL="M31D WF ANNUAL HRS HEALTH VOLUNTEER"     
      ER27594             FORMAT=1.   LABEL="M31E WTR WF MORE/FEWER HRS THAN M31D"    
      ER27595             FORMAT=5.   LABEL="M31F WF ESTIMATE HEALTH VLNTEER ANN HRS" 
      ER27596             FORMAT=1.   LABEL="M31G WTR M31F INCLUDES EXTRA VOLUNTEER"  
      ER27597             FORMAT=5.   LABEL="M31H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER27598             FORMAT=2.   LABEL="M33A HOW OFTEN HD VLNTEER NEEDY LAST YR" 
      ER27599             FORMAT=1.   LABEL="M33A HOW OFTEN HD VOLUNTEER NEEDY PER"   
      ER27600             FORMAT=2.   LABEL="M33C HD HOURS VOLUNTEER EACH TIME"       
      ER27601             FORMAT=2.   LABEL="M33C HD MINUTES VOLUNTEER EACH TIME"     
      ER27602             FORMAT=5.   LABEL="M33D HD ANNUAL HRS VOLUNTEER FOR NEEDY"  
      ER27603             FORMAT=1.   LABEL="M33E WTR HD MORE/FEWER HRS THAN M33D"    
      ER27604             FORMAT=5.   LABEL="M33F HD ESTIMATE VLNTEER NEEDY ANN HRS"  
      ER27605             FORMAT=1.   LABEL="M33G WTR M33F INCLUDES EXTRA VOLUNTEER"  
      ER27606             FORMAT=5.   LABEL="M33H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER27607             FORMAT=2.   LABEL="M35A HOW OFTEN WF VLNTEER NEEDY LAST YR" 
      ER27608             FORMAT=1.   LABEL="M35A HOW OFTEN WF VOLUNTEER NEEDY PER"   
      ER27609             FORMAT=2.   LABEL="M35C WF HOURS VOLUNTEER EACH TIME"       
      ER27610             FORMAT=2.   LABEL="M35C WF MINUTES VOLUNTEER EACH TIME"     
      ER27611             FORMAT=5.   LABEL="M35D WF ANNUAL HRS VOLUNTEER FOR NEEDY"  
      ER27612             FORMAT=1.   LABEL="M35E WTR WF MORE/FEWER HRS THAN M35D"    
      ER27613             FORMAT=5.   LABEL="M35F WF ESTIMATE VLNTEER NEEDY ANN HRS"  
      ER27614             FORMAT=1.   LABEL="M35G WTR M35F INCLUDES EXTRA VOLUNTEER"  
      ER27615             FORMAT=5.   LABEL="M35H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER27616             FORMAT=2.   LABEL="M37A HOW OFTEN HD VLNTEER CHANGE LST YR" 
      ER27617             FORMAT=1.   LABEL="M37A HOW OFTEN HD VOLUNTEER CHANGE PER"  
      ER27618             FORMAT=2.   LABEL="M37C HD HOURS VOLUNTEER EACH TIME"       
      ER27619             FORMAT=2.   LABEL="M37C HD MINUTES VOLUNTEER EACH TIME"     
      ER27620             FORMAT=5.   LABEL="M37D HD ANNUAL HRS VLNTEER FOR CHANGE"   
      ER27621             FORMAT=1.   LABEL="M37E WTR HD MORE/FEWER HRS THAN M37D"    
      ER27622             FORMAT=5.   LABEL="M37F HD ESTIMATE VLNTEER CHANGE ANN HRS" 
      ER27623             FORMAT=1.   LABEL="M37G WTR M37F INCLUDES EXTRA VOLUNTEER"  
      ER27624             FORMAT=5.   LABEL="M37H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER27625             FORMAT=2.   LABEL="M39A HOW OFTEN WF VLNTEER CHANGE LST YR" 
      ER27626             FORMAT=1.   LABEL="M39A HOW OFTEN WF VOLUNTEER CHANGE PER"  
      ER27627             FORMAT=2.   LABEL="M39C WF HOURS VOLUNTEER EACH TIME"       
      ER27628             FORMAT=2.   LABEL="M39C WF MINUTES VOLUNTEER EACH TIME"     
      ER27629             FORMAT=5.   LABEL="M39D WF ANNUAL HRS VLNTEER FOR CHANGE"   
      ER27630             FORMAT=1.   LABEL="M39E WTR WF MORE/FEWER HRS THAN M39D"    
      ER27631             FORMAT=5.   LABEL="M39F WF ESTIMATE VLNTEER CHANGE ANN HRS" 
      ER27632             FORMAT=1.   LABEL="M39G WTR M39F INCLUDES EXTRA VOLUNTEER"  
      ER27633             FORMAT=5.   LABEL="M39H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER27634             FORMAT=1.   LABEL="M41 WTR HD OTHER VLNTEER LAST YR"        
      ER27635             FORMAT=2.   LABEL="M41B HOW OFTEN HD OTHER VLNTEER"         
      ER27636             FORMAT=1.   LABEL="M41B HOW OFTEN HD OTHER VLNTEER PER"     
      ER27637             FORMAT=2.   LABEL="M41C HD HOURS VOLUNTEER EACH TIME"       
      ER27638             FORMAT=2.   LABEL="M41C HD MINUTES VOLUNTEER EACH TIME"     
      ER27639             FORMAT=5.   LABEL="M41D HD ANNURAL HRS OTHER VOLUNTEER"     
      ER27640             FORMAT=1.   LABEL="M41E WTR HD MORE/FEWER HRS THAN M41D"    
      ER27641             FORMAT=5.   LABEL="M41F HD ESTIMATE OTHER VLNTEER ANN HRS"  
      ER27642             FORMAT=1.   LABEL="M41G WTR M41F INCLUDES EXTRA VOLUNTEER"  
      ER27643             FORMAT=5.   LABEL="M41H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER27644             FORMAT=1.   LABEL="M43 WTR WF OTHER VLNTEER LAST YR"        
      ER27645             FORMAT=2.   LABEL="M43B HOW OFTEN WF OTHER VLNTEER"         
      ER27646             FORMAT=1.   LABEL="M43B HOW OFTEN WF OTHER VLNTEER PER"     
      ER27647             FORMAT=2.   LABEL="M43C WF HOURS VOLUNTEER EACH TIME"       
      ER27648             FORMAT=2.   LABEL="M43C WF MINUTES VOLUNTEER EACH TIME"     
      ER27649             FORMAT=5.   LABEL="M43D WF ANNURAL HRS OTHER VOLUNTEER"     
      ER27650             FORMAT=1.   LABEL="M43E WTR WF MORE/FEWER HRS THAN M43D"    
      ER27651             FORMAT=5.   LABEL="M43F WF ESTIMATE OTHER VLNTEER ANN HRS"  
      ER27652             FORMAT=1.   LABEL="M43G WTR M43F INCLUDES EXTRA VOLUNTEER"  
      ER27653             FORMAT=5.   LABEL="M43H ANN HRS REGULAR VLNTEER+EXTRA"      
      ER27654             FORMAT=1.   LABEL="M45 WTR VOLUNTEER THRU ORGS"             
      ER27655             FORMAT=1.   LABEL="M46 WTR THRU PLACE OF WORSHIP"           
      ER27656             FORMAT=5.   LABEL="M46A HRS THRU PLACE OF WORSHIP"          
      ER27657             FORMAT=1.   LABEL="M47 WTR THRU ORGS FOR KIDS"              
      ER27658             FORMAT=5.   LABEL="M47A HRS THRU ORGS FOR KIDS"             
      ER27659             FORMAT=1.   LABEL="M48 WTR THRU ORGS FOR SENIORS"           
      ER27660             FORMAT=5.   LABEL="M48A HRS THRU ORGS FOR SENIORS"          
      ER27661             FORMAT=1.   LABEL="M49 WTR THRU HEALTH ORGS"                
      ER27662             FORMAT=5.   LABEL="M49A HRS THRU HEALTH ORGS"               
      ER27663             FORMAT=1.   LABEL="M50 WTR THRU ORGS FOR POOR"              
      ER27664             FORMAT=5.   LABEL="M50A HRS THRU ORGS FOR POOR"             
      ER27665             FORMAT=1.   LABEL="M51 WTR THRU ORGS FOR SOC CHANGE"        
      ER27666             FORMAT=5.   LABEL="M51A HRS THRU ORGS FOR SOC CHANGE"       
      ER27667             FORMAT=1.   LABEL="M52 WTR THRU ORGS FOR OTR PURPOSES"      
      ER27668             FORMAT=5.   LABEL="M52A  HRS THRU ORGS FOR OTR PURPOSES"    
      ER27669             FORMAT=1.   LABEL="M52B WTR DONATED TO TSUNAMI VICTIMS"     
      ER27670             FORMAT=1.   LABEL="M52C WTR DONATED THRU CHURCH ETC"        
      ER27671             FORMAT=1.   LABEL="M52D WTR DONATED THRU INTERNET"          
      ER27672             FORMAT=1.   LABEL="M52E WTR DONATED THRU WORK/SCHOOL"       
      ER27673             FORMAT=1.   LABEL="M52F WTR DONATED THRU STORES"            
      ER27674             FORMAT=1.   LABEL="M52G WTR DONATED THRU CHARITY EVENT"     
      ER27675             FORMAT=1.   LABEL="M52H WTR DONATD THRU MAIL/PHONE SOLICIT" 
      ER27676             FORMAT=1.   LABEL="M52I WTR DONATED THRU TV/RADIO SOLICIT"  
      ER27677             FORMAT=1.   LABEL="M52J WTR DONATED THRU OTHER METHOD"      
      ER27678             FORMAT=6.   LABEL="M52K TOT DONATIONS TO TSUNAMI VICTIMS"   
      ER27679             FORMAT=1.   LABEL="M52K1 WTR DONATED $50 OR MORE"           
      ER27680             FORMAT=1.   LABEL="M52K2 WTR DONATED $25 OR MORE"           
      ER27681             FORMAT=1.   LABEL="M52K3 WTR DONATED $100 OR MORE"          
      ER27682             FORMAT=1.   LABEL="M52K4 WTR DONATED $300 OR MORE"          
      ER27683             FORMAT=1.   LABEL="M52L WTR TSUNAMI AMT INCL IN M1-M12"     
      ER27684             FORMAT=1.   LABEL="M53A WTR REC HELP FROM OTRS LAST YEAR"   
      ER27685             FORMAT=1.   LABEL="M53B WTR REC HELP FROM OTRS LAST YEAR"   
      ER27686             FORMAT=1.   LABEL="M53C WTR REC HELP FROM OTRS LAST YEAR"   
      ER27687             FORMAT=1.   LABEL="M53D WTR REC HELP FROM OTRS LAST YEAR"   
      ER27688             FORMAT=1.   LABEL="M53E WTR REC HELP FROM OTRS LAST YEAR"   
      ER27689             FORMAT=1.   LABEL="M53F WTR REC HELP FROM OTRS LAST YEAR"   
      ER27690             FORMAT=1.   LABEL="M53G WTR REC HELP FROM OTRS LAST YEAR"   
      ER27691             FORMAT=1.   LABEL="M53H WTR REC HELP FROM OTRS LAST YEAR"   
      ER27692             FORMAT=1.   LABEL="M54A WTR REC HELP FROM OTRS LAST YEAR"   
      ER27693             FORMAT=1.   LABEL="M54B WTR REC HELP FROM OTRS LAST YEAR"   
      ER27694             FORMAT=1.   LABEL="M54C WTR REC HELP FROM OTRS LAST YEAR"   
      ER27695             FORMAT=1.   LABEL="M54D WTR REC HELP FROM OTRS LAST YEAR"   
      ER27696             FORMAT=1.   LABEL="M54E WTR REC HELP FROM OTRS LAST YEAR"   
      ER27697             FORMAT=1.   LABEL="M54F WTR REC HELP FROM OTRS LAST YEAR"   
      ER27698             FORMAT=1.   LABEL="M54G WTR REC HELP FROM OTRS LAST YEAR"   
      ER27699             FORMAT=1.   LABEL="M54H WTR REC HELP FROM OTRS LAST YEAR"   
      ER27700             FORMAT=1.   LABEL="M55A WTR REC OTR GVT ASST LAST YEAR"     
      ER27701             FORMAT=1.   LABEL="M55B WTR REC OTR GVT ASST LAST YEAR"     
      ER27702             FORMAT=1.   LABEL="M55C WTR REC OTR GVT ASST LAST YEAR"     
      ER27703             FORMAT=1.   LABEL="M55D WTR REC OTR GVT ASST LAST YEAR"     
      ER27704             FORMAT=1.   LABEL="M55E WTR REC OTR GVT ASST LAST YEAR"     
      ER27705             FORMAT=1.   LABEL="M55F WTR REC OTR GVT ASST LAST YEAR"     
      ER27706             FORMAT=1.   LABEL="M55G WTR REC OTR GVT ASST LAST YEAR"     
      ER27707             FORMAT=1.   LABEL="M55H WTR REC OTR GVT ASST LAST YEAR"     
      ER27708             FORMAT=2.   LABEL="M56 FREQ ATTEND RELIGIOUS SVCS-HD"       
      ER27709             FORMAT=1.   LABEL="M56 FREQ RELIGIOUS SERVICES PER-HD"      
      ER27710             FORMAT=2.   LABEL="M57 FREQ ATTEND RELIGIOUS SVCS-HD"       
      ER27711             FORMAT=1.   LABEL="M57 FREQ RELIGIOUS SERVICES PER-HD"      
      ER27712             FORMAT=1.   LABEL="R16 WTR OFUMS REC ASSET Y YR BEFORE LAST"
      ER27713             FORMAT=8.   LABEL="R18 OFUM ASSET Y AMOUNT YEAR BEFORE LAST"
      ER27714             FORMAT=1.   LABEL="R18 OFUM ASSET Y PER YEAR BEFORE LAST"   
      ER27715             FORMAT=1.   LABEL="R19 WTR OFUMS REC ASSET Y JAN YR B4 LAST"
      ER27716             FORMAT=1.   LABEL="R19 WTR OFUMS REC ASSET Y FEB YR B4 LAST"
      ER27717             FORMAT=1.   LABEL="R19 WTR OFUMS REC ASSET Y MAR YR B4 LAST"
      ER27718             FORMAT=1.   LABEL="R19 WTR OFUMS REC ASSET Y APR YR B4 LAST"
      ER27719             FORMAT=1.   LABEL="R19 WTR OFUMS REC ASSET Y MAY YR B4 LAST"
      ER27720             FORMAT=1.   LABEL="R19 WTR OFUMS REC ASSET Y JUN YR B4 LAST"
      ER27721             FORMAT=1.   LABEL="R19 WTR OFUMS REC ASSET Y JUL YR B4 LAST"
      ER27722             FORMAT=1.   LABEL="R19 WTR OFUMS REC ASSET Y AUG YR B4 LAST"
      ER27723             FORMAT=1.   LABEL="R19 WTR OFUMS REC ASSET Y SEP YR B4 LAST"
      ER27724             FORMAT=1.   LABEL="R19 WTR OFUMS REC ASSET Y OCT YR B4 LAST"
      ER27725             FORMAT=1.   LABEL="R19 WTR OFUMS REC ASSET Y NOV YR B4 LAST"
      ER27726             FORMAT=1.   LABEL="R19 WTR OFUMS REC ASSET Y DEC YR B4 LAST"
      ER27727             FORMAT=1.   LABEL="R20 WTR RECD SOC SECURITY YR BEFORE LAST"
      ER27728             FORMAT=1.   LABEL="R22 TYPE SOC SEC MEN 1 YR BEFORE LAST"   
      ER27729             FORMAT=1.   LABEL="R22 TYPE SOC SEC MEN 2 YR BEFORE LAST"   
      ER27730             FORMAT=7.   LABEL="R23 SOCIAL SECURITY AMOUNT YEAR B4 LAST" 
      ER27731             FORMAT=1.   LABEL="R23 SOCIAL SECURITY PER YEAR BEFORE LAST"
      ER27732             FORMAT=1.   LABEL="R24 WTR RECD SOC SEC JAN YR BEFORE LAST" 
      ER27733             FORMAT=1.   LABEL="R24 WTR RECD SOC SEC FEB YR BEFORE LAST" 
      ER27734             FORMAT=1.   LABEL="R24 WTR RECD SOC SEC MAR YR BEFORE LAST" 
      ER27735             FORMAT=1.   LABEL="R24 WTR RECD SOC SEC APR YR BEFORE LAST" 
      ER27736             FORMAT=1.   LABEL="R24 WTR RECD SOC SEC MAY YR BEFORE LAST" 
      ER27737             FORMAT=1.   LABEL="R24 WTR RECD SOC SEC JUN YR BEFORE LAST" 
      ER27738             FORMAT=1.   LABEL="R24 WTR RECD SOC SEC JUL YR BEFORE LAST" 
      ER27739             FORMAT=1.   LABEL="R24 WTR RECD SOC SEC AUG YR BEFORE LAST" 
      ER27740             FORMAT=1.   LABEL="R24 WTR RECD SOC SEC SEP YR BEFORE LAST" 
      ER27741             FORMAT=1.   LABEL="R24 WTR RECD SOC SEC OCT YR BEFORE LAST" 
      ER27742             FORMAT=1.   LABEL="R24 WTR RECD SOC SEC NOV YR BEFORE LAST" 
      ER27743             FORMAT=1.   LABEL="R24 WTR RECD SOC SEC DEC YR BEFORE LAST" 
      ER27744             FORMAT=1.   LABEL="R25 WTR RECD RETIREMENT YR BEFORE LAST"  
      ER27745             FORMAT=7.   LABEL="R26 RETIREMENT AMOUNT YEAR BEFORE LAST"  
      ER27746             FORMAT=1.   LABEL="R26 RETIREMENT PER YEAR BEFORE LAST"     
      ER27747             FORMAT=1.   LABEL="R28 WTR RECD RETIREMENT JAN YR B4 LAST"  
      ER27748             FORMAT=1.   LABEL="R28 WTR RECD RETIREMENT FEB YR B4 LAST"  
      ER27749             FORMAT=1.   LABEL="R28 WTR RECD RETIREMENT MAR YR B4 LAST"  
      ER27750             FORMAT=1.   LABEL="R28 WTR RECD RETIREMENT APR YR B4 LAST"  
      ER27751             FORMAT=1.   LABEL="R28 WTR RECD RETIREMENT MAY YR B4 LAST"  
      ER27752             FORMAT=1.   LABEL="R28 WTR RECD RETIREMENT JUN YR B4 LAST"  
      ER27753             FORMAT=1.   LABEL="R28 WTR RECD RETIREMENT JUL YR B4 LAST"  
      ER27754             FORMAT=1.   LABEL="R28 WTR RECD RETIREMENT AUG YR B4 LAST"  
      ER27755             FORMAT=1.   LABEL="R28 WTR RECD RETIREMENT SEP YR B4 LAST"  
      ER27756             FORMAT=1.   LABEL="R28 WTR RECD RETIREMENT OCT YR B4 LAST"  
      ER27757             FORMAT=1.   LABEL="R28 WTR RECD RETIREMENT NOV YR B4 LAST"  
      ER27758             FORMAT=1.   LABEL="R28 WTR RECD RETIREMENT DEC YR B4 LAST"  
      ER27759             FORMAT=1.   LABEL="R29 WTR RECD VA PENSION YR BEFORE LAST"  
      ER27760             FORMAT=7.   LABEL="R31 VA PENSION AMOUNT YEAR BEFORE LAST"  
      ER27761             FORMAT=1.   LABEL="R31 VA PENSION PER YEAR BEFORE LAST"     
      ER27762             FORMAT=1.   LABEL="R32 WTR RECD VA PENSION JAN YR B4 LAST"  
      ER27763             FORMAT=1.   LABEL="R32 WTR RECD VA PENSION FEB YR B4 LAST"  
      ER27764             FORMAT=1.   LABEL="R32 WTR RECD VA PENSION MAR YR B4 LAST"  
      ER27765             FORMAT=1.   LABEL="R32 WTR RECD VA PENSION APR YR B4 LAST"  
      ER27766             FORMAT=1.   LABEL="R32 WTR RECD VA PENSION MAY YR B4 LAST"  
      ER27767             FORMAT=1.   LABEL="R32 WTR RECD VA PENSION JUN YR B4 LAST"  
      ER27768             FORMAT=1.   LABEL="R32 WTR RECD VA PENSION JUL YR B4 LAST"  
      ER27769             FORMAT=1.   LABEL="R32 WTR RECD VA PENSION AUG YR B4 LAST"  
      ER27770             FORMAT=1.   LABEL="R32 WTR RECD VA PENSION SEP YR B4 LAST"  
      ER27771             FORMAT=1.   LABEL="R32 WTR RECD VA PENSION OCT YR B4 LAST"  
      ER27772             FORMAT=1.   LABEL="R32 WTR RECD VA PENSION NOV YR B4 LAST"  
      ER27773             FORMAT=1.   LABEL="R32 WTR RECD VA PENSION DEC YR B4 LAST"  
      ER27774             FORMAT=1.   LABEL="R33 WTR RECD UNEMP COMP YR BEFORE LAST"  
      ER27775             FORMAT=7.   LABEL="R35 UNEMP COMP AMOUNT YEAR BEFORE LAST"  
      ER27776             FORMAT=1.   LABEL="R35 UNEMP COMP PER YEAR BEFORE LAST"     
      ER27777             FORMAT=1.   LABEL="R36 WTR RECD UNEMP COMP JAN YR B4 LAST"  
      ER27778             FORMAT=1.   LABEL="R36 WTR RECD UNEMP COMP FEB YR B4 LAST"  
      ER27779             FORMAT=1.   LABEL="R36 WTR RECD UNEMP COMP MAR YR B4 LAST"  
      ER27780             FORMAT=1.   LABEL="R36 WTR RECD UNEMP COMP APR YR B4 LAST"  
      ER27781             FORMAT=1.   LABEL="R36 WTR RECD UNEMP COMP MAY YR B4 LAST"  
      ER27782             FORMAT=1.   LABEL="R36 WTR RECD UNEMP COMP JUN YR B4 LAST"  
      ER27783             FORMAT=1.   LABEL="R36 WTR RECD UNEMP COMP JUL YR B4 LAST"  
      ER27784             FORMAT=1.   LABEL="R36 WTR RECD UNEMP COMP AUG YR B4 LAST"  
      ER27785             FORMAT=1.   LABEL="R36 WTR RECD UNEMP COMP SEP YR B4 LAST"  
      ER27786             FORMAT=1.   LABEL="R36 WTR RECD UNEMP COMP OCT YR B4 LAST"  
      ER27787             FORMAT=1.   LABEL="R36 WTR RECD UNEMP COMP NOV YR B4 LAST"  
      ER27788             FORMAT=1.   LABEL="R36 WTR RECD UNEMP COMP DEC YR B4 LAST"  
      ER27789             FORMAT=1.   LABEL="R37 WTR RECD WORKERS COMP YR BEFORE LAST"
      ER27790             FORMAT=7.   LABEL="R39 WORKERS COMP AMOUNT YEAR BEFORE LAST"
      ER27791             FORMAT=1.   LABEL="R39 WORKERS COMP PER YEAR BEFORE LAST"   
      ER27792             FORMAT=1.   LABEL="R40 WTR RECD WORKERS COMP JAN YR B4 LAST"
      ER27793             FORMAT=1.   LABEL="R40 WTR RECD WORKERS COMP FEB YR B4 LAST"
      ER27794             FORMAT=1.   LABEL="R40 WTR RECD WORKERS COMP MAR YR B4 LAST"
      ER27795             FORMAT=1.   LABEL="R40 WTR RECD WORKERS COMP APR YR B4 LAST"
      ER27796             FORMAT=1.   LABEL="R40 WTR RECD WORKERS COMP MAY YR B4 LAST"
      ER27797             FORMAT=1.   LABEL="R40 WTR RECD WORKERS COMP JUN YR B4 LAST"
      ER27798             FORMAT=1.   LABEL="R40 WTR RECD WORKERS COMP JUL YR B4 LAST"
      ER27799             FORMAT=1.   LABEL="R40 WTR RECD WORKERS COMP AUG YR B4 LAST"
      ER27800             FORMAT=1.   LABEL="R40 WTR RECD WORKERS COMP SEP YR B4 LAST"
      ER27801             FORMAT=1.   LABEL="R40 WTR RECD WORKERS COMP OCT YR B4 LAST"
      ER27802             FORMAT=1.   LABEL="R40 WTR RECD WORKERS COMP NOV YR B4 LAST"
      ER27803             FORMAT=1.   LABEL="R40 WTR RECD WORKERS COMP DEC YR B4 LAST"
      ER27804             FORMAT=1.   LABEL="R41 WTR RECD TANF (ADC) YR B4 LAST"      
      ER27805             FORMAT=7.   LABEL="R45 TANF (ADC) AMOUNT YEAR BEFORE LAST"  
      ER27806             FORMAT=1.   LABEL="R45 TANF (ADC) PER YEAR BEFORE LAST"     
      ER27807             FORMAT=1.   LABEL="R46 WTR RECD TANF (ADC) JAN YR B4 LAST"  
      ER27808             FORMAT=1.   LABEL="R46 WTR RECD TANF (ADC) FEB YR B4 LAST"  
      ER27809             FORMAT=1.   LABEL="R46 WTR RECD TANF (ADC) MAR YR B4 LAST"  
      ER27810             FORMAT=1.   LABEL="R46 WTR RECD TANF (ADC) APR YR B4 LAST"  
      ER27811             FORMAT=1.   LABEL="R46 WTR RECD TANF (ADC) MAY YR B4 LAST"  
      ER27812             FORMAT=1.   LABEL="R46 WTR RECD TANF (ADC) JUN YR B4 LAST"  
      ER27813             FORMAT=1.   LABEL="R46 WTR RECD TANF (ADC) JUL YR B4 LAST"  
      ER27814             FORMAT=1.   LABEL="R46 WTR RECD TANF (ADC) AUG YR B4 LAST"  
      ER27815             FORMAT=1.   LABEL="R46 WTR RECD TANF (ADC) SEP YR B4 LAST"  
      ER27816             FORMAT=1.   LABEL="R46 WTR RECD TANF (ADC) OCT YR B4 LAST"  
      ER27817             FORMAT=1.   LABEL="R46 WTR RECD TANF (ADC) NOV YR B4 LAST"  
      ER27818             FORMAT=1.   LABEL="R46 WTR RECD TANF (ADC) DEC YR B4 LAST"  
      ER27819             FORMAT=1.   LABEL="R47 WTR RECEIVED SSI YR BEFORE LAST"     
      ER27820             FORMAT=7.   LABEL="R49 SSI AMOUNT YEAR BEFORE LAST"         
      ER27821             FORMAT=1.   LABEL="R49 SSI PER YEAR BEFORE LAST"            
      ER27822             FORMAT=1.   LABEL="R50 WTR RECD SSI JAN YR BEFORE LAST"     
      ER27823             FORMAT=1.   LABEL="R50 WTR RECD SSI FEB YR BEFORE LAST"     
      ER27824             FORMAT=1.   LABEL="R50 WTR RECD SSI MAR YR BEFORE LAST"     
      ER27825             FORMAT=1.   LABEL="R50 WTR RECD SSI APR YR BEFORE LAST"     
      ER27826             FORMAT=1.   LABEL="R50 WTR RECD SSI MAY YR BEFORE LAST"     
      ER27827             FORMAT=1.   LABEL="R50 WTR RECD SSI JUN YR BEFORE LAST"     
      ER27828             FORMAT=1.   LABEL="R50 WTR RECD SSI JUL YR BEFORE LAST"     
      ER27829             FORMAT=1.   LABEL="R50 WTR RECD SSI AUG YR BEFORE LAST"     
      ER27830             FORMAT=1.   LABEL="R50 WTR RECD SSI SEP YR BEFORE LAST"     
      ER27831             FORMAT=1.   LABEL="R50 WTR RECD SSI OCT YR BEFORE LAST"     
      ER27832             FORMAT=1.   LABEL="R50 WTR RECD SSI NOV YR BEFORE LAST"     
      ER27833             FORMAT=1.   LABEL="R50 WTR RECD SSI DEC YR BEFORE LAST"     
      ER27834             FORMAT=1.   LABEL="R51 WTR RECEIVED OTR WELFARE YR B4 LAST" 
      ER27835             FORMAT=7.   LABEL="R53 OTR WELFARE AMOUNT YEAR BEFORE LAST" 
      ER27836             FORMAT=1.   LABEL="R53 OTR WELFARE PER YEAR BEFORE LAST"    
      ER27837             FORMAT=1.   LABEL="R54 WTR RECD OTR WELFARE JAN YR B4 LAST" 
      ER27838             FORMAT=1.   LABEL="R54 WTR RECD OTR WELFARE FEB YR B4 LAST" 
      ER27839             FORMAT=1.   LABEL="R54 WTR RECD OTR WELFARE MAR YR B4 LAST" 
      ER27840             FORMAT=1.   LABEL="R54 WTR RECD OTR WELFARE APR YR B4 LAST" 
      ER27841             FORMAT=1.   LABEL="R54 WTR RECD OTR WELFARE MAY YR B4 LAST" 
      ER27842             FORMAT=1.   LABEL="R54 WTR RECD OTR WELFARE JUN YR B4 LAST" 
      ER27843             FORMAT=1.   LABEL="R54 WTR RECD OTR WELFARE JUL YR B4 LAST" 
      ER27844             FORMAT=1.   LABEL="R54 WTR RECD OTR WELFARE AUG YR B4 LAST" 
      ER27845             FORMAT=1.   LABEL="R54 WTR RECD OTR WELFARE SEP YR B4 LAST" 
      ER27846             FORMAT=1.   LABEL="R54 WTR RECD OTR WELFARE OCT YR B4 LAST" 
      ER27847             FORMAT=1.   LABEL="R54 WTR RECD OTR WELFARE NOV YR B4 LAST" 
      ER27848             FORMAT=1.   LABEL="R54 WTR RECD OTR WELFARE DEC YR B4 LAST" 
      ER27849             FORMAT=1.   LABEL="R55 WTR REC CH SUPP/ALIMONY YR B4 LAST"  
      ER27850             FORMAT=7.   LABEL="R57 CH SUPP/ALIMONY AMT YR BEFORE LAST"  
      ER27851             FORMAT=1.   LABEL="R57 CH SUPP/ALIMONY PER YR BEFORE LAST"  
      ER27852             FORMAT=1.   LABEL="R58 WTR REC CH SUPP/ALMNY JAN YR B4 LAST"
      ER27853             FORMAT=1.   LABEL="R58 WTR REC CH SUPP/ALMNY FEB YR B4 LAST"
      ER27854             FORMAT=1.   LABEL="R58 WTR REC CH SUPP/ALMNY MAR YR B4 LAST"
      ER27855             FORMAT=1.   LABEL="R58 WTR REC CH SUPP/ALMNY APR YR B4 LAST"
      ER27856             FORMAT=1.   LABEL="R58 WTR REC CH SUPP/ALMNY MAY YR B4 LAST"
      ER27857             FORMAT=1.   LABEL="R58 WTR REC CH SUPP/ALMNY JUN YR B4 LAST"
      ER27858             FORMAT=1.   LABEL="R58 WTR REC CH SUPP/ALMNY JUL YR B4 LAST"
      ER27859             FORMAT=1.   LABEL="R58 WTR REC CH SUPP/ALMNY AUG YR B4 LAST"
      ER27860             FORMAT=1.   LABEL="R58 WTR REC CH SUPP/ALMNY SEP YR B4 LAST"
      ER27861             FORMAT=1.   LABEL="R58 WTR REC CH SUPP/ALMNY OCT YR B4 LAST"
      ER27862             FORMAT=1.   LABEL="R58 WTR REC CH SUPP/ALMNY NOV YR B4 LAST"
      ER27863             FORMAT=1.   LABEL="R58 WTR REC CH SUPP/ALMNY DEC YR B4 LAST"
      ER27864             FORMAT=1.   LABEL="R59 WTR REC HELP FROM RELS YR B4 LAST"   
      ER27865             FORMAT=7.   LABEL="R61 HELP FROM RELS AMT YEAR BEFORE LAST" 
      ER27866             FORMAT=1.   LABEL="R61 HELP FROM RELS PER YEAR BEFORE LAST" 
      ER27867             FORMAT=1.   LABEL="R62 WTR REC HELP FRM RELS JAN YR B4 LAST"
      ER27868             FORMAT=1.   LABEL="R62 WTR REC HELP FRM RELS FEB YR B4 LAST"
      ER27869             FORMAT=1.   LABEL="R62 WTR REC HELP FRM RELS MAR YR B4 LAST"
      ER27870             FORMAT=1.   LABEL="R62 WTR REC HELP FRM RELS APR YR B4 LAST"
      ER27871             FORMAT=1.   LABEL="R62 WTR REC HELP FRM RELS MAY YR B4 LAST"
      ER27872             FORMAT=1.   LABEL="R62 WTR REC HELP FRM RELS JUN YR B4 LAST"
      ER27873             FORMAT=1.   LABEL="R62 WTR REC HELP FRM RELS JUL YR B4 LAST"
      ER27874             FORMAT=1.   LABEL="R62 WTR REC HELP FRM RELS AUG YR B4 LAST"
      ER27875             FORMAT=1.   LABEL="R62 WTR REC HELP FRM RELS SEP YR B4 LAST"
      ER27876             FORMAT=1.   LABEL="R62 WTR REC HELP FRM RELS OCT YR B4 LAST"
      ER27877             FORMAT=1.   LABEL="R62 WTR REC HELP FRM RELS NOV YR B4 LAST"
      ER27878             FORMAT=1.   LABEL="R62 WTR REC HELP FRM RELS DEC YR B4 LAST"
      ER27879             FORMAT=1.   LABEL="WHO WAS RESPONDENT"                      
      ER27880             FORMAT=3.   LABEL="# CALLS FOR IW"                          
      ER27881             FORMAT=1.   LABEL="LANGUAGE OF INTERVIEW"                   
      ER27882             FORMAT=2.   LABEL="# OF INDIVIDUAL RECORDS"                 
      ER27883             FORMAT=4.1  LABEL="HEAD WORK WEEKS-2004"                    
      ER27884             FORMAT=3.   LABEL="HEAD WEEKLY WORK HOURS-2004"             
      ER27885             FORMAT=4.   LABEL="HD OVERTIME WORK HOURS-2004"             
      ER27886             FORMAT=4.   LABEL="HEAD TOTAL HOURS OF WORK-2004"           
      ER27887             FORMAT=4.1  LABEL="HD WEEKS MISSED FOR ILLNESS OF OTRS-2004"
      ER27888             FORMAT=4.1  LABEL="HD WEEKS MISSED FOR OWN ILLNESS-2004"    
      ER27889             FORMAT=4.1  LABEL="HEAD WEEKS OFF FOR VACATION-2004"        
      ER27890             FORMAT=4.1  LABEL="HEAD STRIKE WEEKS-2004"                  
      ER27891             FORMAT=4.1  LABEL="HEAD WEEKS LAID OFF-2004"                
      ER27892             FORMAT=4.1  LABEL="HEAD UNEMPLOYMENT WEEKS-2004"            
      ER27893             FORMAT=4.1  LABEL="HEAD WEEKS OUT OF LABOR FORCE-2004"      
      ER27894             FORMAT=4.1  LABEL="WIFE WORK WEEKS-2004"                    
      ER27895             FORMAT=3.   LABEL="WIFE WEEKLY WORK HOURS-2004"             
      ER27896             FORMAT=4.   LABEL="WF OVERTIME WORK HOURS-2004"             
      ER27897             FORMAT=4.   LABEL="WIFE TOTAL HOURS OF WORK-2004"           
      ER27898             FORMAT=4.1  LABEL="WF WEEKS MISSED FOR ILLNESS OF OTRS-2004"
      ER27899             FORMAT=4.1  LABEL="WF WEEKS MISSED FOR OWN ILLNESS-2004"    
      ER27900             FORMAT=4.1  LABEL="WIFE WEEKS OFF FOR VACATION-2004"        
      ER27901             FORMAT=4.1  LABEL="WIFE STRIKE WEEKS-2004"                  
      ER27902             FORMAT=4.1  LABEL="WIFE WEEKS LAID OFF-2004"                
      ER27903             FORMAT=4.1  LABEL="WIFE UNEMPLOYMENT WEEKS-2004"            
      ER27904             FORMAT=4.1  LABEL="WIFE WEEKS OUT OF LABOR FORCE-2004"      
      ER27905             FORMAT=7.   LABEL="TOTAL BUSINESS INCOME-2004"              
      ER27906             FORMAT=1.   LABEL="ACC BUSINESS INCOME-2004"                
      ER27907             FORMAT=1.   LABEL="NUMBER OF BUSINESSES OWNED BY FU IN 2004"
      ER27908             FORMAT=7.   LABEL="FARM INCOME OF HEAD-2004"                
      ER27909             FORMAT=1.   LABEL="ACC FARM INCOME OF HEAD-2004"            
      ER27910             FORMAT=7.   LABEL="HD LABOR INCOME FROM BUSINESS-2004"      
      ER27911             FORMAT=7.   LABEL="HD ASSET INCOME FROM BUSINESS-2004"      
      ER27912             FORMAT=1.   LABEL="NUMBER OF BUSINESSES OWNED BY HEAD"      
      ER27913             FORMAT=7.   LABEL="WAGES AND SALARIES OF HEAD-2004"         
      ER27914             FORMAT=1.   LABEL="ACC WAGES AND SALARIES OF HEAD-2004"     
      ER27915             FORMAT=6.   LABEL="BONUS INCOME OF HEAD-2004"               
      ER27916             FORMAT=1.   LABEL="ACC BONUS INCOME OF HEAD-2004"           
      ER27917             FORMAT=6.   LABEL="OVERTIME INCOME OF HEAD-2004"            
      ER27918             FORMAT=1.   LABEL="ACC OVERTIME INCOME OF HEAD-2004"        
      ER27919             FORMAT=6.   LABEL="TIPS OF HEAD-2004"                       
      ER27920             FORMAT=1.   LABEL="ACC TIPS OF HEAD-2004"                   
      ER27921             FORMAT=6.   LABEL="COMMISSION INCOME OF HEAD-2004"          
      ER27922             FORMAT=1.   LABEL="ACC COMMISSION INCOME OF HEAD-2004"      
      ER27923             FORMAT=7.   LABEL="PROFESSIONAL PRACTICE OF HEAD-2004"      
      ER27924             FORMAT=1.   LABEL="ACC PROFESSIONL PRACTICE OF HD-2004"     
      ER27925             FORMAT=7.   LABEL="MARKET GARDENING INCOME OF HD-2004"      
      ER27926             FORMAT=1.   LABEL="ACC MARKET GARDENING INCOME OF HEAD"     
      ER27927             FORMAT=7.   LABEL="HEAD ADDITIONAL JOB INCOME-2004"         
      ER27928             FORMAT=1.   LABEL="ACC OF HEAD ADDITIONAL JOB INCOME"       
      ER27929             FORMAT=6.   LABEL="MISC LABOR INCOME OF HEAD-2004"          
      ER27930             FORMAT=1.   LABEL="ACC MISC LABOR INCOME OF HEAD-2004"      
      ER27931             FORMAT=7.   LABEL="LABOR INCOME OF HEAD-2004"               
      ER27932             FORMAT=6.   LABEL="HEAD RENT INCOME-2004"                   
      ER27933             FORMAT=1.   LABEL="ACCURACY OF HEAD RENT INCOME-2004"       
      ER27934             FORMAT=6.   LABEL="HEAD DIVIDENDS-2004"                     
      ER27935             FORMAT=1.   LABEL="ACCURACY OF HEAD DIVIDENDS-2004"         
      ER27936             FORMAT=6.   LABEL="HEAD INTEREST INCOME-2004"               
      ER27937             FORMAT=1.   LABEL="ACCURACY OF HEAD INTEREST INCOME-2004"   
      ER27938             FORMAT=6.   LABEL="HEAD INCOME FROM TRUSTS/ROYALTIES-2004"  
      ER27939             FORMAT=1.   LABEL="ACCURACY OF HD INCOME FROM TRUSTS-2004"  
      ER27940             FORMAT=7.   LABEL="WF LABOR INCOME FROM BUSINESS-2004"      
      ER27941             FORMAT=7.   LABEL="WF ASSET INCOME FROM BUSINESS-2004"      
      ER27942             FORMAT=1.   LABEL="NUMBER OF BUSINESSES OWNED BY WIFE"      
      ER27943             FORMAT=7.   LABEL="LABOR INCOME OF WIFE-2004"               
      ER27944             FORMAT=1.   LABEL="ACC LABOR INCOME OF WIFE-2004"           
      ER27945             FORMAT=6.   LABEL="WIFE RENT INCOME-2004"                   
      ER27946             FORMAT=1.   LABEL="ACCURACY OF WIFE RENT INCOME-2004"       
      ER27947             FORMAT=6.   LABEL="WIFE DIVIDENDS-2004"                     
      ER27948             FORMAT=1.   LABEL="ACCURACY OF WIFE DIVIDENDS-2004"         
      ER27949             FORMAT=6.   LABEL="WIFE INTEREST INCOME-2004"               
      ER27950             FORMAT=1.   LABEL="ACCURACY OF WIFE INTEREST INCOME-2004"   
      ER27951             FORMAT=6.   LABEL="WIFE INCOME FROM TRUSTS/ROYALTIES-2004"  
      ER27952             FORMAT=1.   LABEL="ACCURACY OF WF INCOME FROM TRUSTS-2004"  
      ER27953             FORMAT=7.   LABEL="HEAD AND WIFE TAXABLE INCOME-2004"       
      ER27954             FORMAT=6.   LABEL="HEAD INCOME FROM TANF, ETC.-2004"        
      ER27955             FORMAT=1.   LABEL="ACCURACY OF HEAD INCOME FROM TANF-2004"  
      ER27956             FORMAT=6.   LABEL="HEAD SSI-2004"                           
      ER27957             FORMAT=1.   LABEL="ACCURACY OF HEAD SSI-2004"               
      ER27958             FORMAT=6.   LABEL="HEAD OTHER WELFARE-2004"                 
      ER27959             FORMAT=1.   LABEL="ACCURACY OF HEAD OTHER WELFARE-2004"     
      ER27960             FORMAT=6.   LABEL="HEAD VA PENSION-2004"                    
      ER27961             FORMAT=1.   LABEL="ACCURACY OF HEAD VA PENSION-2004"        
      ER27962             FORMAT=6.   LABEL="HEAD RETIREMENT/PENSIONS-2004"           
      ER27963             FORMAT=1.   LABEL="ACCURACY OF HEAD RETIREMENT-2004"        
      ER27964             FORMAT=6.   LABEL="HEAD ANNUITIES-2004"                     
      ER27965             FORMAT=1.   LABEL="ACCURACY OF HEAD ANNUITIES-2004"         
      ER27966             FORMAT=6.   LABEL="HEAD OTHER RETIREMENT-2004"              
      ER27967             FORMAT=1.   LABEL="ACCURACY OF HEAD OTHER RETIREMENT-2004"  
      ER27968             FORMAT=6.   LABEL="HEAD UNEMPLOYMENT COMPENSATION-2004"     
      ER27969             FORMAT=1.   LABEL="ACCURACY OF HEAD UNEMPLOYMENT COMP-2004" 
      ER27970             FORMAT=6.   LABEL="HEAD WORKERS COMPENSATION-2004"          
      ER27971             FORMAT=1.   LABEL="ACCURACY OF HEAD WORKERS COMP-2004"      
      ER27972             FORMAT=6.   LABEL="CHILD SUPPORT RECEIVED BY HEAD-2004"     
      ER27973             FORMAT=1.   LABEL="ACCURACY OF HEAD CHILD SUPPORT-2004"     
      ER27974             FORMAT=6.   LABEL="HEAD INCOME FROM ALIMONY-2004"           
      ER27975             FORMAT=1.   LABEL="ACCURACY OF HEAD ALIMONY-2004"           
      ER27976             FORMAT=6.   LABEL="HEAD HELP FROM RELATIVES-2004"           
      ER27977             FORMAT=1.   LABEL="ACCURACY OF HEAD HELP FROM RELS-2004"    
      ER27978             FORMAT=6.   LABEL="HEAD HELP FROM OTHERS-2004"              
      ER27979             FORMAT=1.   LABEL="ACCURACY OF HEAD HELP FROM OTHERS-2004"  
      ER27980             FORMAT=6.   LABEL="HEAD MISCELLANEOUS TRANSFERS-2004"       
      ER27981             FORMAT=1.   LABEL="ACCURACY OF HD MISC TRANSFERS-2004"      
      ER27982             FORMAT=6.   LABEL="WIFE INCOME FROM TANF, ETC.-2004"        
      ER27983             FORMAT=1.   LABEL="ACCURACY OF WIFE INCOME FROM TANF-2004"  
      ER27984             FORMAT=6.   LABEL="WIFE SSI-2004"                           
      ER27985             FORMAT=1.   LABEL="ACCURACY OF WIFE SSI-2004"               
      ER27986             FORMAT=6.   LABEL="WIFE OTHER WELFARE-2004"                 
      ER27987             FORMAT=1.   LABEL="ACCURACY OF WIFE OTHER WELFARE-2004"     
      ER27988             FORMAT=6.   LABEL="WIFE RETIREMENT/ANNUITIES-2004"          
      ER27989             FORMAT=1.   LABEL="ACCURACY OF WIFE RETIREMENT-2004"        
      ER27990             FORMAT=6.   LABEL="WIFE UNEMPLOYMENT COMPENSATION-2004"     
      ER27991             FORMAT=1.   LABEL="ACCURACY OF WIFE UNEMPLOYMENT COMP-2004" 
      ER27992             FORMAT=6.   LABEL="WIFE WORKERS COMPENSATION-2004"          
      ER27993             FORMAT=1.   LABEL="ACCURACY OF WIFE WORKERS COMP-2004"      
      ER27994             FORMAT=6.   LABEL="CHILD SUPPORT RECEIVED BY WIFE-2004"     
      ER27995             FORMAT=1.   LABEL="ACCURACY OF WIFE CHILD SUPPORT-2004"     
      ER27996             FORMAT=6.   LABEL="WIFE HELP FROM RELATIVES-2004"           
      ER27997             FORMAT=1.   LABEL="ACCURACY OF WIFE HELP FROM RELS-2004"    
      ER27998             FORMAT=6.   LABEL="WIFE HELP FROM OTHERS-2004"              
      ER27999             FORMAT=1.   LABEL="ACCURACY OF WIFE HELP FROM OTHERS-2004"  
      ER28000             FORMAT=6.   LABEL="WIFE MISCELLANEOUS TRANSFERS-2004"       
      ER28001             FORMAT=1.   LABEL="ACCURACY OF WF MISC TRANSFERS-2004"      
      ER28002             FORMAT=7.   LABEL="HEAD AND WIFE TRANSFER INCOME-2004"      
      ER28003             FORMAT=6.2  LABEL="HEAD WAGE RATE-2004"                     
      ER28004             FORMAT=6.2  LABEL="WIFE WAGE RATE-2004"                     
      ER28005             FORMAT=7.   LABEL="TOTAL LABOR INCOME OF OTR FU MEMBRS-2004"
      ER28006             FORMAT=1.   LABEL="ACCURACY OF OTR FU MEMBR LABOR Y-2004"   
      ER28007             FORMAT=6.   LABEL="TOTAL ASSET INCOME OF OTR FU MEMBRS-2004"
      ER28008             FORMAT=1.   LABEL="ACCURACY OF OTR FU MEMBR ASSET Y-2004"   
      ER28009             FORMAT=7.   LABEL="TAXABLE INCOME OF OTHER FU MEMBERS-2004" 
      ER28010             FORMAT=6.   LABEL="OTR FU MEMBR INCOME FROM TANF, ETC.-2004"
      ER28011             FORMAT=1.   LABEL="ACCURACY OF OFUM INCOME FROM TANF-2004"  
      ER28012             FORMAT=6.   LABEL="OTR FU MEMBERS SSI-2004"                 
      ER28013             FORMAT=1.   LABEL="ACCURACY OF OTR FU MEMBERS SSI-2004"     
      ER28014             FORMAT=6.   LABEL="OTR FU MEMBERS OTHER WELFARE-2004"       
      ER28015             FORMAT=1.   LABEL="ACCURACY OF OFUM OTHER WELFARE-2004"     
      ER28016             FORMAT=6.   LABEL="OTHER FU MEMBERS VA PENSION-2004"        
      ER28017             FORMAT=1.   LABEL="ACCURACY OF OTR FU MEMBR VA PENSION-2004"
      ER28018             FORMAT=6.   LABEL="OTHER FU MEMBR RETIREMENT/ANNUITIES-2004"
      ER28019             FORMAT=1.   LABEL="ACCURACY OF OFUM RETIREMENT-2004"        
      ER28020             FORMAT=6.   LABEL="OFUM UNEMPLOYMENT COMPENSATION-2004"     
      ER28021             FORMAT=1.   LABEL="ACCURACY OF OFUM UNEMPLOYMENT COMP-2004" 
      ER28022             FORMAT=6.   LABEL="OTR FU MEMBERS WORKERS COMPENSATION-2004"
      ER28023             FORMAT=1.   LABEL="ACCURACY OF OFUM WORKERS COMP-2004"      
      ER28024             FORMAT=6.   LABEL="OFUM INCOME FROM CHILD SUPPORT-2004"     
      ER28025             FORMAT=1.   LABEL="ACCURACY OF OFUM CHILD SUPPORT-2004"     
      ER28026             FORMAT=6.   LABEL="OTR FU MEMBERS HELP FROM RELATIVES-2004" 
      ER28027             FORMAT=1.   LABEL="ACCURACY OF OFUM HELP FROM RELS-2004"    
      ER28028             FORMAT=6.   LABEL="OFUM MISCELLANEOUS TRANSFERS-2004"       
      ER28029             FORMAT=1.   LABEL="ACCURACY OF OFUM MISC TRANSFERS-2004"    
      ER28030             FORMAT=6.   LABEL="TOTAL TRANSFER INCOME OF OFUMS-2004"     
      ER28031             FORMAT=6.   LABEL="HEAD SOCIAL SECURITY INCOME-2004"        
      ER28032             FORMAT=1.   LABEL="ACCURACY OF HEAD SOCIAL SECURITY-2004"   
      ER28033             FORMAT=6.   LABEL="WIFE SOCIAL SECURITY INCOME-2004"        
      ER28034             FORMAT=1.   LABEL="ACCURACY OF WIFE SOCIAL SECURITY-2004"   
      ER28035             FORMAT=6.   LABEL="OFUM SOCIAL SECURITY INCOME-2004"        
      ER28036             FORMAT=1.   LABEL="ACCURACY OF OFUM SOCIAL SECURITY-2004"   
      ER28037             FORMAT=7.   LABEL="TOTAL FAMILY INCOME-2004"                
      ER28038             FORMAT=5.   LABEL="USDA NEEDS STANDARD-2004"                
      ER28039             FORMAT=5.   LABEL="CENSUS NEEDS STANDARD-2004"              
      ER28040             FORMAT=5.   LABEL="USDA NEEDS STANDARD-2003"                
      ER28041             FORMAT=5.   LABEL="CENSUS NEEDS STANDARD-2003"              
      ER28042             FORMAT=1.   LABEL="CURRENT REGION"                          
      ER28043             FORMAT=2.   LABEL="BEALE RURAL-URBAN CODE"                  
      ER28044             FORMAT=1.   LABEL="SIZE LARGEST CITY IN COUNTY"             
      ER28045             FORMAT=1.   LABEL="REGION HD GREW UP"                       
      ER28046             FORMAT=1.   LABEL="HD GEOGRAPHIC MOBILITY"                  
      ER28047             FORMAT=2.   LABEL="COMPLETED ED-HD"                         
      ER28048             FORMAT=2.   LABEL="COMPLETED ED-WF"                         
      ER28049             FORMAT=1.   LABEL="MARITAL STATUS-GENERATED"                
      ER28050             FORMAT=1.   LABEL="CHANGE IN MARITAL STATUS"                
      ER28051             FORMAT=1.   LABEL="COUPLE STATUS OF HEAD"                   
      ER28052             FORMAT=4.   LABEL="YEAR NEW HEAD IN FU"                     
      ER28053             FORMAT=4.   LABEL="YEAR NEW WIFE IN FU"                     
      ER28054             FORMAT=1.   LABEL="HEAD-SPOUSE SAMPLE STATUS"               
      ER28055             FORMAT=1.   LABEL="NUMBER OF SPLITOFFS FROM MAIN FAM"       
      ER28056             FORMAT=5.   LABEL="MAIN FAMILY ID FOR SPLITOFF"             
      ER28057             FORMAT=5.   LABEL="CURRENT YR ID OF 1ST OTHER FU IN HU"     
      ER28058             FORMAT=1.   LABEL="REL OF 1ST OTHER FU"                     
      ER28059             FORMAT=2.   LABEL="SIZE OF 1ST OTHER FU"                    
      ER28060             FORMAT=5.   LABEL="CURRENT YR ID OF 2ND OTHER FU IN HU"     
      ER28061             FORMAT=1.   LABEL="REL OF 2ND OTHER FU"                     
      ER28062             FORMAT=2.   LABEL="SIZE OF 2ND OTHER FU"                    
      ER28063             FORMAT=5.   LABEL="CURRENT YR ID OF 3RD OTHER FU IN HU"     
      ER28064             FORMAT=1.   LABEL="REL OF 3RD OTHER FU"                     
      ER28065             FORMAT=2.   LABEL="SIZE OF 3RD OTHER FU"                    
      ER28066             FORMAT=5.   LABEL="CURRENT YR ID OF 4TH OTHER FU IN HU"     
      ER28067             FORMAT=1.   LABEL="REL OF 4TH OTHER FU"                     
      ER28068             FORMAT=2.   LABEL="SIZE OF 4TH OTHER FU"                    
      ER28069             FORMAT=5.   LABEL="HOUSEHOLD ID #"                          
      ER28070             FORMAT=1.   LABEL="BIRTHS TO HEAD ONLY-2004"                
      ER28071             FORMAT=1.   LABEL="BIRTHS TO WIFE ONLY-2004"                
      ER28072             FORMAT=1.   LABEL="BIRTHS TO HEAD AND WIFE-2004"            
      ER28073             FORMAT=1.   LABEL="BIRTHS TO OFUMS ONLY-2004"               
      ER28074             FORMAT=1.   LABEL="BIRTHS TO HEAD ONLY-2003"                
      ER28075             FORMAT=1.   LABEL="BIRTHS TO WIFE ONLY-2003"                
      ER28076             FORMAT=1.   LABEL="BIRTHS TO HEAD AND WIFE-2003"            
      ER28077             FORMAT=1.   LABEL="BIRTHS TO OFUMS ONLY-2003"               
      ER28078             FORMAT=7.3  LABEL="2005 CORE/IMMIGRANT FAM WEIGHT NUMBER 1" 
   ;
   infile 'F:\PSID\FAM2005ER.txt'  lrecl=6224 missover;
   INPUT 
      ER25001      1 - 1      ER25002      2 - 6      ER25003      7 - 8    
      ER25004      9 - 10     ER25005     11 - 11     ER25006     12 - 12   
      ER25007     13 - 13     ER25008     14 - 14     ER25009     15 - 18   
      ER25010     19 - 19     ER25011     20 - 27     ER25012     28 - 29   
      ER25013     30 - 31     ER25014     32 - 35     ER25015     36 - 38   
      ER25016     39 - 40     ER25017     41 - 43     ER25018     44 - 44   
      ER25019     45 - 47     ER25020     48 - 49     ER25021     50 - 52   
      ER25022     53 - 54     ER25023     55 - 55     ER25024     56 - 56   
      ER25025     57 - 57     ER25026     58 - 58     ER25027     59 - 60   
      ER25028     61 - 61     ER25029     62 - 68     ER25030     69 - 69   
      ER25031     70 - 70     ER25032     71 - 71     ER25033     72 - 72   
      ER25034     73 - 73     ER25035     74 - 74     ER25036     75 - 79   
      ER25037     80 - 80     ER25038     81 - 84     ER25039     85 - 85   
      ER25040     86 - 86     ER25041     87 - 87     ER25042     88 - 94   
      ER25043     95 - 95     ER25044     96 - 100    ER25045    101 - 101  
      ER25046    102 - 103    ER25047    104 - 106    ER25048    107 - 110  
      ER25049    111 - 112    ER25050    113 - 113    ER25051    114 - 114  
      ER25052    115 - 115    ER25053    116 - 122    ER25054    123 - 123  
      ER25055    124 - 128    ER25056    129 - 129    ER25057    130 - 131  
      ER25058    132 - 134    ER25059    135 - 138    ER25060    139 - 140  
      ER25061    141 - 141    ER25062    142 - 142    ER25063    143 - 147  
      ER25064    148 - 148    ER25065    149 - 149    ER25066    150 - 150  
      ER25067    151 - 151    ER25068    152 - 152    ER25069    153 - 153  
      ER25070    154 - 157    ER25071    158 - 158    ER25072    159 - 159  
      ER25073    160 - 160    ER25074    161 - 161    ER25075    162 - 162  
      ER25076    163 - 163    ER25077    164 - 165    ER25078    166 - 167  
      ER25079    168 - 169    ER25080    170 - 173    ER25081    174 - 174  
      ER25082    175 - 178    ER25083    179 - 179    ER25084    180 - 183  
      ER25085    184 - 184    ER25086    185 - 188    ER25087    189 - 189  
      ER25088    190 - 190    ER25089    191 - 191    ER25090    192 - 194  
      ER25091    195 - 195    ER25092    196 - 196    ER25093    197 - 200  
      ER25094    201 - 201    ER25095    202 - 202    ER25096    203 - 203  
      ER25097    204 - 204    ER25098    205 - 205    ER25099    206 - 207  
      ER25100    208 - 211    ER25101    212 - 213    ER25102    214 - 214  
      ER25103    215 - 215    ER25104    216 - 217    ER25105    218 - 219  
      ER25106    220 - 221    ER25107    222 - 225    ER25108    226 - 226  
      ER25109    227 - 227    ER25110    228 - 228    ER25111    229 - 230  
      ER25112    231 - 234    ER25113    235 - 236    ER25114    237 - 240  
      ER25115    241 - 241    ER25116    242 - 242    ER25117    243 - 243  
      ER25118    244 - 244    ER25119    245 - 245    ER25120    246 - 246  
      ER25121    247 - 247    ER25122    248 - 248    ER25123    249 - 249  
      ER25124    250 - 250    ER25125    251 - 251    ER25126    252 - 252  
      ER25127    253 - 255    ER25128    256 - 258    ER25129    259 - 259  
      ER25130    260 - 260    ER25131    261 - 261    ER25132    262 - 270  
      ER25133    271 - 271    ER25134    272 - 272    ER25135    273 - 273  
      ER25136    274 - 274    ER25137    275 - 275    ER25138    276 - 276  
      ER25139    277 - 277    ER25140    278 - 278    ER25141    279 - 279  
      ER25142    280 - 289    ER25143    290 - 290    ER25144    291 - 291  
      ER25145    292 - 292    ER25146    293 - 302    ER25147    303 - 303  
      ER25148    304 - 309    ER25149    310 - 310    ER25150    311 - 311  
      ER25151    312 - 312    ER25152    313 - 322    ER25153    323 - 323  
      ER25154    324 - 331    ER25155    332 - 332    ER25156    333 - 339  
      ER25157    340 - 340    ER25158    341 - 341    ER25159    342 - 350  
      ER25160    351 - 352    ER25161    353 - 354    ER25162    355 - 356  
      ER25163    357 - 358    ER25164    359 - 359    ER25165    360 - 362  
      ER25166    363 - 363    ER25167    364 - 364    ER25168    365 - 368  
      ER25169    369 - 369    ER25170    370 - 370    ER25171    371 - 380  
      ER25172    381 - 381    ER25173    382 - 382    ER25174    383 - 384  
      ER25175    385 - 388    ER25176    389 - 390    ER25177    391 - 394  
      ER25178    395 - 395    ER25179    396 - 396    ER25180    397 - 397  
      ER25181    398 - 398    ER25182    399 - 399    ER25183    400 - 400  
      ER25184    401 - 401    ER25185    402 - 402    ER25186    403 - 403  
      ER25187    404 - 404    ER25188    405 - 405    ER25189    406 - 406  
      ER25190    407 - 409    ER25191    410 - 412    ER25192    413 - 413  
      ER25193    414 - 414    ER25194    415 - 415    ER25195    416 - 417  
      ER25196    418 - 418    ER25197    419 - 421    ER25198    422 - 422  
      ER25199    423 - 423    ER25200    424 - 427    ER25201    428 - 428  
      ER25202    429 - 429    ER25203    430 - 439    ER25204    440 - 440  
      ER25205    441 - 441    ER25206    442 - 443    ER25207    444 - 447  
      ER25208    448 - 449    ER25209    450 - 453    ER25210    454 - 454  
      ER25211    455 - 455    ER25212    456 - 456    ER25213    457 - 457  
      ER25214    458 - 458    ER25215    459 - 459    ER25216    460 - 460  
      ER25217    461 - 461    ER25218    462 - 462    ER25219    463 - 463  
      ER25220    464 - 464    ER25221    465 - 465    ER25222    466 - 468  
      ER25223    469 - 471    ER25224    472 - 472    ER25225    473 - 473  
      ER25226    474 - 474    ER25227    475 - 476    ER25228    477 - 477  
      ER25229    478 - 480    ER25230    481 - 481    ER25231    482 - 482  
      ER25232    483 - 486    ER25233    487 - 487    ER25234    488 - 488  
      ER25235    489 - 498    ER25236    499 - 499    ER25237    500 - 500  
      ER25238    501 - 502    ER25239    503 - 506    ER25240    507 - 508  
      ER25241    509 - 512    ER25242    513 - 513    ER25243    514 - 514  
      ER25244    515 - 515    ER25245    516 - 516    ER25246    517 - 517  
      ER25247    518 - 518    ER25248    519 - 519    ER25249    520 - 520  
      ER25250    521 - 521    ER25251    522 - 522    ER25252    523 - 523  
      ER25253    524 - 524    ER25254    525 - 527    ER25255    528 - 530  
      ER25256    531 - 531    ER25257    532 - 532    ER25258    533 - 533  
      ER25259    534 - 535    ER25260    536 - 536    ER25261    537 - 539  
      ER25262    540 - 540    ER25263    541 - 541    ER25264    542 - 545  
      ER25265    546 - 546    ER25266    547 - 547    ER25267    548 - 557  
      ER25268    558 - 558    ER25269    559 - 559    ER25270    560 - 560  
      ER25271    561 - 561    ER25272    562 - 564    ER25273    565 - 565  
      ER25274    566 - 567    ER25275    568 - 568    ER25276    569 - 570  
      ER25277    571 - 571    ER25278    572 - 572    ER25279    573 - 575  
      ER25280    576 - 576    ER25281    577 - 578    ER25282    579 - 579  
      ER25283    580 - 581    ER25284    582 - 582    ER25285    583 - 583  
      ER25286    584 - 586    ER25287    587 - 587    ER25288    588 - 589  
      ER25289    590 - 590    ER25290    591 - 592    ER25291    593 - 593  
      ER25292    594 - 594    ER25293    595 - 597    ER25294    598 - 598  
      ER25295    599 - 600    ER25296    601 - 601    ER25297    602 - 603  
      ER25298    604 - 604    ER25299    605 - 605    ER25300    606 - 608  
      ER25301    609 - 609    ER25302    610 - 611    ER25303    612 - 612  
      ER25304    613 - 614    ER25305    615 - 615    ER25306    616 - 616  
      ER25307    617 - 619    ER25308    620 - 620    ER25309    621 - 622  
      ER25310    623 - 623    ER25311    624 - 625    ER25312    626 - 626  
      ER25313    627 - 627    ER25314    628 - 628    ER25315    629 - 629  
      ER25316    630 - 630    ER25317    631 - 631    ER25318    632 - 632  
      ER25319    633 - 633    ER25320    634 - 634    ER25321    635 - 635  
      ER25322    636 - 636    ER25323    637 - 637    ER25324    638 - 638  
      ER25325    639 - 639    ER25326    640 - 642    ER25327    643 - 643  
      ER25328    644 - 645    ER25329    646 - 646    ER25330    647 - 648  
      ER25331    649 - 649    ER25332    650 - 650    ER25333    651 - 651  
      ER25334    652 - 652    ER25335    653 - 653    ER25336    654 - 654  
      ER25337    655 - 655    ER25338    656 - 656    ER25339    657 - 657  
      ER25340    658 - 658    ER25341    659 - 659    ER25342    660 - 660  
      ER25343    661 - 661    ER25344    662 - 663    ER25345    664 - 666  
      ER25346    667 - 667    ER25347    668 - 669    ER25348    670 - 673  
      ER25349    674 - 674    ER25350    675 - 675    ER25351    676 - 676  
      ER25352    677 - 677    ER25353    678 - 678    ER25354    679 - 679  
      ER25355    680 - 680    ER25356    681 - 681    ER25357    682 - 682  
      ER25358    683 - 684    ER25359    685 - 686    ER25360    687 - 688  
      ER25361    689 - 689    ER25362    690 - 691    ER25363    692 - 693  
      ER25364    694 - 695    ER25365    696 - 699    ER25366    700 - 700  
      ER25367    701 - 701    ER25368    702 - 702    ER25369    703 - 704  
      ER25370    705 - 708    ER25371    709 - 710    ER25372    711 - 714  
      ER25373    715 - 715    ER25374    716 - 716    ER25375    717 - 717  
      ER25376    718 - 718    ER25377    719 - 719    ER25378    720 - 720  
      ER25379    721 - 721    ER25380    722 - 722    ER25381    723 - 723  
      ER25382    724 - 724    ER25383    725 - 725    ER25384    726 - 726  
      ER25385    727 - 729    ER25386    730 - 732    ER25387    733 - 733  
      ER25388    734 - 734    ER25389    735 - 735    ER25390    736 - 744  
      ER25391    745 - 745    ER25392    746 - 746    ER25393    747 - 747  
      ER25394    748 - 748    ER25395    749 - 749    ER25396    750 - 750  
      ER25397    751 - 751    ER25398    752 - 752    ER25399    753 - 753  
      ER25400    754 - 763    ER25401    764 - 764    ER25402    765 - 765  
      ER25403    766 - 766    ER25404    767 - 776    ER25405    777 - 777  
      ER25406    778 - 783    ER25407    784 - 784    ER25408    785 - 785  
      ER25409    786 - 786    ER25410    787 - 796    ER25411    797 - 797  
      ER25412    798 - 805    ER25413    806 - 806    ER25414    807 - 813  
      ER25415    814 - 814    ER25416    815 - 815    ER25417    816 - 824  
      ER25418    825 - 826    ER25419    827 - 828    ER25420    829 - 830  
      ER25421    831 - 832    ER25422    833 - 833    ER25423    834 - 836  
      ER25424    837 - 837    ER25425    838 - 838    ER25426    839 - 842  
      ER25427    843 - 843    ER25428    844 - 844    ER25429    845 - 854  
      ER25430    855 - 855    ER25431    856 - 856    ER25432    857 - 858  
      ER25433    859 - 862    ER25434    863 - 864    ER25435    865 - 868  
      ER25436    869 - 869    ER25437    870 - 870    ER25438    871 - 871  
      ER25439    872 - 872    ER25440    873 - 873    ER25441    874 - 874  
      ER25442    875 - 875    ER25443    876 - 876    ER25444    877 - 877  
      ER25445    878 - 878    ER25446    879 - 879    ER25447    880 - 880  
      ER25448    881 - 883    ER25449    884 - 886    ER25450    887 - 887  
      ER25451    888 - 888    ER25452    889 - 889    ER25453    890 - 891  
      ER25454    892 - 892    ER25455    893 - 895    ER25456    896 - 896  
      ER25457    897 - 897    ER25458    898 - 901    ER25459    902 - 902  
      ER25460    903 - 903    ER25461    904 - 913    ER25462    914 - 914  
      ER25463    915 - 915    ER25464    916 - 917    ER25465    918 - 921  
      ER25466    922 - 923    ER25467    924 - 927    ER25468    928 - 928  
      ER25469    929 - 929    ER25470    930 - 930    ER25471    931 - 931  
      ER25472    932 - 932    ER25473    933 - 933    ER25474    934 - 934  
      ER25475    935 - 935    ER25476    936 - 936    ER25477    937 - 937  
      ER25478    938 - 938    ER25479    939 - 939    ER25480    940 - 942  
      ER25481    943 - 945    ER25482    946 - 946    ER25483    947 - 947  
      ER25484    948 - 948    ER25485    949 - 950    ER25486    951 - 951  
      ER25487    952 - 954    ER25488    955 - 955    ER25489    956 - 956  
      ER25490    957 - 960    ER25491    961 - 961    ER25492    962 - 962  
      ER25493    963 - 972    ER25494    973 - 973    ER25495    974 - 974  
      ER25496    975 - 976    ER25497    977 - 980    ER25498    981 - 982  
      ER25499    983 - 986    ER25500    987 - 987    ER25501    988 - 988  
      ER25502    989 - 989    ER25503    990 - 990    ER25504    991 - 991  
      ER25505    992 - 992    ER25506    993 - 993    ER25507    994 - 994  
      ER25508    995 - 995    ER25509    996 - 996    ER25510    997 - 997  
      ER25511    998 - 998    ER25512    999 - 1001   ER25513   1002 - 1004 
      ER25514   1005 - 1005   ER25515   1006 - 1006   ER25516   1007 - 1007 
      ER25517   1008 - 1009   ER25518   1010 - 1010   ER25519   1011 - 1013 
      ER25520   1014 - 1014   ER25521   1015 - 1015   ER25522   1016 - 1019 
      ER25523   1020 - 1020   ER25524   1021 - 1021   ER25525   1022 - 1031 
      ER25526   1032 - 1032   ER25527   1033 - 1033   ER25528   1034 - 1034 
      ER25529   1035 - 1035   ER25530   1036 - 1038   ER25531   1039 - 1039 
      ER25532   1040 - 1041   ER25533   1042 - 1042   ER25534   1043 - 1044 
      ER25535   1045 - 1045   ER25536   1046 - 1046   ER25537   1047 - 1049 
      ER25538   1050 - 1050   ER25539   1051 - 1052   ER25540   1053 - 1053 
      ER25541   1054 - 1055   ER25542   1056 - 1056   ER25543   1057 - 1057 
      ER25544   1058 - 1060   ER25545   1061 - 1061   ER25546   1062 - 1063 
      ER25547   1064 - 1064   ER25548   1065 - 1066   ER25549   1067 - 1067 
      ER25550   1068 - 1068   ER25551   1069 - 1071   ER25552   1072 - 1072 
      ER25553   1073 - 1074   ER25554   1075 - 1075   ER25555   1076 - 1077 
      ER25556   1078 - 1078   ER25557   1079 - 1079   ER25558   1080 - 1082 
      ER25559   1083 - 1083   ER25560   1084 - 1085   ER25561   1086 - 1086 
      ER25562   1087 - 1088   ER25563   1089 - 1089   ER25564   1090 - 1090 
      ER25565   1091 - 1093   ER25566   1094 - 1094   ER25567   1095 - 1096 
      ER25568   1097 - 1097   ER25569   1098 - 1099   ER25570   1100 - 1100 
      ER25571   1101 - 1101   ER25572   1102 - 1102   ER25573   1103 - 1103 
      ER25574   1104 - 1104   ER25575   1105 - 1105   ER25576   1106 - 1106 
      ER25577   1107 - 1107   ER25578   1108 - 1108   ER25579   1109 - 1109 
      ER25580   1110 - 1110   ER25581   1111 - 1111   ER25582   1112 - 1112 
      ER25583   1113 - 1113   ER25584   1114 - 1116   ER25585   1117 - 1117 
      ER25586   1118 - 1119   ER25587   1120 - 1120   ER25588   1121 - 1122 
      ER25589   1123 - 1123   ER25590   1124 - 1124   ER25591   1125 - 1125 
      ER25592   1126 - 1126   ER25593   1127 - 1127   ER25594   1128 - 1128 
      ER25595   1129 - 1129   ER25596   1130 - 1130   ER25597   1131 - 1131 
      ER25598   1132 - 1132   ER25599   1133 - 1133   ER25600   1134 - 1134 
      ER25601   1135 - 1135   ER25602   1136 - 1137   ER25603   1138 - 1140 
      ER25604   1141 - 1141   ER25605   1142 - 1143   ER25606   1144 - 1147 
      ER25607   1148 - 1148   ER25608   1149 - 1149   ER25609   1150 - 1150 
      ER25610   1151 - 1151   ER25611   1152 - 1152   ER25612   1153 - 1153 
      ER25613   1154 - 1154   ER25614   1155 - 1155   ER25615   1156 - 1156 
      ER25616   1157 - 1158   ER25617   1159 - 1160   ER25618   1161 - 1162 
      ER25619   1163 - 1163   ER25620   1164 - 1166   ER25621   1167 - 1167 
      ER25622   1168 - 1170   ER25623   1171 - 1171   ER25624   1172 - 1172 
      ER25625   1173 - 1173   ER25626   1174 - 1174   ER25627   1175 - 1175 
      ER25628   1176 - 1181   ER25629   1182 - 1182   ER25630   1183 - 1183 
      ER25631   1184 - 1184   ER25632   1185 - 1185   ER25633   1186 - 1186 
      ER25634   1187 - 1187   ER25635   1188 - 1193   ER25636   1194 - 1194 
      ER25637   1195 - 1195   ER25638   1196 - 1196   ER25639   1197 - 1202 
      ER25640   1203 - 1203   ER25641   1204 - 1204   ER25642   1205 - 1205 
      ER25643   1206 - 1206   ER25644   1207 - 1207   ER25645   1208 - 1208 
      ER25646   1209 - 1209   ER25647   1210 - 1210   ER25648   1211 - 1211 
      ER25649   1212 - 1212   ER25650   1213 - 1213   ER25651   1214 - 1214 
      ER25652   1215 - 1215   ER25653   1216 - 1216   ER25654   1217 - 1217 
      ER25655   1218 - 1223   ER25656   1224 - 1224   ER25657   1225 - 1225 
      ER25658   1226 - 1226   ER25659   1227 - 1227   ER25660   1228 - 1228 
      ER25661   1229 - 1229   ER25662   1230 - 1230   ER25663   1231 - 1231 
      ER25664   1232 - 1232   ER25665   1233 - 1233   ER25666   1234 - 1234 
      ER25667   1235 - 1235   ER25668   1236 - 1236   ER25669   1237 - 1237 
      ER25670   1238 - 1238   ER25671   1239 - 1239   ER25672   1240 - 1240 
      ER25673   1241 - 1241   ER25674   1242 - 1242   ER25675   1243 - 1243 
      ER25676   1244 - 1244   ER25677   1245 - 1245   ER25678   1246 - 1246 
      ER25679   1247 - 1247   ER25680   1248 - 1248   ER25681   1249 - 1249 
      ER25682   1250 - 1250   ER25683   1251 - 1251   ER25684   1252 - 1257 
      ER25685   1258 - 1258   ER25686   1259 - 1259   ER25687   1260 - 1260 
      ER25688   1261 - 1268   ER25689   1269 - 1269   ER25690   1270 - 1270 
      ER25691   1271 - 1271   ER25692   1272 - 1279   ER25693   1280 - 1280 
      ER25694   1281 - 1281   ER25695   1282 - 1289   ER25696   1290 - 1290 
      ER25697   1291 - 1291   ER25698   1292 - 1299   ER25699   1300 - 1300 
      ER25700   1301 - 1301   ER25701   1302 - 1302   ER25702   1303 - 1310 
      ER25703   1311 - 1311   ER25704   1312 - 1312   ER25705   1313 - 1320 
      ER25706   1321 - 1321   ER25707   1322 - 1322   ER25708   1323 - 1323 
      ER25709   1324 - 1325   ER25710   1326 - 1327   ER25711   1328 - 1329 
      ER25712   1330 - 1333   ER25713   1334 - 1334   ER25714   1335 - 1335 
      ER25715   1336 - 1337   ER25716   1338 - 1338   ER25717   1339 - 1339 
      ER25718   1340 - 1343   ER25719   1344 - 1345   ER25720   1346 - 1346 
      ER25721   1347 - 1347   ER25722   1348 - 1348   ER25723   1349 - 1354 
      ER25724   1355 - 1355   ER25725   1356 - 1361   ER25726   1362 - 1367 
      ER25727   1368 - 1368   ER25728   1369 - 1374   ER25729   1375 - 1380 
      ER25730   1381 - 1381   ER25731   1382 - 1384   ER25732   1385 - 1387 
      ER25733   1388 - 1393   ER25734   1394 - 1399   ER25735   1400 - 1400 
      ER25736   1401 - 1403   ER25737   1404 - 1406   ER25738   1407 - 1408 
      ER25739   1409 - 1410   ER25740   1411 - 1414   ER25741   1415 - 1415 
      ER25742   1416 - 1416   ER25743   1417 - 1418   ER25744   1419 - 1419 
      ER25745   1420 - 1420   ER25746   1421 - 1424   ER25747   1425 - 1426 
      ER25748   1427 - 1427   ER25749   1428 - 1428   ER25750   1429 - 1429 
      ER25751   1430 - 1435   ER25752   1436 - 1436   ER25753   1437 - 1442 
      ER25754   1443 - 1448   ER25755   1449 - 1449   ER25756   1450 - 1455 
      ER25757   1456 - 1461   ER25758   1462 - 1462   ER25759   1463 - 1465 
      ER25760   1466 - 1468   ER25761   1469 - 1474   ER25762   1475 - 1480 
      ER25763   1481 - 1481   ER25764   1482 - 1484   ER25765   1485 - 1487 
      ER25766   1488 - 1489   ER25767   1490 - 1491   ER25768   1492 - 1495 
      ER25769   1496 - 1496   ER25770   1497 - 1497   ER25771   1498 - 1499 
      ER25772   1500 - 1500   ER25773   1501 - 1501   ER25774   1502 - 1505 
      ER25775   1506 - 1507   ER25776   1508 - 1508   ER25777   1509 - 1509 
      ER25778   1510 - 1510   ER25779   1511 - 1516   ER25780   1517 - 1517 
      ER25781   1518 - 1523   ER25782   1524 - 1529   ER25783   1530 - 1530 
      ER25784   1531 - 1536   ER25785   1537 - 1542   ER25786   1543 - 1543 
      ER25787   1544 - 1546   ER25788   1547 - 1549   ER25789   1550 - 1555 
      ER25790   1556 - 1561   ER25791   1562 - 1562   ER25792   1563 - 1565 
      ER25793   1566 - 1568   ER25794   1569 - 1574   ER25795   1575 - 1575 
      ER25796   1576 - 1576   ER25797   1577 - 1582   ER25798   1583 - 1587 
      ER25799   1588 - 1592   ER25800   1593 - 1597   ER25801   1598 - 1602 
      ER25802   1603 - 1607   ER25803   1608 - 1612   ER25804   1613 - 1613 
      ER25805   1614 - 1619   ER25806   1620 - 1620   ER25807   1621 - 1626 
      ER25808   1627 - 1632   ER25809   1633 - 1633   ER25810   1634 - 1634 
      ER25811   1635 - 1635   ER25812   1636 - 1636   ER25813   1637 - 1642 
      ER25814   1643 - 1643   ER25815   1644 - 1644   ER25816   1645 - 1645 
      ER25817   1646 - 1646   ER25818   1647 - 1652   ER25819   1653 - 1653 
      ER25820   1654 - 1654   ER25821   1655 - 1655   ER25822   1656 - 1656 
      ER25823   1657 - 1662   ER25824   1663 - 1663   ER25825   1664 - 1664 
      ER25826   1665 - 1665   ER25827   1666 - 1666   ER25828   1667 - 1672 
      ER25829   1673 - 1673   ER25830   1674 - 1674   ER25831   1675 - 1675 
      ER25832   1676 - 1676   ER25833   1677 - 1677   ER25834   1678 - 1684 
      ER25835   1685 - 1691   ER25836   1692 - 1698   ER25837   1699 - 1699 
      ER25838   1700 - 1700   ER25839   1701 - 1702   ER25840   1703 - 1703 
      ER25841   1704 - 1704   ER25842   1705 - 1705   ER25843   1706 - 1706 
      ER25844   1707 - 1708   ER25845   1709 - 1710   ER25846   1711 - 1712 
      ER25847   1713 - 1714   ER25848   1715 - 1715   ER25849   1716 - 1722 
      ER25850   1723 - 1729   ER25851   1730 - 1736   ER25852   1737 - 1737 
      ER25853   1738 - 1739   ER25854   1740 - 1740   ER25855   1741 - 1741 
      ER25856   1742 - 1742   ER25857   1743 - 1743   ER25858   1744 - 1745 
      ER25859   1746 - 1747   ER25860   1748 - 1749   ER25861   1750 - 1751 
      ER25862   1752 - 1752   ER25863   1753 - 1759   ER25864   1760 - 1766 
      ER25865   1767 - 1773   ER25866   1774 - 1774   ER25867   1775 - 1776 
      ER25868   1777 - 1777   ER25869   1778 - 1778   ER25870   1779 - 1779 
      ER25871   1780 - 1780   ER25872   1781 - 1782   ER25873   1783 - 1784 
      ER25874   1785 - 1786   ER25875   1787 - 1788   ER25876   1789 - 1789 
      ER25877   1790 - 1796   ER25878   1797 - 1803   ER25879   1804 - 1810 
      ER25880   1811 - 1811   ER25881   1812 - 1813   ER25882   1814 - 1814 
      ER25883   1815 - 1815   ER25884   1816 - 1816   ER25885   1817 - 1817 
      ER25886   1818 - 1819   ER25887   1820 - 1821   ER25888   1822 - 1823 
      ER25889   1824 - 1825   ER25890   1826 - 1826   ER25891   1827 - 1833 
      ER25892   1834 - 1840   ER25893   1841 - 1847   ER25894   1848 - 1848 
      ER25895   1849 - 1850   ER25896   1851 - 1851   ER25897   1852 - 1852 
      ER25898   1853 - 1853   ER25899   1854 - 1854   ER25900   1855 - 1856 
      ER25901   1857 - 1858   ER25902   1859 - 1860   ER25903   1861 - 1862 
      ER25904   1863 - 1863   ER25905   1864 - 1870   ER25906   1871 - 1877 
      ER25907   1878 - 1884   ER25908   1885 - 1885   ER25909   1886 - 1886 
      ER25910   1887 - 1893   ER25911   1894 - 1894   ER25912   1895 - 1895 
      ER25913   1896 - 1896   ER25914   1897 - 1902   ER25915   1903 - 1903 
      ER25916   1904 - 1904   ER25917   1905 - 1910   ER25918   1911 - 1911 
      ER25919   1912 - 1912   ER25920   1913 - 1918   ER25921   1919 - 1919 
      ER25922   1920 - 1920   ER25923   1921 - 1926   ER25924   1927 - 1927 
      ER25925   1928 - 1928   ER25926   1929 - 1934   ER25927   1935 - 1935 
      ER25928   1936 - 1936   ER25929   1937 - 1937   ER25930   1938 - 1944 
      ER25931   1945 - 1945   ER25932   1946 - 1946   ER25933   1947 - 1947 
      ER25934   1948 - 1948   ER25935   1949 - 1949   ER25936   1950 - 1950 
      ER25937   1951 - 1951   ER25938   1952 - 1952   ER25939   1953 - 1953 
      ER25940   1954 - 1954   ER25941   1955 - 1955   ER25942   1956 - 1956 
      ER25943   1957 - 1957   ER25944   1958 - 1958   ER25945   1959 - 1959 
      ER25946   1960 - 1960   ER25947   1961 - 1967   ER25948   1968 - 1968 
      ER25949   1969 - 1969   ER25950   1970 - 1970   ER25951   1971 - 1971 
      ER25952   1972 - 1972   ER25953   1973 - 1973   ER25954   1974 - 1974 
      ER25955   1975 - 1975   ER25956   1976 - 1976   ER25957   1977 - 1977 
      ER25958   1978 - 1978   ER25959   1979 - 1979   ER25960   1980 - 1980 
      ER25961   1981 - 1981   ER25962   1982 - 1982   ER25963   1983 - 1983 
      ER25964   1984 - 1990   ER25965   1991 - 1991   ER25966   1992 - 1992 
      ER25967   1993 - 1993   ER25968   1994 - 1994   ER25969   1995 - 1995 
      ER25970   1996 - 1996   ER25971   1997 - 1997   ER25972   1998 - 1998 
      ER25973   1999 - 1999   ER25974   2000 - 2000   ER25975   2001 - 2001 
      ER25976   2002 - 2002   ER25977   2003 - 2003   ER25978   2004 - 2004 
      ER25979   2005 - 2005   ER25980   2006 - 2006   ER25981   2007 - 2013 
      ER25982   2014 - 2014   ER25983   2015 - 2015   ER25984   2016 - 2021 
      ER25985   2022 - 2022   ER25986   2023 - 2023   ER25987   2024 - 2024 
      ER25988   2025 - 2025   ER25989   2026 - 2026   ER25990   2027 - 2027 
      ER25991   2028 - 2028   ER25992   2029 - 2029   ER25993   2030 - 2030 
      ER25994   2031 - 2031   ER25995   2032 - 2032   ER25996   2033 - 2033 
      ER25997   2034 - 2034   ER25998   2035 - 2035   ER25999   2036 - 2036 
      ER26000   2037 - 2037   ER26001   2038 - 2043   ER26002   2044 - 2044 
      ER26003   2045 - 2045   ER26004   2046 - 2046   ER26005   2047 - 2047 
      ER26006   2048 - 2048   ER26007   2049 - 2049   ER26008   2050 - 2050 
      ER26009   2051 - 2051   ER26010   2052 - 2052   ER26011   2053 - 2053 
      ER26012   2054 - 2054   ER26013   2055 - 2055   ER26014   2056 - 2056 
      ER26015   2057 - 2057   ER26016   2058 - 2058   ER26017   2059 - 2059 
      ER26018   2060 - 2065   ER26019   2066 - 2066   ER26020   2067 - 2067 
      ER26021   2068 - 2068   ER26022   2069 - 2069   ER26023   2070 - 2070 
      ER26024   2071 - 2071   ER26025   2072 - 2072   ER26026   2073 - 2073 
      ER26027   2074 - 2074   ER26028   2075 - 2075   ER26029   2076 - 2076 
      ER26030   2077 - 2077   ER26031   2078 - 2078   ER26032   2079 - 2079 
      ER26033   2080 - 2080   ER26034   2081 - 2081   ER26035   2082 - 2087 
      ER26036   2088 - 2088   ER26037   2089 - 2089   ER26038   2090 - 2090 
      ER26039   2091 - 2091   ER26040   2092 - 2092   ER26041   2093 - 2093 
      ER26042   2094 - 2094   ER26043   2095 - 2095   ER26044   2096 - 2096 
      ER26045   2097 - 2097   ER26046   2098 - 2098   ER26047   2099 - 2099 
      ER26048   2100 - 2100   ER26049   2101 - 2101   ER26050   2102 - 2102 
      ER26051   2103 - 2108   ER26052   2109 - 2109   ER26053   2110 - 2110 
      ER26054   2111 - 2111   ER26055   2112 - 2112   ER26056   2113 - 2113 
      ER26057   2114 - 2114   ER26058   2115 - 2115   ER26059   2116 - 2116 
      ER26060   2117 - 2117   ER26061   2118 - 2118   ER26062   2119 - 2119 
      ER26063   2120 - 2120   ER26064   2121 - 2121   ER26065   2122 - 2122 
      ER26066   2123 - 2123   ER26067   2124 - 2124   ER26068   2125 - 2130 
      ER26069   2131 - 2131   ER26070   2132 - 2132   ER26071   2133 - 2133 
      ER26072   2134 - 2134   ER26073   2135 - 2135   ER26074   2136 - 2136 
      ER26075   2137 - 2137   ER26076   2138 - 2138   ER26077   2139 - 2139 
      ER26078   2140 - 2140   ER26079   2141 - 2141   ER26080   2142 - 2142 
      ER26081   2143 - 2143   ER26082   2144 - 2144   ER26083   2145 - 2145 
      ER26084   2146 - 2151   ER26085   2152 - 2152   ER26086   2153 - 2153 
      ER26087   2154 - 2154   ER26088   2155 - 2155   ER26089   2156 - 2156 
      ER26090   2157 - 2157   ER26091   2158 - 2158   ER26092   2159 - 2159 
      ER26093   2160 - 2160   ER26094   2161 - 2161   ER26095   2162 - 2162 
      ER26096   2163 - 2163   ER26097   2164 - 2164   ER26098   2165 - 2165 
      ER26099   2166 - 2166   ER26100   2167 - 2167   ER26101   2168 - 2173 
      ER26102   2174 - 2174   ER26103   2175 - 2175   ER26104   2176 - 2176 
      ER26105   2177 - 2177   ER26106   2178 - 2178   ER26107   2179 - 2179 
      ER26108   2180 - 2180   ER26109   2181 - 2181   ER26110   2182 - 2182 
      ER26111   2183 - 2183   ER26112   2184 - 2184   ER26113   2185 - 2185 
      ER26114   2186 - 2186   ER26115   2187 - 2187   ER26116   2188 - 2188 
      ER26117   2189 - 2194   ER26118   2195 - 2195   ER26119   2196 - 2196 
      ER26120   2197 - 2197   ER26121   2198 - 2198   ER26122   2199 - 2199 
      ER26123   2200 - 2200   ER26124   2201 - 2201   ER26125   2202 - 2202 
      ER26126   2203 - 2203   ER26127   2204 - 2204   ER26128   2205 - 2205 
      ER26129   2206 - 2206   ER26130   2207 - 2207   ER26131   2208 - 2208 
      ER26132   2209 - 2209   ER26133   2210 - 2215   ER26134   2216 - 2216 
      ER26135   2217 - 2217   ER26136   2218 - 2218   ER26137   2219 - 2219 
      ER26138   2220 - 2220   ER26139   2221 - 2221   ER26140   2222 - 2222 
      ER26141   2223 - 2223   ER26142   2224 - 2224   ER26143   2225 - 2225 
      ER26144   2226 - 2226   ER26145   2227 - 2227   ER26146   2228 - 2228 
      ER26147   2229 - 2229   ER26148   2230 - 2230   ER26149   2231 - 2236 
      ER26150   2237 - 2237   ER26151   2238 - 2238   ER26152   2239 - 2239 
      ER26153   2240 - 2240   ER26154   2241 - 2241   ER26155   2242 - 2242 
      ER26156   2243 - 2243   ER26157   2244 - 2244   ER26158   2245 - 2245 
      ER26159   2246 - 2246   ER26160   2247 - 2247   ER26161   2248 - 2248 
      ER26162   2249 - 2249   ER26163   2250 - 2250   ER26164   2251 - 2251 
      ER26165   2252 - 2252   ER26166   2253 - 2258   ER26167   2259 - 2259 
      ER26168   2260 - 2260   ER26169   2261 - 2261   ER26170   2262 - 2262 
      ER26171   2263 - 2263   ER26172   2264 - 2264   ER26173   2265 - 2265 
      ER26174   2266 - 2266   ER26175   2267 - 2267   ER26176   2268 - 2268 
      ER26177   2269 - 2269   ER26178   2270 - 2270   ER26179   2271 - 2271 
      ER26180   2272 - 2272   ER26181   2273 - 2273   ER26182   2274 - 2279 
      ER26183   2280 - 2280   ER26184   2281 - 2281   ER26185   2282 - 2282 
      ER26186   2283 - 2283   ER26187   2284 - 2284   ER26188   2285 - 2285 
      ER26189   2286 - 2286   ER26190   2287 - 2287   ER26191   2288 - 2288 
      ER26192   2289 - 2289   ER26193   2290 - 2290   ER26194   2291 - 2291 
      ER26195   2292 - 2292   ER26196   2293 - 2293   ER26197   2294 - 2294 
      ER26198   2295 - 2300   ER26199   2301 - 2301   ER26200   2302 - 2302 
      ER26201   2303 - 2303   ER26202   2304 - 2304   ER26203   2305 - 2305 
      ER26204   2306 - 2306   ER26205   2307 - 2307   ER26206   2308 - 2308 
      ER26207   2309 - 2309   ER26208   2310 - 2310   ER26209   2311 - 2311 
      ER26210   2312 - 2312   ER26211   2313 - 2313   ER26212   2314 - 2314 
      ER26213   2315 - 2315   ER26214   2316 - 2321   ER26215   2322 - 2322 
      ER26216   2323 - 2323   ER26217   2324 - 2324   ER26218   2325 - 2325 
      ER26219   2326 - 2326   ER26220   2327 - 2327   ER26221   2328 - 2328 
      ER26222   2329 - 2329   ER26223   2330 - 2330   ER26224   2331 - 2331 
      ER26225   2332 - 2332   ER26226   2333 - 2333   ER26227   2334 - 2334 
      ER26228   2335 - 2335   ER26229   2336 - 2336   ER26230   2337 - 2342 
      ER26231   2343 - 2343   ER26232   2344 - 2344   ER26233   2345 - 2345 
      ER26234   2346 - 2346   ER26235   2347 - 2347   ER26236   2348 - 2348 
      ER26237   2349 - 2349   ER26238   2350 - 2350   ER26239   2351 - 2351 
      ER26240   2352 - 2352   ER26241   2353 - 2353   ER26242   2354 - 2354 
      ER26243   2355 - 2355   ER26244   2356 - 2356   ER26245   2357 - 2357 
      ER26246   2358 - 2363   ER26247   2364 - 2364   ER26248   2365 - 2365 
      ER26249   2366 - 2366   ER26250   2367 - 2367   ER26251   2368 - 2368 
      ER26252   2369 - 2369   ER26253   2370 - 2370   ER26254   2371 - 2371 
      ER26255   2372 - 2372   ER26256   2373 - 2373   ER26257   2374 - 2374 
      ER26258   2375 - 2375   ER26259   2376 - 2376   ER26260   2377 - 2377 
      ER26261   2378 - 2378   ER26262   2379 - 2384   ER26263   2385 - 2385 
      ER26264   2386 - 2386   ER26265   2387 - 2387   ER26266   2388 - 2388 
      ER26267   2389 - 2389   ER26268   2390 - 2390   ER26269   2391 - 2391 
      ER26270   2392 - 2392   ER26271   2393 - 2393   ER26272   2394 - 2394 
      ER26273   2395 - 2395   ER26274   2396 - 2396   ER26275   2397 - 2397 
      ER26276   2398 - 2398   ER26277   2399 - 2399   ER26278   2400 - 2400 
      ER26279   2401 - 2401   ER26280   2402 - 2402   ER26281   2403 - 2409 
      ER26282   2410 - 2410   ER26283   2411 - 2411   ER26284   2412 - 2412 
      ER26285   2413 - 2418   ER26286   2419 - 2419   ER26287   2420 - 2420 
      ER26288   2421 - 2421   ER26289   2422 - 2422   ER26290   2423 - 2423 
      ER26291   2424 - 2424   ER26292   2425 - 2425   ER26293   2426 - 2426 
      ER26294   2427 - 2427   ER26295   2428 - 2428   ER26296   2429 - 2429 
      ER26297   2430 - 2430   ER26298   2431 - 2431   ER26299   2432 - 2432 
      ER26300   2433 - 2433   ER26301   2434 - 2439   ER26302   2440 - 2440 
      ER26303   2441 - 2441   ER26304   2442 - 2442   ER26305   2443 - 2443 
      ER26306   2444 - 2444   ER26307   2445 - 2445   ER26308   2446 - 2446 
      ER26309   2447 - 2447   ER26310   2448 - 2448   ER26311   2449 - 2449 
      ER26312   2450 - 2450   ER26313   2451 - 2451   ER26314   2452 - 2452 
      ER26315   2453 - 2453   ER26316   2454 - 2454   ER26317   2455 - 2460 
      ER26318   2461 - 2461   ER26319   2462 - 2462   ER26320   2463 - 2463 
      ER26321   2464 - 2464   ER26322   2465 - 2465   ER26323   2466 - 2466 
      ER26324   2467 - 2467   ER26325   2468 - 2468   ER26326   2469 - 2469 
      ER26327   2470 - 2470   ER26328   2471 - 2471   ER26329   2472 - 2472 
      ER26330   2473 - 2473   ER26331   2474 - 2474   ER26332   2475 - 2475 
      ER26333   2476 - 2476   ER26334   2477 - 2482   ER26335   2483 - 2483 
      ER26336   2484 - 2484   ER26337   2485 - 2485   ER26338   2486 - 2486 
      ER26339   2487 - 2487   ER26340   2488 - 2488   ER26341   2489 - 2489 
      ER26342   2490 - 2490   ER26343   2491 - 2491   ER26344   2492 - 2492 
      ER26345   2493 - 2493   ER26346   2494 - 2494   ER26347   2495 - 2495 
      ER26348   2496 - 2496   ER26349   2497 - 2497   ER26350   2498 - 2498 
      ER26351   2499 - 2504   ER26352   2505 - 2505   ER26353   2506 - 2506 
      ER26354   2507 - 2507   ER26355   2508 - 2508   ER26356   2509 - 2509 
      ER26357   2510 - 2510   ER26358   2511 - 2511   ER26359   2512 - 2512 
      ER26360   2513 - 2513   ER26361   2514 - 2514   ER26362   2515 - 2515 
      ER26363   2516 - 2516   ER26364   2517 - 2517   ER26365   2518 - 2518 
      ER26366   2519 - 2519   ER26367   2520 - 2520   ER26368   2521 - 2526 
      ER26369   2527 - 2527   ER26370   2528 - 2528   ER26371   2529 - 2529 
      ER26372   2530 - 2530   ER26373   2531 - 2531   ER26374   2532 - 2532 
      ER26375   2533 - 2533   ER26376   2534 - 2534   ER26377   2535 - 2535 
      ER26378   2536 - 2536   ER26379   2537 - 2537   ER26380   2538 - 2538 
      ER26381   2539 - 2539   ER26382   2540 - 2540   ER26383   2541 - 2541 
      ER26384   2542 - 2542   ER26385   2543 - 2548   ER26386   2549 - 2549 
      ER26387   2550 - 2550   ER26388   2551 - 2551   ER26389   2552 - 2552 
      ER26390   2553 - 2553   ER26391   2554 - 2554   ER26392   2555 - 2555 
      ER26393   2556 - 2556   ER26394   2557 - 2557   ER26395   2558 - 2558 
      ER26396   2559 - 2559   ER26397   2560 - 2560   ER26398   2561 - 2561 
      ER26399   2562 - 2562   ER26400   2563 - 2563   ER26401   2564 - 2569 
      ER26402   2570 - 2570   ER26403   2571 - 2571   ER26404   2572 - 2572 
      ER26405   2573 - 2573   ER26406   2574 - 2574   ER26407   2575 - 2575 
      ER26408   2576 - 2576   ER26409   2577 - 2577   ER26410   2578 - 2578 
      ER26411   2579 - 2579   ER26412   2580 - 2580   ER26413   2581 - 2581 
      ER26414   2582 - 2582   ER26415   2583 - 2583   ER26416   2584 - 2584 
      ER26417   2585 - 2590   ER26418   2591 - 2591   ER26419   2592 - 2592 
      ER26420   2593 - 2593   ER26421   2594 - 2594   ER26422   2595 - 2595 
      ER26423   2596 - 2596   ER26424   2597 - 2597   ER26425   2598 - 2598 
      ER26426   2599 - 2599   ER26427   2600 - 2600   ER26428   2601 - 2601 
      ER26429   2602 - 2602   ER26430   2603 - 2603   ER26431   2604 - 2604 
      ER26432   2605 - 2605   ER26433   2606 - 2611   ER26434   2612 - 2612 
      ER26435   2613 - 2613   ER26436   2614 - 2614   ER26437   2615 - 2615 
      ER26438   2616 - 2616   ER26439   2617 - 2617   ER26440   2618 - 2618 
      ER26441   2619 - 2619   ER26442   2620 - 2620   ER26443   2621 - 2621 
      ER26444   2622 - 2622   ER26445   2623 - 2623   ER26446   2624 - 2624 
      ER26447   2625 - 2625   ER26448   2626 - 2626   ER26449   2627 - 2632 
      ER26450   2633 - 2633   ER26451   2634 - 2634   ER26452   2635 - 2635 
      ER26453   2636 - 2636   ER26454   2637 - 2637   ER26455   2638 - 2638 
      ER26456   2639 - 2639   ER26457   2640 - 2640   ER26458   2641 - 2641 
      ER26459   2642 - 2642   ER26460   2643 - 2643   ER26461   2644 - 2644 
      ER26462   2645 - 2645   ER26463   2646 - 2646   ER26464   2647 - 2647 
      ER26465   2648 - 2653   ER26466   2654 - 2654   ER26467   2655 - 2655 
      ER26468   2656 - 2656   ER26469   2657 - 2657   ER26470   2658 - 2658 
      ER26471   2659 - 2659   ER26472   2660 - 2660   ER26473   2661 - 2661 
      ER26474   2662 - 2662   ER26475   2663 - 2663   ER26476   2664 - 2664 
      ER26477   2665 - 2665   ER26478   2666 - 2666   ER26479   2667 - 2667 
      ER26480   2668 - 2668   ER26481   2669 - 2674   ER26482   2675 - 2675 
      ER26483   2676 - 2676   ER26484   2677 - 2677   ER26485   2678 - 2678 
      ER26486   2679 - 2679   ER26487   2680 - 2680   ER26488   2681 - 2681 
      ER26489   2682 - 2682   ER26490   2683 - 2683   ER26491   2684 - 2684 
      ER26492   2685 - 2685   ER26493   2686 - 2686   ER26494   2687 - 2687 
      ER26495   2688 - 2688   ER26496   2689 - 2689   ER26497   2690 - 2694 
      ER26498   2695 - 2695   ER26499   2696 - 2696   ER26500   2697 - 2697 
      ER26501   2698 - 2698   ER26502   2699 - 2699   ER26503   2700 - 2700 
      ER26504   2701 - 2701   ER26505   2702 - 2702   ER26506   2703 - 2703 
      ER26507   2704 - 2704   ER26508   2705 - 2705   ER26509   2706 - 2706 
      ER26510   2707 - 2707   ER26511   2708 - 2708   ER26512   2709 - 2709 
      ER26513   2710 - 2716   ER26514   2717 - 2723   ER26515   2724 - 2724 
      ER26516   2725 - 2730   ER26517   2731 - 2736   ER26518   2737 - 2737 
      ER26519   2738 - 2739   ER26520   2740 - 2741   ER26521   2742 - 2743 
      ER26522   2744 - 2745   ER26523   2746 - 2747   ER26524   2748 - 2749 
      ER26525   2750 - 2756   ER26526   2757 - 2757   ER26527   2758 - 2764 
      ER26528   2765 - 2765   ER26529   2766 - 2772   ER26530   2773 - 2773 
      ER26531   2774 - 2775   ER26532   2776 - 2776   ER26533   2777 - 2777 
      ER26534   2778 - 2778   ER26535   2779 - 2787   ER26536   2788 - 2788 
      ER26537   2789 - 2789   ER26538   2790 - 2790   ER26539   2791 - 2799 
      ER26540   2800 - 2800   ER26541   2801 - 2801   ER26542   2802 - 2802 
      ER26543   2803 - 2803   ER26544   2804 - 2812   ER26545   2813 - 2813 
      ER26546   2814 - 2814   ER26547   2815 - 2815   ER26548   2816 - 2816 
      ER26549   2817 - 2825   ER26550   2826 - 2826   ER26551   2827 - 2827 
      ER26552   2828 - 2828   ER26553   2829 - 2829   ER26554   2830 - 2830 
      ER26555   2831 - 2836   ER26556   2837 - 2837   ER26557   2838 - 2838 
      ER26558   2839 - 2839   ER26559   2840 - 2840   ER26560   2841 - 2841 
      ER26561   2842 - 2842   ER26562   2843 - 2843   ER26563   2844 - 2844 
      ER26564   2845 - 2845   ER26565   2846 - 2846   ER26566   2847 - 2847 
      ER26567   2848 - 2848   ER26568   2849 - 2849   ER26569   2850 - 2850 
      ER26570   2851 - 2851   ER26571   2852 - 2860   ER26572   2861 - 2861 
      ER26573   2862 - 2862   ER26574   2863 - 2863   ER26575   2864 - 2864 
      ER26576   2865 - 2865   ER26577   2866 - 2874   ER26578   2875 - 2875 
      ER26579   2876 - 2876   ER26580   2877 - 2877   ER26581   2878 - 2878 
      ER26582   2879 - 2884   ER26583   2885 - 2885   ER26584   2886 - 2886 
      ER26585   2887 - 2887   ER26586   2888 - 2888   ER26587   2889 - 2889 
      ER26588   2890 - 2890   ER26589   2891 - 2891   ER26590   2892 - 2892 
      ER26591   2893 - 2893   ER26592   2894 - 2894   ER26593   2895 - 2895 
      ER26594   2896 - 2896   ER26595   2897 - 2897   ER26596   2898 - 2898 
      ER26597   2899 - 2899   ER26598   2900 - 2908   ER26599   2909 - 2909 
      ER26600   2910 - 2910   ER26601   2911 - 2911   ER26602   2912 - 2912 
      ER26603   2913 - 2921   ER26604   2922 - 2922   ER26605   2923 - 2923 
      ER26606   2924 - 2924   ER26607   2925 - 2925   ER26608   2926 - 2934 
      ER26609   2935 - 2935   ER26610   2936 - 2936   ER26611   2937 - 2937 
      ER26612   2938 - 2938   ER26613   2939 - 2947   ER26614   2948 - 2948 
      ER26615   2949 - 2949   ER26616   2950 - 2950   ER26617   2951 - 2951 
      ER26618   2952 - 2952   ER26619   2953 - 2961   ER26620   2962 - 2962 
      ER26621   2963 - 2963   ER26622   2964 - 2964   ER26623   2965 - 2965 
      ER26624   2966 - 2974   ER26625   2975 - 2975   ER26626   2976 - 2976 
      ER26627   2977 - 2977   ER26628   2978 - 2978   ER26629   2979 - 2987 
      ER26630   2988 - 2988   ER26631   2989 - 2989   ER26632   2990 - 2990 
      ER26633   2991 - 2991   ER26634   2992 - 3000   ER26635   3001 - 3001 
      ER26636   3002 - 3002   ER26637   3003 - 3003   ER26638   3004 - 3012 
      ER26639   3013 - 3013   ER26640   3014 - 3014   ER26641   3015 - 3015 
      ER26642   3016 - 3016   ER26643   3017 - 3025   ER26644   3026 - 3026 
      ER26645   3027 - 3027   ER26646   3028 - 3028   ER26647   3029 - 3029 
      ER26648   3030 - 3030   ER26649   3031 - 3031   ER26650   3032 - 3040 
      ER26651   3041 - 3041   ER26652   3042 - 3042   ER26653   3043 - 3043 
      ER26654   3044 - 3044   ER26655   3045 - 3053   ER26656   3054 - 3054 
      ER26657   3055 - 3055   ER26658   3056 - 3056   ER26659   3057 - 3057 
      ER26660   3058 - 3058   ER26661   3059 - 3067   ER26662   3068 - 3068 
      ER26663   3069 - 3069   ER26664   3070 - 3070   ER26665   3071 - 3071 
      ER26666   3072 - 3072   ER26667   3073 - 3081   ER26668   3082 - 3082 
      ER26669   3083 - 3083   ER26670   3084 - 3084   ER26671   3085 - 3085 
      ER26672   3086 - 3094   ER26673   3095 - 3095   ER26674   3096 - 3096 
      ER26675   3097 - 3097   ER26676   3098 - 3098   ER26677   3099 - 3099 
      ER26678   3100 - 3108   ER26679   3109 - 3109   ER26680   3110 - 3110 
      ER26681   3111 - 3111   ER26682   3112 - 3112   ER26683   3113 - 3121 
      ER26684   3122 - 3122   ER26685   3123 - 3123   ER26686   3124 - 3124 
      ER26687   3125 - 3125   ER26688   3126 - 3129   ER26689   3130 - 3138 
      ER26690   3139 - 3139   ER26691   3140 - 3140   ER26692   3141 - 3141 
      ER26693   3142 - 3145   ER26694   3146 - 3154   ER26695   3155 - 3155 
      ER26696   3156 - 3156   ER26697   3157 - 3157   ER26698   3158 - 3161 
      ER26699   3162 - 3170   ER26700   3171 - 3171   ER26701   3172 - 3172 
      ER26702   3173 - 3173   ER26703   3174 - 3174   ER26704   3175 - 3176 
      ER26705   3177 - 3180   ER26706   3181 - 3181   ER26707   3182 - 3184 
      ER26708   3185 - 3185   ER26709   3186 - 3188   ER26710   3189 - 3189 
      ER26711   3190 - 3190   ER26712   3191 - 3197   ER26713   3198 - 3198 
      ER26714   3199 - 3201   ER26715   3202 - 3202   ER26716   3203 - 3209 
      ER26717   3210 - 3210   ER26718   3211 - 3213   ER26719   3214 - 3214 
      ER26720   3215 - 3215   ER26721   3216 - 3222   ER26722   3223 - 3223 
      ER26723   3224 - 3226   ER26724   3227 - 3229   ER26725   3230 - 3238 
      ER26726   3239 - 3239   ER26727   3240 - 3248   ER26728   3249 - 3249 
      ER26729   3250 - 3252   ER26730   3253 - 3253   ER26731   3254 - 3254 
      ER26732   3255 - 3257   ER26733   3258 - 3260   ER26734   3261 - 3263 
      ER26735   3264 - 3266   ER26736   3267 - 3267   ER26737   3268 - 3268 
      ER26738   3269 - 3271   ER26739   3272 - 3274   ER26740   3275 - 3277 
      ER26741   3278 - 3280   ER26742   3281 - 3283   ER26743   3284 - 3284 
      ER26744   3285 - 3291   ER26745   3292 - 3292   ER26746   3293 - 3295 
      ER26747   3296 - 3304   ER26748   3305 - 3305   ER26749   3306 - 3306 
      ER26750   3307 - 3307   ER26751   3308 - 3308   ER26752   3309 - 3310 
      ER26753   3311 - 3312   ER26754   3313 - 3315   ER26755   3316 - 3319 
      ER26756   3320 - 3322   ER26757   3323 - 3326   ER26758   3327 - 3327 
      ER26759   3328 - 3328   ER26760   3329 - 3335   ER26761   3336 - 3336 
      ER26762   3337 - 3339   ER26763   3340 - 3340   ER26764   3341 - 3341 
      ER26765   3342 - 3349   ER26766   3350 - 3350   ER26767   3351 - 3358 
      ER26768   3359 - 3360   ER26769   3361 - 3367   ER26770   3368 - 3368 
      ER26771   3369 - 3369   ER26772   3370 - 3370   ER26773   3371 - 3371 
      ER26774   3372 - 3372   ER26775   3373 - 3373   ER26776   3374 - 3374 
      ER26777   3375 - 3376   ER26778   3377 - 3380   ER26779   3381 - 3387 
      ER26780   3388 - 3388   ER26781   3389 - 3389   ER26782   3390 - 3390 
      ER26783   3391 - 3397   ER26784   3398 - 3398   ER26785   3399 - 3399 
      ER26786   3400 - 3400   ER26787   3401 - 3401   ER26788   3402 - 3402 
      ER26789   3403 - 3403   ER26790   3404 - 3410   ER26791   3411 - 3412 
      ER26792   3413 - 3414   ER26793   3415 - 3420   ER26794   3421 - 3421 
      ER26795   3422 - 3424   ER26796   3425 - 3432   ER26797   3433 - 3439 
      ER26798   3440 - 3440   ER26799   3441 - 3448   ER26800   3449 - 3450 
      ER26801   3451 - 3457   ER26802   3458 - 3458   ER26803   3459 - 3460 
      ER26804   3461 - 3461   ER26805   3462 - 3462   ER26806   3463 - 3470 
      ER26807   3471 - 3471   ER26808   3472 - 3479   ER26809   3480 - 3481 
      ER26810   3482 - 3488   ER26811   3489 - 3489   ER26812   3490 - 3490 
      ER26813   3491 - 3491   ER26814   3492 - 3492   ER26815   3493 - 3493 
      ER26816   3494 - 3494   ER26817   3495 - 3495   ER26818   3496 - 3497 
      ER26819   3498 - 3501   ER26820   3502 - 3508   ER26821   3509 - 3509 
      ER26822   3510 - 3510   ER26823   3511 - 3511   ER26824   3512 - 3518 
      ER26825   3519 - 3519   ER26826   3520 - 3520   ER26827   3521 - 3521 
      ER26828   3522 - 3522   ER26829   3523 - 3523   ER26830   3524 - 3524 
      ER26831   3525 - 3531   ER26832   3532 - 3533   ER26833   3534 - 3535 
      ER26834   3536 - 3541   ER26835   3542 - 3542   ER26836   3543 - 3545 
      ER26837   3546 - 3553   ER26838   3554 - 3560   ER26839   3561 - 3561 
      ER26840   3562 - 3569   ER26841   3570 - 3571   ER26842   3572 - 3578 
      ER26843   3579 - 3579   ER26844   3580 - 3581   ER26845   3582 - 3582 
      ER26846   3583 - 3583   ER26847   3584 - 3584   ER26848   3585 - 3586 
      ER26849   3587 - 3590   ER26850   3591 - 3591   ER26851   3592 - 3594 
      ER26852   3595 - 3595   ER26853   3596 - 3598   ER26854   3599 - 3599 
      ER26855   3600 - 3600   ER26856   3601 - 3607   ER26857   3608 - 3608 
      ER26858   3609 - 3611   ER26859   3612 - 3612   ER26860   3613 - 3619 
      ER26861   3620 - 3620   ER26862   3621 - 3623   ER26863   3624 - 3624 
      ER26864   3625 - 3625   ER26865   3626 - 3632   ER26866   3633 - 3633 
      ER26867   3634 - 3636   ER26868   3637 - 3639   ER26869   3640 - 3648 
      ER26870   3649 - 3649   ER26871   3650 - 3658   ER26872   3659 - 3659 
      ER26873   3660 - 3662   ER26874   3663 - 3663   ER26875   3664 - 3664 
      ER26876   3665 - 3667   ER26877   3668 - 3670   ER26878   3671 - 3673 
      ER26879   3674 - 3676   ER26880   3677 - 3677   ER26881   3678 - 3678 
      ER26882   3679 - 3681   ER26883   3682 - 3684   ER26884   3685 - 3687 
      ER26885   3688 - 3690   ER26886   3691 - 3693   ER26887   3694 - 3694 
      ER26888   3695 - 3701   ER26889   3702 - 3702   ER26890   3703 - 3705 
      ER26891   3706 - 3714   ER26892   3715 - 3715   ER26893   3716 - 3716 
      ER26894   3717 - 3717   ER26895   3718 - 3718   ER26896   3719 - 3720 
      ER26897   3721 - 3722   ER26898   3723 - 3725   ER26899   3726 - 3729 
      ER26900   3730 - 3732   ER26901   3733 - 3736   ER26902   3737 - 3737 
      ER26903   3738 - 3738   ER26904   3739 - 3745   ER26905   3746 - 3746 
      ER26906   3747 - 3749   ER26907   3750 - 3750   ER26908   3751 - 3751 
      ER26909   3752 - 3759   ER26910   3760 - 3760   ER26911   3761 - 3768 
      ER26912   3769 - 3770   ER26913   3771 - 3777   ER26914   3778 - 3778 
      ER26915   3779 - 3779   ER26916   3780 - 3780   ER26917   3781 - 3781 
      ER26918   3782 - 3782   ER26919   3783 - 3783   ER26920   3784 - 3784 
      ER26921   3785 - 3786   ER26922   3787 - 3790   ER26923   3791 - 3797 
      ER26924   3798 - 3798   ER26925   3799 - 3799   ER26926   3800 - 3800 
      ER26927   3801 - 3807   ER26928   3808 - 3808   ER26929   3809 - 3809 
      ER26930   3810 - 3810   ER26931   3811 - 3811   ER26932   3812 - 3812 
      ER26933   3813 - 3813   ER26934   3814 - 3820   ER26935   3821 - 3822 
      ER26936   3823 - 3824   ER26937   3825 - 3830   ER26938   3831 - 3831 
      ER26939   3832 - 3834   ER26940   3835 - 3842   ER26941   3843 - 3849 
      ER26942   3850 - 3850   ER26943   3851 - 3858   ER26944   3859 - 3860 
      ER26945   3861 - 3867   ER26946   3868 - 3868   ER26947   3869 - 3870 
      ER26948   3871 - 3871   ER26949   3872 - 3872   ER26950   3873 - 3880 
      ER26951   3881 - 3881   ER26952   3882 - 3889   ER26953   3890 - 3891 
      ER26954   3892 - 3898   ER26955   3899 - 3899   ER26956   3900 - 3900 
      ER26957   3901 - 3901   ER26958   3902 - 3902   ER26959   3903 - 3903 
      ER26960   3904 - 3904   ER26961   3905 - 3905   ER26962   3906 - 3907 
      ER26963   3908 - 3911   ER26964   3912 - 3918   ER26965   3919 - 3919 
      ER26966   3920 - 3920   ER26967   3921 - 3921   ER26968   3922 - 3928 
      ER26969   3929 - 3929   ER26970   3930 - 3930   ER26971   3931 - 3931 
      ER26972   3932 - 3932   ER26973   3933 - 3933   ER26974   3934 - 3934 
      ER26975   3935 - 3941   ER26976   3942 - 3943   ER26977   3944 - 3945 
      ER26978   3946 - 3951   ER26979   3952 - 3952   ER26980   3953 - 3955 
      ER26981   3956 - 3963   ER26982   3964 - 3970   ER26983   3971 - 3971 
      ER26984   3972 - 3979   ER26985   3980 - 3981   ER26986   3982 - 3988 
      ER26987   3989 - 3989   ER26988   3990 - 3991   ER26989   3992 - 3992 
      ER26990   3993 - 3993   ER26991   3994 - 3994   ER26992   3995 - 3995 
      ER26993   3996 - 3996   ER26994   3997 - 3997   ER26995   3998 - 3998 
      ER26996   3999 - 3999   ER26997   4000 - 4000   ER26998   4001 - 4001 
      ER26999   4002 - 4004   ER27000   4005 - 4005   ER27001   4006 - 4006 
      ER27002   4007 - 4007   ER27003   4008 - 4010   ER27004   4011 - 4011 
      ER27005   4012 - 4012   ER27006   4013 - 4013   ER27007   4014 - 4016 
      ER27008   4017 - 4017   ER27009   4018 - 4018   ER27010   4019 - 4019 
      ER27011   4020 - 4022   ER27012   4023 - 4023   ER27013   4024 - 4024 
      ER27014   4025 - 4025   ER27015   4026 - 4028   ER27016   4029 - 4029 
      ER27017   4030 - 4030   ER27018   4031 - 4031   ER27019   4032 - 4034 
      ER27020   4035 - 4035   ER27021   4036 - 4036   ER27022   4037 - 4037 
      ER27023   4038 - 4040   ER27024   4041 - 4041   ER27025   4042 - 4042 
      ER27026   4043 - 4043   ER27027   4044 - 4046   ER27028   4047 - 4047 
      ER27029   4048 - 4048   ER27030   4049 - 4049   ER27031   4050 - 4052 
      ER27032   4053 - 4053   ER27033   4054 - 4054   ER27034   4055 - 4055 
      ER27035   4056 - 4058   ER27036   4059 - 4059   ER27037   4060 - 4060 
      ER27038   4061 - 4061   ER27039   4062 - 4064   ER27040   4065 - 4065 
      ER27041   4066 - 4066   ER27042   4067 - 4068   ER27043   4069 - 4070 
      ER27044   4071 - 4071   ER27045   4072 - 4072   ER27046   4073 - 4075 
      ER27047   4076 - 4077   ER27048   4078 - 4079   ER27049   4080 - 4081 
      ER27050   4082 - 4082   ER27051   4083 - 4083   ER27052   4084 - 4084 
      ER27053   4085 - 4087   ER27054   4088 - 4088   ER27055   4089 - 4089 
      ER27056   4090 - 4090   ER27057   4091 - 4093   ER27058   4094 - 4095 
      ER27059   4096 - 4096   ER27060   4097 - 4097   ER27061   4098 - 4098 
      ER27062   4099 - 4099   ER27063   4100 - 4100   ER27064   4101 - 4101 
      ER27065   4102 - 4102   ER27066   4103 - 4103   ER27067   4104 - 4104 
      ER27068   4105 - 4105   ER27069   4106 - 4106   ER27070   4107 - 4107 
      ER27071   4108 - 4108   ER27072   4109 - 4109   ER27073   4110 - 4110 
      ER27074   4111 - 4111   ER27075   4112 - 4112   ER27076   4113 - 4113 
      ER27077   4114 - 4114   ER27078   4115 - 4115   ER27079   4116 - 4116 
      ER27080   4117 - 4117   ER27081   4118 - 4118   ER27082   4119 - 4119 
      ER27083   4120 - 4120   ER27084   4121 - 4121   ER27085   4122 - 4122 
      ER27086   4123 - 4123   ER27087   4124 - 4124   ER27088   4125 - 4125 
      ER27089   4126 - 4126   ER27090   4127 - 4127   ER27091   4128 - 4128 
      ER27092   4129 - 4131   ER27093   4132 - 4132   ER27094   4133 - 4135 
      ER27095   4136 - 4136   ER27096   4137 - 4139   ER27097   4140 - 4140 
      ER27098   4141 - 4141   ER27099   4142 - 4144   ER27100   4145 - 4146 
      ER27101   4147 - 4147   ER27102   4148 - 4150   ER27103   4151 - 4152 
      ER27104   4153 - 4154   ER27105   4155 - 4155   ER27106   4156 - 4156 
      ER27107   4157 - 4158   ER27108   4159 - 4161   ER27109   4162 - 4164 
      ER27110   4165 - 4165   ER27111   4166 - 4167   ER27112   4168 - 4168 
      ER27113   4169 - 4169   ER27114   4170 - 4170   ER27115   4171 - 4171 
      ER27116   4172 - 4172   ER27117   4173 - 4173   ER27118   4174 - 4174 
      ER27119   4175 - 4175   ER27120   4176 - 4176   ER27121   4177 - 4177 
      ER27122   4178 - 4180   ER27123   4181 - 4181   ER27124   4182 - 4182 
      ER27125   4183 - 4183   ER27126   4184 - 4186   ER27127   4187 - 4187 
      ER27128   4188 - 4188   ER27129   4189 - 4189   ER27130   4190 - 4192 
      ER27131   4193 - 4193   ER27132   4194 - 4194   ER27133   4195 - 4195 
      ER27134   4196 - 4198   ER27135   4199 - 4199   ER27136   4200 - 4200 
      ER27137   4201 - 4201   ER27138   4202 - 4204   ER27139   4205 - 4205 
      ER27140   4206 - 4206   ER27141   4207 - 4207   ER27142   4208 - 4210 
      ER27143   4211 - 4211   ER27144   4212 - 4212   ER27145   4213 - 4213 
      ER27146   4214 - 4216   ER27147   4217 - 4217   ER27148   4218 - 4218 
      ER27149   4219 - 4219   ER27150   4220 - 4222   ER27151   4223 - 4223 
      ER27152   4224 - 4224   ER27153   4225 - 4225   ER27154   4226 - 4228 
      ER27155   4229 - 4229   ER27156   4230 - 4230   ER27157   4231 - 4231 
      ER27158   4232 - 4234   ER27159   4235 - 4235   ER27160   4236 - 4236 
      ER27161   4237 - 4237   ER27162   4238 - 4240   ER27163   4241 - 4241 
      ER27164   4242 - 4242   ER27165   4243 - 4244   ER27166   4245 - 4246 
      ER27167   4247 - 4247   ER27168   4248 - 4248   ER27169   4249 - 4251 
      ER27170   4252 - 4253   ER27171   4254 - 4255   ER27172   4256 - 4257 
      ER27173   4258 - 4258   ER27174   4259 - 4259   ER27175   4260 - 4260 
      ER27176   4261 - 4263   ER27177   4264 - 4264   ER27178   4265 - 4265 
      ER27179   4266 - 4266   ER27180   4267 - 4269   ER27181   4270 - 4271 
      ER27182   4272 - 4272   ER27183   4273 - 4273   ER27184   4274 - 4274 
      ER27185   4275 - 4275   ER27186   4276 - 4276   ER27187   4277 - 4277 
      ER27188   4278 - 4278   ER27189   4279 - 4279   ER27190   4280 - 4280 
      ER27191   4281 - 4281   ER27192   4282 - 4282   ER27193   4283 - 4283 
      ER27194   4284 - 4284   ER27195   4285 - 4285   ER27196   4286 - 4286 
      ER27197   4287 - 4287   ER27198   4288 - 4288   ER27199   4289 - 4289 
      ER27200   4290 - 4290   ER27201   4291 - 4291   ER27202   4292 - 4292 
      ER27203   4293 - 4293   ER27204   4294 - 4294   ER27205   4295 - 4295 
      ER27206   4296 - 4296   ER27207   4297 - 4297   ER27208   4298 - 4298 
      ER27209   4299 - 4299   ER27210   4300 - 4300   ER27211   4301 - 4301 
      ER27212   4302 - 4302   ER27213   4303 - 4303   ER27214   4304 - 4304 
      ER27215   4305 - 4307   ER27216   4308 - 4308   ER27217   4309 - 4311 
      ER27218   4312 - 4312   ER27219   4313 - 4315   ER27220   4316 - 4316 
      ER27221   4317 - 4317   ER27222   4318 - 4320   ER27223   4321 - 4322 
      ER27224   4323 - 4323   ER27225   4324 - 4326   ER27226   4327 - 4328 
      ER27227   4329 - 4330   ER27228   4331 - 4331   ER27229   4332 - 4332 
      ER27230   4333 - 4334   ER27231   4335 - 4337   ER27232   4338 - 4340 
      ER27233   4341 - 4341   ER27234   4342 - 4343   ER27235   4344 - 4344 
      ER27236   4345 - 4345   ER27237   4346 - 4346   ER27238   4347 - 4352 
      ER27239   4353 - 4358   ER27240   4359 - 4359   ER27241   4360 - 4360 
      ER27242   4361 - 4361   ER27243   4362 - 4362   ER27244   4363 - 4363 
      ER27245   4364 - 4369   ER27246   4370 - 4370   ER27247   4371 - 4371 
      ER27248   4372 - 4372   ER27249   4373 - 4373   ER27250   4374 - 4374 
      ER27251   4375 - 4380   ER27252   4381 - 4381   ER27253   4382 - 4382 
      ER27254   4383 - 4383   ER27255   4384 - 4384   ER27256   4385 - 4385 
      ER27257   4386 - 4393   ER27258   4394 - 4394   ER27259   4395 - 4395 
      ER27260   4396 - 4396   ER27261   4397 - 4397   ER27262   4398 - 4398 
      ER27263   4399 - 4399   ER27264   4400 - 4401   ER27265   4402 - 4403 
      ER27266   4404 - 4404   ER27267   4405 - 4406   ER27268   4407 - 4407 
      ER27269   4408 - 4408   ER27270   4409 - 4410   ER27271   4411 - 4411 
      ER27272   4412 - 4414   ER27273   4415 - 4417   ER27274   4418 - 4419 
      ER27275   4420 - 4421   ER27276   4422 - 4422   ER27277   4423 - 4424 
      ER27278   4425 - 4425   ER27279   4426 - 4426   ER27280   4427 - 4428 
      ER27281   4429 - 4429   ER27282   4430 - 4432   ER27283   4433 - 4435 
      ER27284   4436 - 4436   ER27285   4437 - 4438   ER27286   4439 - 4439 
      ER27287   4440 - 4440   ER27288   4441 - 4442   ER27289   4443 - 4443 
      ER27290   4444 - 4444   ER27291   4445 - 4446   ER27292   4447 - 4447 
      ER27293   4448 - 4448   ER27294   4449 - 4450   ER27295   4451 - 4451 
      ER27296   4452 - 4452   ER27297   4453 - 4453   ER27298   4454 - 4454 
      ER27299   4455 - 4455   ER27300   4456 - 4456   ER27301   4457 - 4457 
      ER27302   4458 - 4459   ER27303   4460 - 4461   ER27304   4462 - 4462 
      ER27305   4463 - 4463   ER27306   4464 - 4464   ER27307   4465 - 4466 
      ER27308   4467 - 4470   ER27309   4471 - 4472   ER27310   4473 - 4474 
      ER27311   4475 - 4478   ER27312   4479 - 4480   ER27313   4481 - 4484 
      ER27314   4485 - 4486   ER27315   4487 - 4488   ER27316   4489 - 4492 
      ER27317   4493 - 4493   ER27318   4494 - 4495   ER27319   4496 - 4499 
      ER27320   4500 - 4500   ER27321   4501 - 4501   ER27322   4502 - 4503 
      ER27323   4504 - 4505   ER27324   4506 - 4509   ER27325   4510 - 4511 
      ER27326   4512 - 4512   ER27327   4513 - 4513   ER27328   4514 - 4514 
      ER27329   4515 - 4516   ER27330   4517 - 4518   ER27331   4519 - 4520 
      ER27332   4521 - 4524   ER27333   4525 - 4525   ER27334   4526 - 4526 
      ER27335   4527 - 4528   ER27336   4529 - 4530   ER27337   4531 - 4532 
      ER27338   4533 - 4536   ER27339   4537 - 4537   ER27340   4538 - 4538 
      ER27341   4539 - 4540   ER27342   4541 - 4542   ER27343   4543 - 4544 
      ER27344   4545 - 4548   ER27345   4549 - 4549   ER27346   4550 - 4551 
      ER27347   4552 - 4553   ER27348   4554 - 4555   ER27349   4556 - 4557 
      ER27350   4558 - 4560   ER27351   4561 - 4563   ER27352   4564 - 4564 
      ER27353   4565 - 4566   ER27354   4567 - 4568   ER27355   4569 - 4569 
      ER27356   4570 - 4571   ER27357   4572 - 4572   ER27358   4573 - 4573 
      ER27359   4574 - 4575   ER27360   4576 - 4576   ER27361   4577 - 4579 
      ER27362   4580 - 4582   ER27363   4583 - 4584   ER27364   4585 - 4586 
      ER27365   4587 - 4587   ER27366   4588 - 4589   ER27367   4590 - 4590 
      ER27368   4591 - 4591   ER27369   4592 - 4593   ER27370   4594 - 4594 
      ER27371   4595 - 4597   ER27372   4598 - 4600   ER27373   4601 - 4601 
      ER27374   4602 - 4603   ER27375   4604 - 4604   ER27376   4605 - 4605 
      ER27377   4606 - 4607   ER27378   4608 - 4608   ER27379   4609 - 4609 
      ER27380   4610 - 4611   ER27381   4612 - 4612   ER27382   4613 - 4613 
      ER27383   4614 - 4615   ER27384   4616 - 4616   ER27385   4617 - 4617 
      ER27386   4618 - 4619   ER27387   4620 - 4620   ER27388   4621 - 4621 
      ER27389   4622 - 4622   ER27390   4623 - 4623   ER27391   4624 - 4624 
      ER27392   4625 - 4625   ER27393   4626 - 4626   ER27394   4627 - 4627 
      ER27395   4628 - 4628   ER27396   4629 - 4629   ER27397   4630 - 4630 
      ER27398   4631 - 4632   ER27399   4633 - 4634   ER27400   4635 - 4635 
      ER27401   4636 - 4636   ER27402   4637 - 4637   ER27403   4638 - 4639 
      ER27404   4640 - 4643   ER27405   4644 - 4645   ER27406   4646 - 4647 
      ER27407   4648 - 4651   ER27408   4652 - 4653   ER27409   4654 - 4657 
      ER27410   4658 - 4659   ER27411   4660 - 4661   ER27412   4662 - 4665 
      ER27413   4666 - 4666   ER27414   4667 - 4668   ER27415   4669 - 4672 
      ER27416   4673 - 4673   ER27417   4674 - 4674   ER27418   4675 - 4676 
      ER27419   4677 - 4678   ER27420   4679 - 4682   ER27421   4683 - 4684 
      ER27422   4685 - 4685   ER27423   4686 - 4686   ER27424   4687 - 4687 
      ER27425   4688 - 4689   ER27426   4690 - 4691   ER27427   4692 - 4693 
      ER27428   4694 - 4697   ER27429   4698 - 4698   ER27430   4699 - 4699 
      ER27431   4700 - 4701   ER27432   4702 - 4703   ER27433   4704 - 4705 
      ER27434   4706 - 4709   ER27435   4710 - 4710   ER27436   4711 - 4711 
      ER27437   4712 - 4713   ER27438   4714 - 4715   ER27439   4716 - 4717 
      ER27440   4718 - 4721   ER27441   4722 - 4722   ER27442   4723 - 4724 
      ER27443   4725 - 4726   ER27444   4727 - 4728   ER27445   4729 - 4730 
      ER27446   4731 - 4733   ER27447   4734 - 4736   ER27448   4737 - 4737 
      ER27449   4738 - 4738   ER27450   4739 - 4739   ER27451   4740 - 4745 
      ER27452   4746 - 4746   ER27453   4747 - 4747   ER27454   4748 - 4748 
      ER27455   4749 - 4749   ER27456   4750 - 4750   ER27457   4751 - 4756 
      ER27458   4757 - 4757   ER27459   4758 - 4758   ER27460   4759 - 4759 
      ER27461   4760 - 4760   ER27462   4761 - 4761   ER27463   4762 - 4766 
      ER27464   4767 - 4767   ER27465   4768 - 4768   ER27466   4769 - 4769 
      ER27467   4770 - 4770   ER27468   4771 - 4771   ER27469   4772 - 4776 
      ER27470   4777 - 4777   ER27471   4778 - 4778   ER27472   4779 - 4779 
      ER27473   4780 - 4780   ER27474   4781 - 4781   ER27475   4782 - 4786 
      ER27476   4787 - 4787   ER27477   4788 - 4788   ER27478   4789 - 4789 
      ER27479   4790 - 4790   ER27480   4791 - 4791   ER27481   4792 - 4796 
      ER27482   4797 - 4797   ER27483   4798 - 4798   ER27484   4799 - 4799 
      ER27485   4800 - 4800   ER27486   4801 - 4801   ER27487   4802 - 4806 
      ER27488   4807 - 4807   ER27489   4808 - 4808   ER27490   4809 - 4809 
      ER27491   4810 - 4810   ER27492   4811 - 4811   ER27493   4812 - 4816 
      ER27494   4817 - 4817   ER27495   4818 - 4818   ER27496   4819 - 4819 
      ER27497   4820 - 4820   ER27498   4821 - 4821   ER27499   4822 - 4826 
      ER27500   4827 - 4827   ER27501   4828 - 4828   ER27502   4829 - 4829 
      ER27503   4830 - 4830   ER27504   4831 - 4831   ER27505   4832 - 4836 
      ER27506   4837 - 4837   ER27507   4838 - 4838   ER27508   4839 - 4839 
      ER27509   4840 - 4840   ER27510   4841 - 4841   ER27511   4842 - 4846 
      ER27512   4847 - 4847   ER27513   4848 - 4848   ER27514   4849 - 4849 
      ER27515   4850 - 4850   ER27516   4851 - 4851   ER27517   4852 - 4852 
      ER27518   4853 - 4853   ER27519   4854 - 4855   ER27520   4856 - 4856 
      ER27521   4857 - 4857   ER27522   4858 - 4858   ER27523   4859 - 4859 
      ER27524   4860 - 4861   ER27525   4862 - 4862   ER27526   4863 - 4863 
      ER27527   4864 - 4865   ER27528   4866 - 4867   ER27529   4868 - 4872 
      ER27530   4873 - 4873   ER27531   4874 - 4878   ER27532   4879 - 4879 
      ER27533   4880 - 4884   ER27534   4885 - 4886   ER27535   4887 - 4887 
      ER27536   4888 - 4888   ER27537   4889 - 4890   ER27538   4891 - 4892 
      ER27539   4893 - 4897   ER27540   4898 - 4898   ER27541   4899 - 4903 
      ER27542   4904 - 4904   ER27543   4905 - 4909   ER27544   4910 - 4911 
      ER27545   4912 - 4912   ER27546   4913 - 4914   ER27547   4915 - 4916 
      ER27548   4917 - 4921   ER27549   4922 - 4922   ER27550   4923 - 4927 
      ER27551   4928 - 4928   ER27552   4929 - 4933   ER27553   4934 - 4935 
      ER27554   4936 - 4936   ER27555   4937 - 4938   ER27556   4939 - 4940 
      ER27557   4941 - 4945   ER27558   4946 - 4946   ER27559   4947 - 4951 
      ER27560   4952 - 4952   ER27561   4953 - 4957   ER27562   4958 - 4959 
      ER27563   4960 - 4960   ER27564   4961 - 4962   ER27565   4963 - 4964 
      ER27566   4965 - 4969   ER27567   4970 - 4970   ER27568   4971 - 4975 
      ER27569   4976 - 4976   ER27570   4977 - 4981   ER27571   4982 - 4983 
      ER27572   4984 - 4984   ER27573   4985 - 4986   ER27574   4987 - 4988 
      ER27575   4989 - 4993   ER27576   4994 - 4994   ER27577   4995 - 4999 
      ER27578   5000 - 5000   ER27579   5001 - 5005   ER27580   5006 - 5007 
      ER27581   5008 - 5008   ER27582   5009 - 5010   ER27583   5011 - 5012 
      ER27584   5013 - 5017   ER27585   5018 - 5018   ER27586   5019 - 5023 
      ER27587   5024 - 5024   ER27588   5025 - 5029   ER27589   5030 - 5031 
      ER27590   5032 - 5032   ER27591   5033 - 5034   ER27592   5035 - 5036 
      ER27593   5037 - 5041   ER27594   5042 - 5042   ER27595   5043 - 5047 
      ER27596   5048 - 5048   ER27597   5049 - 5053   ER27598   5054 - 5055 
      ER27599   5056 - 5056   ER27600   5057 - 5058   ER27601   5059 - 5060 
      ER27602   5061 - 5065   ER27603   5066 - 5066   ER27604   5067 - 5071 
      ER27605   5072 - 5072   ER27606   5073 - 5077   ER27607   5078 - 5079 
      ER27608   5080 - 5080   ER27609   5081 - 5082   ER27610   5083 - 5084 
      ER27611   5085 - 5089   ER27612   5090 - 5090   ER27613   5091 - 5095 
      ER27614   5096 - 5096   ER27615   5097 - 5101   ER27616   5102 - 5103 
      ER27617   5104 - 5104   ER27618   5105 - 5106   ER27619   5107 - 5108 
      ER27620   5109 - 5113   ER27621   5114 - 5114   ER27622   5115 - 5119 
      ER27623   5120 - 5120   ER27624   5121 - 5125   ER27625   5126 - 5127 
      ER27626   5128 - 5128   ER27627   5129 - 5130   ER27628   5131 - 5132 
      ER27629   5133 - 5137   ER27630   5138 - 5138   ER27631   5139 - 5143 
      ER27632   5144 - 5144   ER27633   5145 - 5149   ER27634   5150 - 5150 
      ER27635   5151 - 5152   ER27636   5153 - 5153   ER27637   5154 - 5155 
      ER27638   5156 - 5157   ER27639   5158 - 5162   ER27640   5163 - 5163 
      ER27641   5164 - 5168   ER27642   5169 - 5169   ER27643   5170 - 5174 
      ER27644   5175 - 5175   ER27645   5176 - 5177   ER27646   5178 - 5178 
      ER27647   5179 - 5180   ER27648   5181 - 5182   ER27649   5183 - 5187 
      ER27650   5188 - 5188   ER27651   5189 - 5193   ER27652   5194 - 5194 
      ER27653   5195 - 5199   ER27654   5200 - 5200   ER27655   5201 - 5201 
      ER27656   5202 - 5206   ER27657   5207 - 5207   ER27658   5208 - 5212 
      ER27659   5213 - 5213   ER27660   5214 - 5218   ER27661   5219 - 5219 
      ER27662   5220 - 5224   ER27663   5225 - 5225   ER27664   5226 - 5230 
      ER27665   5231 - 5231   ER27666   5232 - 5236   ER27667   5237 - 5237 
      ER27668   5238 - 5242   ER27669   5243 - 5243   ER27670   5244 - 5244 
      ER27671   5245 - 5245   ER27672   5246 - 5246   ER27673   5247 - 5247 
      ER27674   5248 - 5248   ER27675   5249 - 5249   ER27676   5250 - 5250 
      ER27677   5251 - 5251   ER27678   5252 - 5257   ER27679   5258 - 5258 
      ER27680   5259 - 5259   ER27681   5260 - 5260   ER27682   5261 - 5261 
      ER27683   5262 - 5262   ER27684   5263 - 5263   ER27685   5264 - 5264 
      ER27686   5265 - 5265   ER27687   5266 - 5266   ER27688   5267 - 5267 
      ER27689   5268 - 5268   ER27690   5269 - 5269   ER27691   5270 - 5270 
      ER27692   5271 - 5271   ER27693   5272 - 5272   ER27694   5273 - 5273 
      ER27695   5274 - 5274   ER27696   5275 - 5275   ER27697   5276 - 5276 
      ER27698   5277 - 5277   ER27699   5278 - 5278   ER27700   5279 - 5279 
      ER27701   5280 - 5280   ER27702   5281 - 5281   ER27703   5282 - 5282 
      ER27704   5283 - 5283   ER27705   5284 - 5284   ER27706   5285 - 5285 
      ER27707   5286 - 5286   ER27708   5287 - 5288   ER27709   5289 - 5289 
      ER27710   5290 - 5291   ER27711   5292 - 5292   ER27712   5293 - 5293 
      ER27713   5294 - 5301   ER27714   5302 - 5302   ER27715   5303 - 5303 
      ER27716   5304 - 5304   ER27717   5305 - 5305   ER27718   5306 - 5306 
      ER27719   5307 - 5307   ER27720   5308 - 5308   ER27721   5309 - 5309 
      ER27722   5310 - 5310   ER27723   5311 - 5311   ER27724   5312 - 5312 
      ER27725   5313 - 5313   ER27726   5314 - 5314   ER27727   5315 - 5315 
      ER27728   5316 - 5316   ER27729   5317 - 5317   ER27730   5318 - 5324 
      ER27731   5325 - 5325   ER27732   5326 - 5326   ER27733   5327 - 5327 
      ER27734   5328 - 5328   ER27735   5329 - 5329   ER27736   5330 - 5330 
      ER27737   5331 - 5331   ER27738   5332 - 5332   ER27739   5333 - 5333 
      ER27740   5334 - 5334   ER27741   5335 - 5335   ER27742   5336 - 5336 
      ER27743   5337 - 5337   ER27744   5338 - 5338   ER27745   5339 - 5345 
      ER27746   5346 - 5346   ER27747   5347 - 5347   ER27748   5348 - 5348 
      ER27749   5349 - 5349   ER27750   5350 - 5350   ER27751   5351 - 5351 
      ER27752   5352 - 5352   ER27753   5353 - 5353   ER27754   5354 - 5354 
      ER27755   5355 - 5355   ER27756   5356 - 5356   ER27757   5357 - 5357 
      ER27758   5358 - 5358   ER27759   5359 - 5359   ER27760   5360 - 5366 
      ER27761   5367 - 5367   ER27762   5368 - 5368   ER27763   5369 - 5369 
      ER27764   5370 - 5370   ER27765   5371 - 5371   ER27766   5372 - 5372 
      ER27767   5373 - 5373   ER27768   5374 - 5374   ER27769   5375 - 5375 
      ER27770   5376 - 5376   ER27771   5377 - 5377   ER27772   5378 - 5378 
      ER27773   5379 - 5379   ER27774   5380 - 5380   ER27775   5381 - 5387 
      ER27776   5388 - 5388   ER27777   5389 - 5389   ER27778   5390 - 5390 
      ER27779   5391 - 5391   ER27780   5392 - 5392   ER27781   5393 - 5393 
      ER27782   5394 - 5394   ER27783   5395 - 5395   ER27784   5396 - 5396 
      ER27785   5397 - 5397   ER27786   5398 - 5398   ER27787   5399 - 5399 
      ER27788   5400 - 5400   ER27789   5401 - 5401   ER27790   5402 - 5408 
      ER27791   5409 - 5409   ER27792   5410 - 5410   ER27793   5411 - 5411 
      ER27794   5412 - 5412   ER27795   5413 - 5413   ER27796   5414 - 5414 
      ER27797   5415 - 5415   ER27798   5416 - 5416   ER27799   5417 - 5417 
      ER27800   5418 - 5418   ER27801   5419 - 5419   ER27802   5420 - 5420 
      ER27803   5421 - 5421   ER27804   5422 - 5422   ER27805   5423 - 5429 
      ER27806   5430 - 5430   ER27807   5431 - 5431   ER27808   5432 - 5432 
      ER27809   5433 - 5433   ER27810   5434 - 5434   ER27811   5435 - 5435 
      ER27812   5436 - 5436   ER27813   5437 - 5437   ER27814   5438 - 5438 
      ER27815   5439 - 5439   ER27816   5440 - 5440   ER27817   5441 - 5441 
      ER27818   5442 - 5442   ER27819   5443 - 5443   ER27820   5444 - 5450 
      ER27821   5451 - 5451   ER27822   5452 - 5452   ER27823   5453 - 5453 
      ER27824   5454 - 5454   ER27825   5455 - 5455   ER27826   5456 - 5456 
      ER27827   5457 - 5457   ER27828   5458 - 5458   ER27829   5459 - 5459 
      ER27830   5460 - 5460   ER27831   5461 - 5461   ER27832   5462 - 5462 
      ER27833   5463 - 5463   ER27834   5464 - 5464   ER27835   5465 - 5471 
      ER27836   5472 - 5472   ER27837   5473 - 5473   ER27838   5474 - 5474 
      ER27839   5475 - 5475   ER27840   5476 - 5476   ER27841   5477 - 5477 
      ER27842   5478 - 5478   ER27843   5479 - 5479   ER27844   5480 - 5480 
      ER27845   5481 - 5481   ER27846   5482 - 5482   ER27847   5483 - 5483 
      ER27848   5484 - 5484   ER27849   5485 - 5485   ER27850   5486 - 5492 
      ER27851   5493 - 5493   ER27852   5494 - 5494   ER27853   5495 - 5495 
      ER27854   5496 - 5496   ER27855   5497 - 5497   ER27856   5498 - 5498 
      ER27857   5499 - 5499   ER27858   5500 - 5500   ER27859   5501 - 5501 
      ER27860   5502 - 5502   ER27861   5503 - 5503   ER27862   5504 - 5504 
      ER27863   5505 - 5505   ER27864   5506 - 5506   ER27865   5507 - 5513 
      ER27866   5514 - 5514   ER27867   5515 - 5515   ER27868   5516 - 5516 
      ER27869   5517 - 5517   ER27870   5518 - 5518   ER27871   5519 - 5519 
      ER27872   5520 - 5520   ER27873   5521 - 5521   ER27874   5522 - 5522 
      ER27875   5523 - 5523   ER27876   5524 - 5524   ER27877   5525 - 5525 
      ER27878   5526 - 5526   ER27879   5527 - 5527   ER27880   5528 - 5530 
      ER27881   5531 - 5531   ER27882   5532 - 5533   ER27883   5534 - 5537 
      ER27884   5538 - 5540   ER27885   5541 - 5544   ER27886   5545 - 5548 
      ER27887   5549 - 5552   ER27888   5553 - 5556   ER27889   5557 - 5560 
      ER27890   5561 - 5564   ER27891   5565 - 5568   ER27892   5569 - 5572 
      ER27893   5573 - 5576   ER27894   5577 - 5580   ER27895   5581 - 5583 
      ER27896   5584 - 5587   ER27897   5588 - 5591   ER27898   5592 - 5595 
      ER27899   5596 - 5599   ER27900   5600 - 5603   ER27901   5604 - 5607 
      ER27902   5608 - 5611   ER27903   5612 - 5615   ER27904   5616 - 5619 
      ER27905   5620 - 5626   ER27906   5627 - 5627   ER27907   5628 - 5628 
      ER27908   5629 - 5635   ER27909   5636 - 5636   ER27910   5637 - 5643 
      ER27911   5644 - 5650   ER27912   5651 - 5651   ER27913   5652 - 5658 
      ER27914   5659 - 5659   ER27915   5660 - 5665   ER27916   5666 - 5666 
      ER27917   5667 - 5672   ER27918   5673 - 5673   ER27919   5674 - 5679 
      ER27920   5680 - 5680   ER27921   5681 - 5686   ER27922   5687 - 5687 
      ER27923   5688 - 5694   ER27924   5695 - 5695   ER27925   5696 - 5702 
      ER27926   5703 - 5703   ER27927   5704 - 5710   ER27928   5711 - 5711 
      ER27929   5712 - 5717   ER27930   5718 - 5718   ER27931   5719 - 5725 
      ER27932   5726 - 5731   ER27933   5732 - 5732   ER27934   5733 - 5738 
      ER27935   5739 - 5739   ER27936   5740 - 5745   ER27937   5746 - 5746 
      ER27938   5747 - 5752   ER27939   5753 - 5753   ER27940   5754 - 5760 
      ER27941   5761 - 5767   ER27942   5768 - 5768   ER27943   5769 - 5775 
      ER27944   5776 - 5776   ER27945   5777 - 5782   ER27946   5783 - 5783 
      ER27947   5784 - 5789   ER27948   5790 - 5790   ER27949   5791 - 5796 
      ER27950   5797 - 5797   ER27951   5798 - 5803   ER27952   5804 - 5804 
      ER27953   5805 - 5811   ER27954   5812 - 5817   ER27955   5818 - 5818 
      ER27956   5819 - 5824   ER27957   5825 - 5825   ER27958   5826 - 5831 
      ER27959   5832 - 5832   ER27960   5833 - 5838   ER27961   5839 - 5839 
      ER27962   5840 - 5845   ER27963   5846 - 5846   ER27964   5847 - 5852 
      ER27965   5853 - 5853   ER27966   5854 - 5859   ER27967   5860 - 5860 
      ER27968   5861 - 5866   ER27969   5867 - 5867   ER27970   5868 - 5873 
      ER27971   5874 - 5874   ER27972   5875 - 5880   ER27973   5881 - 5881 
      ER27974   5882 - 5887   ER27975   5888 - 5888   ER27976   5889 - 5894 
      ER27977   5895 - 5895   ER27978   5896 - 5901   ER27979   5902 - 5902 
      ER27980   5903 - 5908   ER27981   5909 - 5909   ER27982   5910 - 5915 
      ER27983   5916 - 5916   ER27984   5917 - 5922   ER27985   5923 - 5923 
      ER27986   5924 - 5929   ER27987   5930 - 5930   ER27988   5931 - 5936 
      ER27989   5937 - 5937   ER27990   5938 - 5943   ER27991   5944 - 5944 
      ER27992   5945 - 5950   ER27993   5951 - 5951   ER27994   5952 - 5957 
      ER27995   5958 - 5958   ER27996   5959 - 5964   ER27997   5965 - 5965 
      ER27998   5966 - 5971   ER27999   5972 - 5972   ER28000   5973 - 5978 
      ER28001   5979 - 5979   ER28002   5980 - 5986   ER28003   5987 - 5992 
      ER28004   5993 - 5998   ER28005   5999 - 6005   ER28006   6006 - 6006 
      ER28007   6007 - 6012   ER28008   6013 - 6013   ER28009   6014 - 6020 
      ER28010   6021 - 6026   ER28011   6027 - 6027   ER28012   6028 - 6033 
      ER28013   6034 - 6034   ER28014   6035 - 6040   ER28015   6041 - 6041 
      ER28016   6042 - 6047   ER28017   6048 - 6048   ER28018   6049 - 6054 
      ER28019   6055 - 6055   ER28020   6056 - 6061   ER28021   6062 - 6062 
      ER28022   6063 - 6068   ER28023   6069 - 6069   ER28024   6070 - 6075 
      ER28025   6076 - 6076   ER28026   6077 - 6082   ER28027   6083 - 6083 
      ER28028   6084 - 6089   ER28029   6090 - 6090   ER28030   6091 - 6096 
      ER28031   6097 - 6102   ER28032   6103 - 6103   ER28033   6104 - 6109 
      ER28034   6110 - 6110   ER28035   6111 - 6116   ER28036   6117 - 6117 
      ER28037   6118 - 6124   ER28038   6125 - 6129   ER28039   6130 - 6134 
      ER28040   6135 - 6139   ER28041   6140 - 6144   ER28042   6145 - 6145 
      ER28043   6146 - 6147   ER28044   6148 - 6148   ER28045   6149 - 6149 
      ER28046   6150 - 6150   ER28047   6151 - 6152   ER28048   6153 - 6154 
      ER28049   6155 - 6155   ER28050   6156 - 6156   ER28051   6157 - 6157 
      ER28052   6158 - 6161   ER28053   6162 - 6165   ER28054   6166 - 6166 
      ER28055   6167 - 6167   ER28056   6168 - 6172   ER28057   6173 - 6177 
      ER28058   6178 - 6178   ER28059   6179 - 6180   ER28060   6181 - 6185 
      ER28061   6186 - 6186   ER28062   6187 - 6188   ER28063   6189 - 6193 
      ER28064   6194 - 6194   ER28065   6195 - 6196   ER28066   6197 - 6201 
      ER28067   6202 - 6202   ER28068   6203 - 6204   ER28069   6205 - 6209 
      ER28070   6210 - 6210   ER28071   6211 - 6211   ER28072   6212 - 6212 
      ER28073   6213 - 6213   ER28074   6214 - 6214   ER28075   6215 - 6215 
      ER28076   6216 - 6216   ER28077   6217 - 6217   ER28078   6218 - 6224 
   ;

  file rawdat lrecl=6224;
  put    
ER25002
ER25003
ER25007
ER25009
ER25012
ER25013
ER25014
ER25016
ER25017
ER25018
ER25019
ER25023
ER25028
ER25029
ER25030
ER25036
ER25037
ER25038
ER25039
ER25040
ER25041
ER25042
ER25043
ER25044
ER25045
ER25046
ER25047
ER25048
ER25049
ER25050
ER25051
ER25052
ER25053
ER25054
ER25055
ER25056
ER25057
ER25058
ER25059
ER25060
ER25063
ER25064
ER25065
ER25098
ER25099
ER25100
ER25101
ER25104
ER25105
ER25106
ER25129
ER25160
ER25161
ER25162
ER25173
ER25358
ER25359
ER25360
ER25362
ER25363
ER25364
ER25387
ER25418
ER25419
ER25420
ER25431
ER25616
ER25617
ER25618
ER25655
ER25656
ER25686
ER25688
ER25689
ER25690
ER25692
ER25693
ER25694
ER25695
ER25696
ER25697
ER25698
ER25699
ER25700
ER25702
ER25703
ER25704
ER25705
ER25706
ER25707
ER25709
ER25710
ER25713
ER25716
ER25717
ER25718
ER25723
ER25726
ER25727
ER25728
ER25729
ER25730
ER25731
ER25732
ER25734
ER25735
ER25738
ER25741
ER25744
ER25745
ER25746
ER25751
ER25754
ER25755
ER25756
ER25757
ER25758
ER25759
ER25760
ER25762
ER25763
ER25766
ER25769
ER25772
ER25773
ER25774
ER25779
ER25782
ER25783
ER25784
ER25785
ER25786
ER25787
ER25788
ER25790
ER25791
ER25794
ER25795
ER25797
ER25798
ER25799
ER25800
ER25801
ER25802
ER25803
ER25805
ER25807
ER25808
ER25809
ER25813
ER25814
ER25818
ER25819
ER25823
ER25824
ER25828
ER25829
ER25834
ER25838
ER25911
ER25915
ER25917
ER25921
ER25924
ER25928
ER25932
ER25949
ER25982
ER25984
ER25985
ER26001
ER26002
ER26333
ER26334
ER26335
ER26513
ER26519
ER26535
ER26539
ER26544
ER26549
ER26569
ER26570
ER26571
ER26577
ER26598
ER26603
ER26634
ER26672
ER26683
ER26995
ER27306
ER27314
ER27317
ER27321
ER27352
ER27393
ER27402
ER27410
ER27413
ER27417
ER27883
ER27884
ER27885
ER27886
ER27887
ER27888
ER27894
ER27895
ER27896
ER27897
ER27898
ER27899
ER27910
ER27931
ER27940
ER27943
ER27944
ER27953
ER28002
ER28009
ER28010
ER28031
ER28033
ER28035
ER28037
ER28038
ER28042
ER28078
;

proc means;
run;

PROC PRINTTO PRINT=PRINT;
RUN; 

PROC PRINTTO LOG=LOG;
RUN; 